/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class UnionTest
extends TestCase {
    public void testCalculateSize() {
        SizedUnion u = new SizedUnion();
        UnionTest.assertEquals((String)"Union should be size of largest field", (int)new BigTestStructure().size(), (int)u.size());
    }

    public void testFieldOffsets() {
        StructUnion u = new StructUnion();
        u.setType(((Object)((Object)u.testStruct)).getClass());
        u.write();
        UnionTest.assertEquals((String)"Wrong struct member base address", (Object)u.getPointer(), (Object)u.testStruct.getPointer());
        u.setType(((Object)((Object)u.intStruct)).getClass());
        u.write();
        UnionTest.assertEquals((String)"Wrong struct member base address (2)", (Object)u.getPointer(), (Object)u.intStruct.getPointer());
    }

    public void testWriteUnion() {
        SizedUnion u = new SizedUnion();
        int VALUE = 305419896;
        u.intField = 305419896;
        u.setType(Integer.TYPE);
        u.write();
        UnionTest.assertEquals((String)"Wrong value written", (int)305419896, (int)u.getPointer().getInt(0L));
    }

    public void testReadUnion() {
        SizedUnion u = new SizedUnion();
        int VALUE = 305419896;
        u.getPointer().setInt(0L, 305419896);
        u.read();
        UnionTest.assertEquals((String)"int field not read properly", (int)305419896, (int)u.intField);
        UnionTest.assertTrue((String)"byte field not read", (u.byteField != 0 ? 1 : 0) != 0);
        UnionTest.assertTrue((String)"short field not read", (u.shortField != 0 ? 1 : 0) != 0);
        UnionTest.assertTrue((String)"long field not read", (u.longField != 0L ? 1 : 0) != 0);
        UnionTest.assertNotNull((String)"Unselected Pointer not read", (Object)u.pointer);
        UnionTest.assertNotNull((String)"Union struct field should be initialized", (Object)((Object)u.structField));
        UnionTest.assertNull((String)"Unselected structure should not be read", (Object)u.structField.value);
        UnionTest.assertNull((String)"Unselected String should be null", (Object)u.string);
        UnionTest.assertNull((String)"Unselected WString should be null", (Object)u.wstring);
    }

    public void testWriteTypedUnion() {
        int VALUE = 305419896;
        StructUnion u = new StructUnion();
        IntStructure intStruct = new IntStructure();
        intStruct.value = 305419896;
        u.setTypedValue((Object)intStruct);
        u.write();
        UnionTest.assertEquals((String)"Wrong value written", (int)305419896, (int)u.getPointer().getInt(0L));
        u = new StructUnion();
        SubIntStructure subIntStructure = new SubIntStructure();
        subIntStructure.value = 305419896;
        u.setTypedValue((Object)subIntStructure);
        u.write();
        UnionTest.assertEquals((String)"Wrong value written", (int)305419896, (int)u.getPointer().getInt(0L));
        u = new StructUnion();
        Func1 func1 = new Func1(){

            public void callback() {
                System.out.println("hi");
            }
        };
        u.setTypedValue(func1);
    }

    public void testReadTypedUnion() {
        StructUnion u = new StructUnion();
        int VALUE = 305419896;
        u.getPointer().setInt(0L, 305419896);
        UnionTest.assertEquals((String)"int structure not read properly", (int)305419896, (int)((IntStructure)((Object)u.getTypedValue(IntStructure.class))).value);
    }

    public void testReadTypeInfo() {
        SizedUnion u = new SizedUnion();
        if (Native.POINTER_SIZE == 4) {
            UnionTest.assertEquals((String)"Type size should be that of longest field if no field active", (int)Structure.getTypeInfo(BigTestStructure.class).getInt(0L), (int)u.getTypeInfo().getInt(0L));
        } else {
            UnionTest.assertEquals((String)"Type size should be that of longest field if no field active", (long)Structure.getTypeInfo(BigTestStructure.class).getLong(0L), (long)u.getTypeInfo().getLong(0L));
        }
        u.setType(Integer.TYPE);
        if (Native.POINTER_SIZE == 4) {
            UnionTest.assertEquals((String)"Type size should be that of longest field if field active", (int)Structure.getTypeInfo(BigTestStructure.class).getInt(0L), (int)u.getTypeInfo().getInt(0L));
        } else {
            UnionTest.assertEquals((String)"Type size should be that of longest field if field active", (long)Structure.getTypeInfo(BigTestStructure.class).getLong(0L), (long)u.getTypeInfo().getLong(0L));
        }
    }

    public void testArraysInUnion() {
        class TestUnion
        extends Union {
            public byte[] bytes = new byte[16];
            public short[] shorts = new short[8];
            public int[] ints = new int[4];

            TestUnion() {
            }
        }
        TestUnion u = new TestUnion();
        u.setType(byte[].class);
        u.setType(short[].class);
        u.setType(int[].class);
    }

    public void testDuplicateFieldTypes() {
        class TestUnion
        extends Union {
            public int field1;
            public int field2;

            TestUnion() {
            }
        }
        TestUnion u = new TestUnion();
        u.setType("field1");
        u.field1 = 42;
        u.write();
        u.setType("field2");
        u.read();
        UnionTest.assertEquals((String)"Wrong field value after write/read", (int)42, (int)u.field2);
    }

    public static void main(String[] args) {
        TestRunner.run(UnionTest.class);
    }

    public static class StructUnion
    extends Union {
        public int intField;
        public TestStructure testStruct;
        public IntStructure intStruct;
        public Func1 func1;
    }

    public static class SizedUnion
    extends Union {
        public byte byteField;
        public short shortField;
        public int intField;
        public long longField;
        public TestStructure structField;
        public BigTestStructure structField2;
        public String string;
        public WString wstring;
        public Pointer pointer;
    }

    public static interface Func1
    extends Callback {
        public void callback();
    }

    public static class SubIntStructure
    extends IntStructure {
    }

    public static class IntStructure
    extends Structure {
        public int value;

        protected List getFieldOrder() {
            return Arrays.asList("value");
        }
    }

    public static class BigTestStructure
    extends Structure {
        public long field1;
        public long field2;

        protected List getFieldOrder() {
            return Arrays.asList("field1", "field2");
        }
    }

    public static class TestStructure
    extends Structure {
        public String value;

        protected List getFieldOrder() {
            return Arrays.asList("value");
        }
    }
}

