/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.Recording;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public abstract class BaseRecording
implements Recording {
    protected final Header header;
    protected final File fileOnDisk;

    public BaseRecording(Header header, File fileOnDisk) {
        this.header = header;
        this.fileOnDisk = fileOnDisk;
    }

    public long getDbVersion() {
        return this.header.dbVersion;
    }

    public long getWriteTimeStamp() {
        return this.header.writeTimeStamp;
    }

    public int getFormat() {
        return this.header.format;
    }

    public File getFile() {
        return this.fileOnDisk;
    }

    public static class Header {
        protected long dbVersion;
        protected long writeTimeStamp;
        protected int format;

        Header(DataInputStream in) throws IOException {
            this.read(in);
        }

        public Header(long dbVersion, long writeTimeStamp, int format) {
            this.dbVersion = dbVersion;
            this.writeTimeStamp = writeTimeStamp;
            this.format = format;
        }

        protected void read(DataInputStream in) throws IOException {
            this.dbVersion = in.readLong();
            this.writeTimeStamp = in.readLong();
            this.format = in.read();
        }

        protected void write(DataOutputStream out) throws IOException {
            out.writeLong(this.dbVersion);
            out.writeLong(this.writeTimeStamp);
            out.write(this.format);
        }

        public long getWriteTimeStamp() {
            return this.writeTimeStamp;
        }

        public long getDbVersion() {
            return this.dbVersion;
        }

        public int getFormat() {
            return this.format;
        }

        public String toString() {
            return "Header[dbVersion=" + this.dbVersion + ", writeTimeStamp=" + this.writeTimeStamp + ", format=" + this.format + "]";
        }
    }
}

