/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.BaseRecording;
import com.cenqua.clover.CoverageRecording;
import com.cenqua.clover.FOSFactory;
import com.cenqua.clover.util.CoverageUtils;
import com.cenqua.clover.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public interface LiveCoverageRecording
extends CoverageRecording {
    public void transcribe() throws IOException;

    public static class ToFile
    extends BaseRecording
    implements LiveCoverageRecording {
        private static Class[] REQUIRED_CLASSES;
        private static final boolean USE_RLE_COMPRESSION;
        private int[] elements;
        static /* synthetic */ Class class$com$cenqua$clover$FOSFactory;
        static /* synthetic */ Class class$java$io$FileNotFoundException;
        static /* synthetic */ Class class$java$io$IOException;
        static /* synthetic */ Class class$java$io$BufferedOutputStream;
        static /* synthetic */ Class class$java$io$DataOutputStream;
        static /* synthetic */ Class class$java$io$FileOutputStream;
        static /* synthetic */ Class class$java$io$OutputStream;
        static /* synthetic */ Class class$java$util$zip$DeflaterOutputStream;
        static /* synthetic */ Class class$java$util$zip$Deflater;

        public ToFile(String path, long dbVersion, long timeStamp, int[] elements) {
            super(new BaseRecording.Header(dbVersion, timeStamp, 0), new File(path));
            this.elements = elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transcribe() throws IOException {
            DataOutputStream out = new DataOutputStream(FileUtils.createDeflateOutputStream(this.fileOnDisk.getAbsolutePath()));
            try {
                this.header.write(out);
                out.writeInt(this.elements.length);
                if (USE_RLE_COMPRESSION) {
                    CoverageUtils.rleCompressAndWriteCoverage(out, this.elements);
                } else {
                    CoverageUtils.writeUncompressedCoverage(out, this.elements);
                }
                out.flush();
            }
            finally {
                FileUtils.close(out);
            }
        }

        public static void flushToDisk(String dbname, long dbversion, long writeTS, int[] elements) throws IOException {
            new ToFile(dbname, dbversion, writeTS, elements).transcribe();
        }

        static {
            Class<?> clazz;
            Class clazz2;
            Class clazz3;
            Class clazz4;
            Class clazz5;
            Class clazz6;
            Class clazz7;
            Class clazz8;
            Class[] classArray = new Class[9];
            Class clazz9 = class$java$io$IOException;
            if (clazz9 == null) {
                clazz9 = classArray[0] = (class$java$io$IOException = new IOException[0].getClass().getComponentType());
            }
            if ((clazz8 = class$java$io$DataOutputStream) == null) {
                clazz8 = classArray[1] = (class$java$io$DataOutputStream = new DataOutputStream[0].getClass().getComponentType());
            }
            if ((clazz7 = class$java$io$OutputStream) == null) {
                clazz7 = classArray[2] = (class$java$io$OutputStream = new OutputStream[0].getClass().getComponentType());
            }
            if ((clazz6 = class$java$io$FileNotFoundException) == null) {
                clazz6 = classArray[3] = (class$java$io$FileNotFoundException = new FileNotFoundException[0].getClass().getComponentType());
            }
            if ((clazz5 = class$java$io$BufferedOutputStream) == null) {
                clazz5 = classArray[4] = (class$java$io$BufferedOutputStream = new BufferedOutputStream[0].getClass().getComponentType());
            }
            if ((clazz4 = class$java$io$FileOutputStream) == null) {
                clazz4 = classArray[5] = (class$java$io$FileOutputStream = new FileOutputStream[0].getClass().getComponentType());
            }
            if ((clazz3 = class$java$util$zip$Deflater) == null) {
                clazz3 = classArray[6] = (class$java$util$zip$Deflater = new Deflater[0].getClass().getComponentType());
            }
            if ((clazz2 = class$java$util$zip$DeflaterOutputStream) == null) {
                clazz2 = classArray[7] = (class$java$util$zip$DeflaterOutputStream = new DeflaterOutputStream[0].getClass().getComponentType());
            }
            if ((clazz = class$com$cenqua$clover$FOSFactory) == null) {
                clazz = class$com$cenqua$clover$FOSFactory = new FOSFactory[0].getClass().getComponentType();
            }
            classArray[8] = clazz;
            REQUIRED_CLASSES = classArray;
            USE_RLE_COMPRESSION = Boolean.valueOf(System.getProperty("clover.rle.coverage", Boolean.TRUE.toString()));
        }
    }
}

