/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.InstrumentationState;
import com_cenqua_clover.Clover;
import com_cenqua_clover.CloverVersionInfo;
import com_cenqua_clover.CoverageRecorder;

public class RecorderInstrEmitter
extends Emitter {
    private static final String INCOMPATIBLE_MSG = "[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.";
    private static final String CLASSNOTFOUND_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised. Are you sure you have Clover in the runtime classpath?";
    private boolean isEnum;
    private boolean reportInitErrors;
    private boolean classInstrStrategy;
    private String recorderPrefix;
    private long recorderCfg;
    private String initString;
    private long registryVersion;
    private int maxDataIndex;
    private String javaLangPrefix;
    private boolean testClass;
    private String distributedConfig;
    static /* synthetic */ Class class$com_cenqua_clover$CloverVersionInfo;
    static /* synthetic */ Class class$com_cenqua_clover$CoverageRecorder;
    static /* synthetic */ Class class$com_cenqua_clover$Clover;

    public RecorderInstrEmitter(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public void init(InstrumentationState state) {
        this.recorderCfg = RecorderInstrEmitter.getConfigBits(state.getCfg());
        this.recorderPrefix = state.getRecorderPrefix();
        this.classInstrStrategy = state.getCfg().isClassInstrStrategy();
        this.reportInitErrors = state.getCfg().isReportInitErrors();
        this.initString = state.getCfg().getInitString();
        this.distributedConfig = state.getCfg().getDistributedConfigString();
        this.registryVersion = state.getRegistry().getVersion();
        this.javaLangPrefix = state.getCfg().getJavaLangPrefix();
        this.testClass = state.isDetectTests();
    }

    public String getInstr() {
        String instrString;
        if (this.classInstrStrategy || this.isEnum) {
            String recorderBase = this.recorderPrefix.substring(0, this.recorderPrefix.lastIndexOf(46));
            String recorderSuffix = this.recorderPrefix.substring(this.recorderPrefix.lastIndexOf(46) + 1);
            StringBuffer stringBuffer = new StringBuffer().append(this.testClass ? "" : "public ").append("static class ").append(recorderBase).append("{").append("public static ");
            Class<?> clazz = class$com_cenqua_clover$CoverageRecorder;
            if (clazz == null) {
                clazz = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            instrString = stringBuffer.append(clazz.getName()).append(" ").append(recorderSuffix).append(";").append("static{").toString();
            if (this.reportInitErrors) {
                StringBuffer stringBuffer2 = new StringBuffer().append(instrString).append("try{if(").append(CloverVersionInfo.getBuildStamp()).append("L!=");
                Class<?> clazz2 = class$com_cenqua_clover$CloverVersionInfo;
                if (clazz2 == null) {
                    clazz2 = class$com_cenqua_clover$CloverVersionInfo = new CloverVersionInfo[0].getClass().getComponentType();
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append(".getBuildStamp())").append("{");
                Class<?> clazz3 = class$com_cenqua_clover$Clover;
                if (clazz3 == null) {
                    clazz3 = class$com_cenqua_clover$Clover = new Clover[0].getClass().getComponentType();
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append(".l(\"").append(INCOMPATIBLE_MSG).append("\");");
                Class<?> clazz4 = class$com_cenqua_clover$Clover;
                if (clazz4 == null) {
                    clazz4 = class$com_cenqua_clover$Clover = new Clover[0].getClass().getComponentType();
                }
                StringBuffer stringBuffer5 = stringBuffer4.append(clazz4.getName()).append(".l(\"[CLOVER] WARNING: Instr=").append(CloverVersionInfo.getReleaseNum()).append("#").append(CloverVersionInfo.getBuildStamp()).append(",Runtime=\"+");
                Class<?> clazz5 = class$com_cenqua_clover$CloverVersionInfo;
                if (clazz5 == null) {
                    clazz5 = class$com_cenqua_clover$CloverVersionInfo = new CloverVersionInfo[0].getClass().getComponentType();
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append(".getReleaseNum() + \"#\"+");
                Class<?> clazz6 = class$com_cenqua_clover$CloverVersionInfo;
                if (clazz6 == null) {
                    clazz6 = class$com_cenqua_clover$CloverVersionInfo = new CloverVersionInfo[0].getClass().getComponentType();
                }
                instrString = stringBuffer6.append(clazz6.getName()).append(".getBuildStamp());}").toString();
            }
            StringBuffer stringBuffer7 = new StringBuffer().append(instrString).append(recorderSuffix).append("=");
            Class<?> clazz7 = class$com_cenqua_clover$Clover;
            if (clazz7 == null) {
                clazz7 = class$com_cenqua_clover$Clover = new Clover[0].getClass().getComponentType();
            }
            instrString = stringBuffer7.append(clazz7.getName()).append(".getRecorder(").append(RecorderInstrEmitter.asCharArrayStr(this.initString)).append(",").append(RecorderInstrEmitter.asCharArrayStr(this.distributedConfig)).append(",").append(this.registryVersion).append("L,").append(this.recorderCfg).append("L,").append(this.maxDataIndex).append(");").toString();
            if (this.reportInitErrors) {
                instrString = instrString + "}catch(" + this.javaLangPrefix + "Throwable t){" + this.javaLangPrefix + "System.err.println(\"" + CLASSNOTFOUND_MSG + " (\"+t.getClass()+\":\"+t.getMessage()+\")\");}";
            }
            instrString = instrString + "}}";
        } else {
            StringBuffer stringBuffer = new StringBuffer().append("public static ");
            Class<?> clazz = class$com_cenqua_clover$CoverageRecorder;
            if (clazz == null) {
                clazz = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            StringBuffer stringBuffer8 = stringBuffer.append(clazz.getName()).append(" ").append(this.recorderPrefix).append("=");
            Class<?> clazz8 = class$com_cenqua_clover$Clover;
            if (clazz8 == null) {
                clazz8 = class$com_cenqua_clover$Clover = new Clover[0].getClass().getComponentType();
            }
            instrString = stringBuffer8.append(clazz8.getName()).append(".getRecorder(").append(RecorderInstrEmitter.asCharArrayStr(this.initString)).append(",").append(RecorderInstrEmitter.asCharArrayStr(this.distributedConfig)).append(",").append(this.registryVersion).append("L,").append(this.recorderCfg).append("L);").toString();
        }
        return instrString;
    }

    public static String asCharArrayStr(String str) {
        if (str == null) {
            return "null";
        }
        String res = "new char[]{";
        for (int i = 0; i < str.length(); ++i) {
            res = res + str.charAt(i);
            if (i + 1 >= str.length()) continue;
            res = res + ",";
        }
        res = res + "}";
        return res;
    }

    public void setMaxDataIndex(int maxIndex) {
        this.maxDataIndex = maxIndex;
    }

    private static long getConfigBits(InstrumentationConfig cfg) {
        return CoverageRecorder.getConfigBits(cfg.getFlushPolicy(), cfg.getFlushInterval(), false, false, !cfg.isSliceRecording());
    }
}

