/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.SourceRegion;

public class BaseClassInfo
extends SourceRegion
implements HasMetrics {
    private static final long serialVersionUID = -8072171900253180307L;
    protected String name;
    protected BasePackageInfo packageInfo;
    protected boolean typeInterface;
    protected boolean typeEnum;
    protected boolean typeAnnotation;
    protected boolean testClass;
    protected transient BlockMetrics rawMetrics;
    protected transient BlockMetrics metrics;
    protected transient ContextSet contextFilter;

    public BaseClassInfo(BasePackageInfo packageInfo, BaseFileInfo containingFile, SourceRegion region, String name, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        super(containingFile, region);
        this.name = name;
        this.packageInfo = packageInfo;
        this.typeInterface = typeInterface;
        this.typeEnum = typeEnum;
        this.typeAnnotation = typeAnnotation;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.packageInfo.isDefault() ? this.getName() : this.packageInfo.getName() + "." + this.getName();
    }

    public BasePackageInfo getPackage() {
        return this.packageInfo;
    }

    public boolean isInterface() {
        return this.typeInterface;
    }

    public boolean isEnum() {
        return this.typeEnum;
    }

    public boolean isAnnotationType() {
        return this.typeAnnotation;
    }

    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public boolean isTestClass() {
        return this.testClass;
    }

    public ContextSet getContextFilter() {
        return this.getContainingFile().getContextFilter();
    }

    public String toString() {
        return "[" + this.getQualifiedName() + ",test=" + this.isTestClass() + ",if=" + this.isInterface() + ",enum=" + this.isEnum() + ",anno=" + this.isAnnotationType() + "]";
    }
}

