/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.cenqua.clover.Logger;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.util.FilterUtils;

public class TestSelectionHelper {
    public static final String TESTS_INCLUDE_PATTERN_PARAM = "--testsIncludePattern";
    public static final String TESTS_EXCLUDE_PATTERN_PARAM = "--testsExcludePattern";
    public static final String SOURCE_ROOT_PARAM = "--sourceRoot";

    private TestSelectionHelper() {
    }

    public static String getParamsUsage() {
        return "         --testsIncludePattern <string>\tAnt-style pattern of files containing test classes and utilities.\n\t\t\t\tIf unspecified Clover uses default test detection logic.\n\n         --testsExcludePattern <string>\tAnt-style pattern of files NOT containing test classes and utilities.\n\n         --sourceRoot <string>\tSource root path prefix that will be ignored when evaluating the test inclusion patterns.\n\n";
    }

    public static void configureTestSelectionFilter(Current cfg, String[] args) {
        String includeFilter = null;
        String excludeFilter = null;
        String sourceRoot = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(TESTS_INCLUDE_PATTERN_PARAM)) {
                includeFilter = args[++i];
                continue;
            }
            if (args[i].equals(TESTS_EXCLUDE_PATTERN_PARAM)) {
                excludeFilter = args[++i];
                continue;
            }
            if (!args[i].equals(SOURCE_ROOT_PARAM)) continue;
            sourceRoot = args[++i];
        }
        if (includeFilter == null && excludeFilter == null) {
            return;
        }
        String[] includes = includeFilter == null ? new String[]{} : FilterUtils.tokenizePattern(includeFilter);
        String[] excludes = excludeFilter == null ? new String[]{} : FilterUtils.tokenizePattern(excludeFilter);
        Current.AntPatternTestFilter filter = new Current.AntPatternTestFilter(sourceRoot, includes, excludes);
        cfg.setTestFilter(filter);
        Logger.getInstance().verbose("Setting up Ant-pattern based test filter.");
    }
}

