/* $XFree86: test/xsuite/xtest/tset/XFree86/drwln/drwln.m,v 1.1 2000/03/31 17:22:39 dawes Exp $ */
/*
 
Copyright (c) 1990, 1991  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

 *
 * Copyright 1990, 1991 by UniSoft Group Limited.
 * 
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of UniSoft not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  UniSoft
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * $XConsortium: drwln.m,v 1.5 94/04/17 21:04:49 rws Exp $

 *
 * Original file: CH06/drwln/drwln.m
 * Modified Mon Nov  8 06:23:42 1999:
 *     by Rickard E. (Rik) Faith <faith@precisioninsight.com>
 *     added tests for XAA's dashed line acceleration
 *

 */
>>TITLE XDrawLine XFree86
void
XDrawLine(display, d, gc, x1, y1, x2, y2);
Display		*display = Dsp;
Drawable	d;
GC		gc;
int 	x1 = 10;
int 	y1 = 10;
int 	x2 = 47;
int 	y2 = 37;
>>EXTERN
static	int 	linestyles[] = {LineSolid, LineOnOffDash, LineDoubleDash};
static	int 	capstyles[] = {CapNotLast, CapButt, CapProjecting, CapRound};

static char	lsdashes[] = {14,14};
>>ASSERTION Good A
A call to xname draws a non-power-of-two solid dashed
line between the pair of points
.A "" ( x1 , y1 )
and
.A "" ( x2 , y2 )
in the drawable
.A d .
>>STRATEGY
Draw line
Pixmap check
>>CODE
XVisualInfo *vp;
unsigned char dash_list0[] = { 1, 2, 1, 2 };
unsigned char dash_list1[] = { 3, 4, 3, 1 };
int dash_list_len = 4;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		d = makewin(display, vp);
		gc = makegc(display, d);

                /* Draw something to test lack of transparency */
		XSetDashes(display, gc, 0, dash_list0, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;

		XSetDashes(display, gc, 0, dash_list1, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;
		PIXCHECK(display, d);
	}
	CHECKPASS(nvinf());

>>ASSERTION Good A
A call to xname draws a non-power-of-two solid phased dashed
line between the pair of points
.A "" ( x1 , y1 )
and
.A "" ( x2 , y2 )
in the drawable
.A d .
>>STRATEGY
Draw line
Pixmap check
>>CODE
XVisualInfo *vp;
unsigned char dash_list0[] = { 1, 2, 1, 2 };
unsigned char dash_list1[] = { 3, 4, 3, 1 };
int dash_list_len = 4;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		d = makewin(display, vp);
		gc = makegc(display, d);

                /* Draw something to test lack of transparency */
		XSetDashes(display, gc, 1, dash_list0, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;

		XSetDashes(display, gc, 1, dash_list1, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;
		PIXCHECK(display, d);
	}
	CHECKPASS(nvinf());

>>ASSERTION Good A
A call to xname draws a non-power-of-two transparent (on-off) dashed
line between the pair of points
.A "" ( x1 , y1 )
and
.A "" ( x2 , y2 )
in the drawable
.A d .
>>STRATEGY
Draw line
Pixmap check
>>CODE
XVisualInfo *vp;
unsigned char dash_list0[] = { 1, 2, 1, 2 };
unsigned char dash_list1[] = { 3, 4, 3, 1 };
int dash_list_len = 4;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		d = makewin(display, vp);
		gc = makegc(display, d);

                /* Draw something to test transparency */
		XSetDashes(display, gc, 0, dash_list0, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;

		XSetDashes(display, gc, 0, dash_list1, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineOnOffDash,
				   CapButt, JoinMiter);
		XCALL;
		PIXCHECK(display, d);
	}
	CHECKPASS(nvinf());

>>ASSERTION Good A
A call to xname draws a power-of-two solid dashed
line between the pair of points
.A "" ( x1 , y1 )
and
.A "" ( x2 , y2 )
in the drawable
.A d .
>>STRATEGY
Draw line
Pixmap check
>>CODE
XVisualInfo *vp;
unsigned char dash_list0[] = { 1, 2, 1 };
unsigned char dash_list1[] = { 2, 3, 3 };
int dash_list_len = 3;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		d = makewin(display, vp);
		gc = makegc(display, d);

                /* Draw something to test lack of transparency */
		XSetDashes(display, gc, 0, dash_list0, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;

		XSetDashes(display, gc, 0, dash_list1, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;
		PIXCHECK(display, d);
	}
	CHECKPASS(nvinf());

>>ASSERTION Good A
A call to xname draws a power-of-two solid phased dashed
line between the pair of points
.A "" ( x1 , y1 )
and
.A "" ( x2 , y2 )
in the drawable
.A d .
>>STRATEGY
Draw line
Pixmap check
>>CODE
XVisualInfo *vp;
unsigned char dash_list0[] = { 1, 2, 1 };
unsigned char dash_list1[] = { 2, 3, 3 };
int dash_list_len = 3;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		d = makewin(display, vp);
		gc = makegc(display, d);

                /* Draw something to test lack of transparency */
		XSetDashes(display, gc, 1, dash_list0, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;

		XSetDashes(display, gc, 1, dash_list1, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;
		PIXCHECK(display, d);
	}
	CHECKPASS(nvinf());

>>ASSERTION Good A
A call to xname draws a power-of-two transparent (on-off) dashed
line between the pair of points
.A "" ( x1 , y1 )
and
.A "" ( x2 , y2 )
in the drawable
.A d .
>>STRATEGY
Draw line
Pixmap check
>>CODE
XVisualInfo *vp;
unsigned char dash_list0[] = { 1, 2, 1 };
unsigned char dash_list1[] = { 2, 3, 3 };
int dash_list_len = 3;

	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {

		d = makewin(display, vp);
		gc = makegc(display, d);

                /* Draw something to test lack of transparency */
		XSetDashes(display, gc, 0, dash_list0, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineDoubleDash,
				   CapButt, JoinMiter);
		XCALL;

		XSetDashes(display, gc, 0, dash_list1, dash_list_len);
		XSetLineAttributes(display, gc, 0, LineOnOffDash,
				   CapButt, JoinMiter);
		XCALL;
		PIXCHECK(display, d);
	}
	CHECKPASS(nvinf());

