"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateToV15 = exports.updateToV14 = exports.updateToV13 = exports.updateToV12 = exports.updateToV11 = exports.updateToV10 = exports.updateToV9 = exports.updateToV8 = exports.updateToV7 = exports.updateToV6 = void 0;
const schematics_1 = require("@angular/cdk/schematics");
const hammer_gestures_migration_1 = require("./migrations/hammer-gestures-v9/hammer-gestures-migration");
const misc_class_inheritance_1 = require("./migrations/misc-checks/misc-class-inheritance");
const misc_class_names_1 = require("./migrations/misc-checks/misc-class-names");
const misc_imports_1 = require("./migrations/misc-checks/misc-imports");
const misc_property_names_1 = require("./migrations/misc-checks/misc-property-names");
const misc_template_1 = require("./migrations/misc-checks/misc-template");
const ripple_speed_factor_migration_1 = require("./migrations/misc-ripples-v7/ripple-speed-factor-migration");
const secondary_entry_points_migration_1 = require("./migrations/package-imports-v8/secondary-entry-points-migration");
const theming_api_migration_1 = require("./migrations/theming-api-v12/theming-api-migration");
const upgrade_data_1 = require("./upgrade-data");
const materialMigrations = [
    misc_class_inheritance_1.MiscClassInheritanceMigration,
    misc_class_names_1.MiscClassNamesMigration,
    misc_imports_1.MiscImportsMigration,
    misc_property_names_1.MiscPropertyNamesMigration,
    misc_template_1.MiscTemplateMigration,
    ripple_speed_factor_migration_1.RippleSpeedFactorMigration,
    secondary_entry_points_migration_1.SecondaryEntryPointsMigration,
    hammer_gestures_migration_1.HammerGesturesMigration,
    theming_api_migration_1.ThemingApiMigration,
];
/** Entry point for the migration schematics with target of Angular Material v6 */
function updateToV6() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V6, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV6 = updateToV6;
/** Entry point for the migration schematics with target of Angular Material v7 */
function updateToV7() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V7, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV7 = updateToV7;
/** Entry point for the migration schematics with target of Angular Material v8 */
function updateToV8() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V8, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV8 = updateToV8;
/** Entry point for the migration schematics with target of Angular Material v9 */
function updateToV9() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V9, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV9 = updateToV9;
/** Entry point for the migration schematics with target of Angular Material v10 */
function updateToV10() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V10, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV10 = updateToV10;
/** Entry point for the migration schematics with target of Angular Material v11 */
function updateToV11() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V11, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV11 = updateToV11;
/** Entry point for the migration schematics with target of Angular Material v12 */
function updateToV12() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V12, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV12 = updateToV12;
/** Entry point for the migration schematics with target of Angular Material v13 */
function updateToV13() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V13, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV13 = updateToV13;
/** Entry point for the migration schematics with target of Angular Material v14 */
function updateToV14() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V14, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV14 = updateToV14;
/** Entry point for the migration schematics with target of Angular Material v15 */
function updateToV15() {
    return (0, schematics_1.createMigrationSchematicRule)(schematics_1.TargetVersion.V15, materialMigrations, upgrade_data_1.materialUpgradeData, onMigrationComplete);
}
exports.updateToV15 = updateToV15;
/** Function that will be called when the migration completed. */
function onMigrationComplete(context, targetVersion, hasFailures) {
    context.logger.info('');
    context.logger.info(`  ✓  Updated Angular Material to ${targetVersion}`);
    context.logger.info('');
    if (hasFailures) {
        context.logger.warn('  ⚠  Some issues were detected but could not be fixed automatically. Please check the ' +
            'output above and fix these issues manually.');
    }
}
//# sourceMappingURL=data:application/json;base64,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