/*
  filesize.h - header file for functions that deal with file size values

  Copyright 2003 Damien Gregory (dgregory@lightuniverse.no-ip.com)

    This file is part of pipeworks.

    pipeworks is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    pipeworks is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pipeworks; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef FILESIZE_H
#define FILESIZE_H

typedef long double fsize_t;

#define kilo(n) ((fsize_t)1024*n)
#define mega(n) ((fsize_t)1024*kilo(n))
#define giga(n) ((fsize_t)1024*mega(n))
#define tera(n) ((fsize_t)1024*giga(n))
#define peta(n) ((fsize_t)1024*tera(n))
#define exa(n) ((fsize_t)1024*peta(n))
#define zetta(n) ((fsize_t)1024*exa(n))
#define yotta(n) ((fsize_t)1024*zetta(n))

fsize_t sizemultiplier (char type);
fsize_t convertsize (fsize_t s, char source, char dest);
fsize_t parsesize (char *s, char dest);
char *formatsize (fsize_t s, char source, char dest, char *format);

#endif
