/*
  timemanip.h - header file for functions that deal with time values

  Copyright 2003 Damien Gregory (dgregory@lightuniverse.no-ip.com)

    This file is part of pipeworks.

    pipeworks is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    pipeworks is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pipeworks; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef TIMEMANIP_H
#define TIMEMANIP_H

typedef long double tmanip_t;

#define minute(n) ((tmanip_t)60*n)
#define hour(n) ((tmanip_t)60*minute(n))
#define day(n) ((tmanip_t)24*hour(n))
#define week(n) ((tmanip_t)7*day(n))
#define month(n) ((tmanip_t)4*week(n))
#define year(n) ((tmanip_t)365*day(n))

tmanip_t timemultiplier (char type);
tmanip_t converttime (tmanip_t t, char source, char dest);
char *formattime (tmanip_t t, char source, char dest, char *format);
tmanip_t parsetime (char *t, char dest);

#endif 
