/*
    Written by Jelle Geerts (jellegeerts@gmail.com).

    To the extent possible under law, the author(s) have dedicated all
    copyright and related and neighboring rights to this software to
    the public domain worldwide. This software is distributed without
    any warranty.

    You should have received a copy of the CC0 Public Domain Dedication
    along with this software.
    If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.
*/

#ifndef PGN_MOVE_LIST_HH
#define PGN_MOVE_LIST_HH

#include "Ply.hh"
#include <vector>
#include <string>

class PgnMoveList
{
public:
    void addPly(const Ply &);
    void clear();
    const std::vector<Ply> &plies() const;
    size_t plyCount() const;
    void undoPly();

    std::string toString() const;

private:
    std::vector<Ply> plies_;
};

#endif
