/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogLevel;

public class FrameworkHandler
implements SynchronousBundleListener,
FrameworkListener,
ServiceListener {
    private final PaxLoggingManager m_manager;
    private final LogLevel loggingThreshold;

    public FrameworkHandler(BundleContext context, PaxLoggingManager manager) {
        this.m_manager = manager;
        String defaultThreshold = "ERROR";
        String threshold = OsgiUtil.systemOrContextProperty(context, "org.ops4j.pax.logging.service.frameworkEventsLogLevel");
        if (threshold != null && !"".equals(threshold)) {
            defaultThreshold = threshold;
        }
        this.loggingThreshold = BackendSupport.convertR7LogLevel(threshold, LogLevel.ERROR);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String message;
        int type = bundleEvent.getType();
        LogLevel level = LogLevel.INFO;
        switch (type) {
            case 1: {
                message = "BundleEvent INSTALLED";
                break;
            }
            case 2: {
                message = "BundleEvent STARTED";
                break;
            }
            case 4: {
                message = "BundleEvent STOPPED";
                break;
            }
            case 8: {
                message = "BundleEvent UPDATED";
                break;
            }
            case 16: {
                message = "BundleEvent UNINSTALLED";
                break;
            }
            case 32: {
                message = "BundleEvent RESOLVED";
                break;
            }
            case 64: {
                message = "BundleEvent UNRESOLVED";
                break;
            }
            case 128: {
                message = "BundleEvent STARTING";
                break;
            }
            case 256: {
                message = "BundleEvent STOPPING";
                break;
            }
            default: {
                message = "BundleEvent [unknown: " + type + "]";
            }
        }
        Bundle bundle = bundleEvent.getBundle();
        this.doLog(level, bundle, "Events.Bundle", message, new Object[0]);
    }

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        String message;
        int type = frameworkEvent.getType();
        LogLevel level = LogLevel.INFO;
        switch (type) {
            case 2: {
                message = "FrameworkEvent ERROR";
                level = LogLevel.ERROR;
                break;
            }
            case 32: {
                message = "FrameworkEvent INFO";
                break;
            }
            case 4: {
                message = "FrameworkEvent PACKAGES REFRESHED";
                break;
            }
            case 1: {
                message = "FrameworkEvent STARTED";
                break;
            }
            case 8: {
                message = "FrameworkEvent STARTLEVEL CHANGED";
                break;
            }
            case 16: {
                message = "FrameworkEvent WARNING";
                level = LogLevel.WARN;
                break;
            }
            default: {
                message = "FrameworkEvent [unknown:" + type + "]";
            }
        }
        Bundle bundle = frameworkEvent.getBundle();
        Throwable exception = frameworkEvent.getThrowable();
        this.doLog(level, bundle, "Events.Framework", message, exception);
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String message;
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        int type = serviceEvent.getType();
        LogLevel level = LogLevel.INFO;
        switch (type) {
            case 2: {
                message = "ServiceEvent MODIFIED";
                level = LogLevel.DEBUG;
                break;
            }
            case 1: {
                message = "ServiceEvent REGISTERED";
                break;
            }
            case 4: {
                message = "ServiceEvent UNREGISTERING";
                break;
            }
            default: {
                message = "ServiceEvent [unknown:" + type + "]";
            }
        }
        message = message + " - " + serviceRef;
        Bundle bundle = serviceRef.getBundle();
        this.doLog(level, bundle, "Events.Service", message, serviceRef);
    }

    private void doLog(LogLevel loggingLevel, Bundle bundle, String category, String message, Object ... args) {
        if (this.loggingThreshold == null || loggingLevel != LogLevel.AUDIT && loggingLevel.ordinal() > this.loggingThreshold.ordinal()) {
            return;
        }
        PaxLogger logger = this.m_manager.getLogger(bundle, category, FrameworkHandler.class.getName());
        switch (loggingLevel) {
            case AUDIT: {
                logger.audit(message, args);
                break;
            }
            case ERROR: {
                logger.error(message, args);
                break;
            }
            case WARN: {
                logger.warn(message, args);
                break;
            }
            case INFO: {
                logger.info(message, args);
                break;
            }
            case DEBUG: {
                logger.debug(message, args);
                break;
            }
            case TRACE: {
                logger.trace(message, args);
                break;
            }
        }
    }
}

