/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.CharSequences;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.IOException;
import java.io.Writer;

public final class Appendables {
    private Appendables() {
    }

    public static Writer writer(final Appendable delegate) {
        return new Writer(){

            @Override
            public void write(int c) throws IOException {
                delegate.append((char)c);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] cbuf) throws IOException {
                delegate.append(CharSequences.from(cbuf));
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(char[] cbuf, int off, int len) throws IOException {
                delegate.append(CharSequences.from(cbuf, off, len));
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(String str) throws IOException {
                delegate.append(str);
            }

            @Override
            @NotNullByDefault(value=false)
            public void write(String str, int off, int len) throws IOException {
                delegate.append(str, off, off + len);
            }

            @Override
            @NotNullByDefault(value=false)
            public Writer append(CharSequence csq) throws IOException {
                return super.append(csq);
            }

            @Override
            @NotNullByDefault(value=false)
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                delegate.append(csq, start, end);
                return this;
            }

            @Override
            public Writer append(char c) throws IOException {
                delegate.append(c);
                return this;
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    public static Appendable from(final Writer delegate) {
        return new Appendable(){

            @Override
            @NotNullByDefault(value=false)
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                delegate.write(csq.toString(), start, start + end);
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                delegate.write(c);
                return this;
            }

            @Override
            @NotNullByDefault(value=false)
            public Appendable append(CharSequence csq) throws IOException {
                delegate.write(csq.toString());
                return this;
            }
        };
    }
}

