/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Field;

public final class AssertionUtil {
    private AssertionUtil() {
    }

    public static void enableAssertionsFor(Class<?> clasS) {
        try {
            Field assertionsDisabledField = clasS.getDeclaredField("$assertionsDisabled");
            assertionsDisabledField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(assertionsDisabledField, assertionsDisabledField.getModifiers() & 0xFFFFFFEF);
            assertionsDisabledField.setBoolean(null, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void enableAssertionsForThisClass() {
        Class<?> subjectClass;
        StackTraceElement sf = new Throwable().getStackTrace()[1];
        String subjectClassName = sf.getClassName();
        String subjectMethodName = sf.getMethodName();
        if (!"<clinit>".equals(subjectMethodName)) {
            throw new AssertionError((Object)("'AssertionUtil.enableAssertionsForThisClass()' must only be called from a class initializer, not from '" + sf + "'"));
        }
        try {
            subjectClass = Class.forName(subjectClassName);
        }
        catch (Throwable t) {
            return;
        }
        AssertionUtil.enableAssertionsFor(subjectClass);
    }

    public static <T> T notNull(@Nullable T subject) {
        if (subject == null) {
            throw new NullPointerException();
        }
        return subject;
    }

    public static <T> T notNull(@Nullable T subject, String message) {
        if (subject == null) {
            throw new NullPointerException(message);
        }
        return subject;
    }

    public static Object fail() {
        throw new AssertionError();
    }

    public static <T> T fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static Object fail(Throwable cause) {
        AssertionError ae = new AssertionError((Object)String.valueOf(cause));
        ((Throwable)((Object)ae)).initCause(cause);
        throw ae;
    }

    public static Object fail(String message, Throwable cause) {
        AssertionError ae = new AssertionError((Object)message);
        ((Throwable)((Object)ae)).initCause(cause);
        throw ae;
    }
}

