/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net;

import de.unkrig.commons.io.Multiplexer;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.lang.protocol.StoppableUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NioTcpServer
implements Stoppable {
    private static final Logger LOGGER = Logger.getLogger(NioTcpServer.class.getName());
    private static final AtomicInteger CONNECTION_COUNT = new AtomicInteger();
    private final Executor executor = new ThreadPoolExecutor(10, 100, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
    private final Multiplexer multiplexer;

    public NioTcpServer() {
        try {
            this.multiplexer = new Multiplexer();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static ServerSocketChannel serverSocketChannel(InetSocketAddress endpoint, int backlog) throws IOException {
        LOGGER.log(Level.FINE, "Creating server on {0}", endpoint);
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.socket().bind(endpoint, backlog);
        ssc.configureBlocking(false);
        return ssc;
    }

    public InetSocketAddress addServer(InetSocketAddress endpoint, int backlog, final ConnectionHandler clientConnectionHandler) throws IOException {
        final ServerSocketChannel serverSocketChannel = NioTcpServer.serverSocketChannel(endpoint, backlog);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Accepting connections on {0}", serverSocketChannel);
        }
        this.multiplexer.register(serverSocketChannel, 16, new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                SocketChannel clientSocketChannel = serverSocketChannel.accept();
                if (clientSocketChannel == null) {
                    return;
                }
                clientSocketChannel.configureBlocking(false);
                int connectionNumber = CONNECTION_COUNT.incrementAndGet();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Client connection #{0} accepted: {1}", new Object[]{connectionNumber, clientSocketChannel});
                }
                clientSocketChannel.configureBlocking(true);
                try {
                    Socket socket = clientSocketChannel.socket();
                    clientConnectionHandler.handleConnection(clientSocketChannel, clientSocketChannel, (InetSocketAddress)socket.getLocalSocketAddress(), (InetSocketAddress)socket.getRemoteSocketAddress(), NioTcpServer.this.multiplexer, StoppableUtil.toStoppable(clientSocketChannel));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Connection {0} handled", clientSocketChannel);
                    }
                    clientSocketChannel.close();
                }
                catch (EOFException eofe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Connection {0} closed by client", clientSocketChannel);
                    }
                    try {
                        clientSocketChannel.close();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, clientSocketChannel.toString(), e);
                    }
                    try {
                        clientSocketChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return (InetSocketAddress)serverSocketChannel.socket().getLocalSocketAddress();
    }

    public void start(int multiplexerThreadCount) {
        assert (multiplexerThreadCount >= 1);
        for (int i = 0; i < multiplexerThreadCount; ++i) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        NioTcpServer.this.multiplexer.run();
                    }
                    catch (ClosedChannelException cce) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Terminating (ChannelClosedException)");
                        }
                        return;
                    }
                    catch (IOException ioe) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Terminating", ioe);
                        }
                        return;
                    }
                    catch (RuntimeException re) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Terminating", re);
                        }
                        return;
                    }
                }
            });
        }
    }

    @Override
    public void stop() {
        this.multiplexer.stop();
    }

    public static interface ConnectionHandler {
        public void handleConnection(ReadableByteChannel var1, WritableByteChannel var2, InetSocketAddress var3, InetSocketAddress var4, Multiplexer var5, Stoppable var6) throws Exception;
    }
}

