/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.httpproxy;

import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.net.http.HttpMessage;
import de.unkrig.commons.net.http.HttpProxy;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws IOException {
        String arg;
        int i = 0;
        while (i < args.length && (arg = args[i]).startsWith("-")) {
            ++i;
            if ("-help".equals(arg)) {
                System.out.println("Usage:");
                System.out.println("  java " + Main.class.getName());
                System.out.println("        [ <global-option> ... ]");
                System.out.println("        ( [ <local-option> ... ] <local-port> <remote-server-host-name> <remote-server-port> ) ...");
                System.out.println("Valid <global-option>s are:");
                System.out.println("  -help");
                System.out.println("  -nowarn         Suppress all messages except errors");
                System.out.println("  -quiet          Suppress normal output");
                System.out.println("  -verbose        Log verbose messages");
                System.out.println("  -debug          Log verbose and debug messages (repeat to get more output)");
                System.out.println("  -log <level>:<logger>:<handler>:<formatter>:<format>");
                System.out.println("                  Add logging at level FINE on logger 'de.unkrig' to STDERR");
                System.out.println("                  using the FormatFormatter and SIMPLE format, or the given");
                System.out.println("                  arguments which are all optional.");
                System.out.println("Valid <local-option>s are:");
                System.out.println("  -bind-address <address>");
                System.out.println("                  Accept connect requests to only this address");
                System.out.println("  <message-modification-option>");
                System.out.println("                  is applied to all requests and responses");
                System.out.println("Valid <message-modification-option>s are:");
                System.out.println("  -request        Apply the following options only to REQUESTS");
                System.out.println("  -response       Apply the following options only to RESPONSES");
                System.out.println("  -e s/<regex>/<replacement>/<flags>");
                System.out.println("                  Replace the first occurrence of <regex> within the body");
                System.out.println("                  with <replacement>.");
                System.out.println("                  Valid flags are:");
                System.out.println("                    'i': Case-insensitive match");
                System.out.println("                    'g': Replace ALL occurrences");
                System.out.println("  -add-header <name> <value>");
                System.out.println("                  Add a header with the given <name> and <value>");
                System.out.println("  -set-header <name> <value>");
                System.out.println("                  Change the value of the first header with the given <name>,");
                System.out.println("                  and remove all other headers withe the given <name>");
                System.out.println("  -remove-header <name>");
                System.out.println("                  Remove all headers with the given <name>");
                System.out.println("  -modify-header <name> s/<regex>/<replacement>/<flags>");
                System.out.println("                  Modify the value of all headers with the given <name>");
                System.exit(0);
                continue;
            }
            if ("-nowarn".equals(arg)) {
                SimpleLogging.setNoWarn();
                continue;
            }
            if ("-quiet".equals(arg)) {
                SimpleLogging.setQuiet();
                continue;
            }
            if ("-verbose".equals(arg)) {
                SimpleLogging.setVerbose();
                continue;
            }
            if ("-debug".equals(arg)) {
                SimpleLogging.setDebug();
                continue;
            }
            if ("-log".equals(arg)) {
                SimpleLogging.configureLoggers(args[i++]);
                continue;
            }
            --i;
            break;
        }
        while (i < args.length) {
            String arg2;
            InetAddress bindAddress = null;
            boolean applicableToRequests = true;
            boolean applicableToResponses = true;
            final ArrayList<Modifier> requestBodyModifiers = new ArrayList<Modifier>();
            final ArrayList<Modifier> responseBodyModifiers = new ArrayList<Modifier>();
            while (i < args.length && (arg2 = args[i]).startsWith("-")) {
                Modifier modifier;
                String value;
                String name;
                Modifier modifier2;
                ++i;
                if ("-bind-address".equals(arg2)) {
                    bindAddress = InetAddress.getByName(args[i++]);
                    continue;
                }
                if ("-request".equals(arg2)) {
                    applicableToRequests = true;
                    applicableToResponses = false;
                    continue;
                }
                if ("-response".equals(arg2)) {
                    applicableToRequests = false;
                    applicableToResponses = true;
                    continue;
                }
                if ("-e".equals(arg2)) {
                    final Substitution substitution = new Substitution(args[i++]);
                    modifier2 = new Modifier(){

                        @Override
                        public void modify(HttpMessage message) throws IOException {
                            Charset charSet = message.getCharset();
                            HttpMessage.Body body = message.removeBody();
                            if (body != HttpMessage.NO_BODY) {
                                message.setBody(HttpMessage.body(substitution.apply(body.string(charSet)), charSet));
                            }
                        }
                    };
                    if (applicableToRequests) {
                        requestBodyModifiers.add(modifier2);
                    }
                    if (!applicableToResponses) continue;
                    responseBodyModifiers.add(modifier2);
                    continue;
                }
                if ("-add-header".equals(arg2)) {
                    name = args[i++];
                    value = args[i++];
                    modifier = new Modifier(){

                        @Override
                        public void modify(HttpMessage message) {
                            message.addHeader(name, value);
                        }
                    };
                    if (applicableToRequests) {
                        requestBodyModifiers.add(modifier);
                    }
                    if (!applicableToResponses) continue;
                    responseBodyModifiers.add(modifier);
                    continue;
                }
                if ("-set-header".equals(arg2)) {
                    name = args[i++];
                    value = args[i++];
                    modifier = new Modifier(){

                        @Override
                        public void modify(HttpMessage message) {
                            message.setHeader(name, value);
                        }
                    };
                    if (applicableToRequests) {
                        requestBodyModifiers.add(modifier);
                    }
                    if (!applicableToResponses) continue;
                    responseBodyModifiers.add(modifier);
                    continue;
                }
                if ("-remove-header".equals(arg2)) {
                    name = args[i++];
                    modifier2 = new Modifier(){

                        @Override
                        public void modify(HttpMessage message) {
                            message.removeHeader(name);
                        }
                    };
                    if (applicableToRequests) {
                        requestBodyModifiers.add(modifier2);
                    }
                    if (!applicableToResponses) continue;
                    responseBodyModifiers.add(modifier2);
                    continue;
                }
                if ("-modify-header".equals(arg2)) {
                    name = args[i++];
                    final Substitution substitution = new Substitution(args[i++]);
                    modifier = new Modifier(){

                        @Override
                        public void modify(HttpMessage message) {
                            String value = message.getHeader(name);
                            if (value != null) {
                                message.setHeader(name, substitution.apply(value));
                            }
                        }
                    };
                    if (applicableToRequests) {
                        requestBodyModifiers.add(modifier);
                    }
                    if (!applicableToResponses) continue;
                    responseBodyModifiers.add(modifier);
                    continue;
                }
                System.err.println("Invalid command line option '" + arg2 + "'; try '-help'");
                System.exit(1);
            }
            if (i + 3 > args.length) {
                System.err.println("Local port, remote server host name and/or remote server port missing; try '-help'");
                System.exit(1);
            }
            InetSocketAddress endpoint = new InetSocketAddress(bindAddress, Integer.parseInt(args[i++]));
            InetSocketAddress serverAddress = new InetSocketAddress(args[i++], Integer.parseInt(args[i++]));
            HttpProxy httpProxy = new HttpProxy(endpoint, serverAddress, (TransformerWhichThrows<? super HttpRequest, HttpRequest, IOException>)new TransformerWhichThrows<HttpRequest, HttpRequest, IOException>(){

                @Override
                public HttpRequest transform(HttpRequest in) throws IOException {
                    Main.applyBodySubstitutions(in, requestBodyModifiers);
                    return in;
                }
            }, (TransformerWhichThrows<? super HttpResponse, HttpResponse, IOException>)new TransformerWhichThrows<HttpResponse, HttpResponse, IOException>(){

                @Override
                public HttpResponse transform(HttpResponse in) throws IOException {
                    Main.applyBodySubstitutions(in, responseBodyModifiers);
                    return in;
                }
            });
            ThreadUtil.runInBackground(httpProxy, null);
        }
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void applyBodySubstitutions(HttpMessage message, List<Modifier> modifiers) throws IOException {
        for (Modifier modifier : modifiers) {
            modifier.modify(message);
        }
    }

    static {
        SimpleLogging.init();
    }

    static class Substitution {
        private final Pattern pattern;
        private final String replacement;
        private final boolean global;

        Substitution(Pattern pattern, String replacement, boolean global) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.global = global;
        }

        Substitution(String sedCommand) {
            Matcher m = Pattern.compile("s/((?:[^\\\\/]|\\\\.)*)/((?:[^\\\\/]|\\\\.)*)/([gi]*)").matcher(sedCommand);
            if (!m.matches()) {
                throw new RuntimeException("Invalid SED command '" + sedCommand + "'");
            }
            String flags = m.group(3);
            this.pattern = Pattern.compile(m.group(1), flags.indexOf(105) != -1 ? 2 : 0);
            this.replacement = m.group(2);
            this.global = flags.indexOf(103) != -1;
        }

        public String apply(String subject) {
            Matcher m = this.pattern.matcher(subject);
            return this.global ? m.replaceAll(this.replacement) : m.replaceFirst(this.replacement);
        }
    }

    static interface Modifier {
        public void modify(HttpMessage var1) throws IOException;
    }
}

