/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.ElementWithContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class IteratorUtil {
    public static final Iterator AT_END = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private IteratorUtil() {
    }

    public static <T> Iterator<T> atEnd() {
        return AT_END;
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> delegate, final PredicateWhichThrows<? super T, ? extends RuntimeException> qualifies) {
        return new Iterator<T>(){
            @Nullable
            T lookahead;

            @Override
            public boolean hasNext() {
                Object tmp;
                if (this.lookahead != null) {
                    return true;
                }
                do {
                    if (delegate.hasNext()) continue;
                    return false;
                } while (!qualifies.evaluate(tmp = delegate.next()));
                this.lookahead = tmp;
                return true;
            }

            @Override
            public T next() {
                Object tmp;
                if (this.lookahead != null) {
                    Object tmp2 = this.lookahead;
                    this.lookahead = null;
                    return tmp2;
                }
                while (!qualifies.evaluate(tmp = delegate.next())) {
                }
                return tmp;
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static <I, O> Iterator<O> transform(final Iterator<? extends I> delegate, final Transformer<? super I, ? extends O> transform) {
        return new Iterator<O>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public O next() {
                return transform.transform(delegate.next());
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static <T> Iterator<T> repeat(final T value) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> ListIterator<E> reverse(final ListIterator<E> delegate) {
        return new ListIterator<E>(){

            @Override
            public boolean hasNext() {
                return delegate.hasPrevious();
            }

            @Override
            public E next() {
                return delegate.previous();
            }

            @Override
            public boolean hasPrevious() {
                return delegate.hasNext();
            }

            @Override
            public E previous() {
                return delegate.next();
            }

            @Override
            @NotNullByDefault(value=false)
            public void set(E e) {
                delegate.set(e);
            }

            @Override
            @NotNullByDefault(value=false)
            public void add(E e) {
                delegate.set(e);
            }

            @Override
            public void remove() {
                delegate.remove();
            }

            @Override
            public int nextIndex() {
                throw new UnsupportedOperationException("nextIndex");
            }

            @Override
            public int previousIndex() {
                throw new UnsupportedOperationException("previousIndex");
            }
        };
    }

    public static <T> Iterator<T> repeat(final int n, final T value) {
        return new Iterator<T>(){
            int count;

            @Override
            public boolean hasNext() {
                return this.count < n;
            }

            @Override
            public T next() {
                if (this.count >= n) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> ArrayIterator<T> iterator(final T[] array) {
        return new ArrayIterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public T next() {
                if (this.index >= array.length) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public int index() {
                return this.index;
            }
        };
    }

    public static int elementCount(Iterator<Integer> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public static <T> Iterator<ElementWithContext<T>> iteratorWithContext(Iterator<? extends T> delegate) {
        class ElementWithContextIterator
        implements Iterator<ElementWithContext<T>> {
            @Nullable
            private T current;
            @Nullable
            private T next;
            final /* synthetic */ Iterator val$delegate;

            ElementWithContextIterator(Iterator iterator) {
                this.val$delegate = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.next != null || this.val$delegate.hasNext();
            }

            @Override
            public ElementWithContext<T> next() {
                final Object previous = this.current;
                if (this.next == null) {
                    Object e = this.val$delegate.next();
                    assert (e != null) : "Delegate must produce non-null values";
                    this.current = e;
                } else {
                    this.current = this.next;
                    this.next = null;
                }
                return new ElementWithContext<T>(){

                    @Override
                    @Nullable
                    public T previous() {
                        return previous;
                    }

                    @Override
                    @NotNull
                    public T current() {
                        Object result = current;
                        assert (result != null);
                        return result;
                    }

                    @Override
                    @Nullable
                    public T next() {
                        if (next != null) {
                            return next;
                        }
                        if (!val$delegate.hasNext()) {
                            return null;
                        }
                        Object e = val$delegate.next();
                        assert (e != null) : "Delegate must produce non-null values";
                        next = e;
                        return next;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
        return new ElementWithContextIterator(delegate);
    }

    public static Iterator<Integer> foR(int start, int end) {
        return IteratorUtil.foR(start, end, 1);
    }

    public static Iterator<Integer> foR(final int start, final int end, final int step) {
        if (step == 0) {
            return start == end ? IteratorUtil.atEnd() : IteratorUtil.repeat(start);
        }
        if (step > 0) {
            if (end < start) {
                throw new IllegalArgumentException("step > 0 and end < start");
            }
            return new Iterator<Integer>(){
                int nextValue;
                {
                    this.nextValue = start;
                }

                @Override
                public boolean hasNext() {
                    return this.nextValue < end;
                }

                @Override
                public Integer next() {
                    if (this.nextValue >= end) {
                        throw new NoSuchElementException();
                    }
                    int result = this.nextValue;
                    this.nextValue += step;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
        if (end > start) {
            throw new IllegalArgumentException("step < 0 and end > start");
        }
        return new Iterator<Integer>(){
            int nextValue;
            {
                this.nextValue = start;
            }

            @Override
            public boolean hasNext() {
                return this.nextValue > end;
            }

            @Override
            public Integer next() {
                if (this.nextValue <= end) {
                    throw new NoSuchElementException();
                }
                int result = this.nextValue;
                this.nextValue += step;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public static <T> void addAllElementsTo(Iterator<? extends T> iterator, Collection<? super T> target) {
        while (iterator.hasNext()) {
            target.add(iterator.next());
        }
    }

    public static interface ArrayIterator<T>
    extends Iterator<T> {
        public int index();
    }
}

