/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.formatter;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SelectiveFormatter
extends Formatter {
    private final Predicate<? super LogRecord> predicate;
    private final Formatter delegate1;
    private final Formatter delegate2;

    public SelectiveFormatter(Predicate<? super LogRecord> predicate, Formatter delegate1, Formatter delegate2) {
        this.predicate = predicate;
        this.delegate1 = delegate1;
        this.delegate2 = delegate2;
    }

    @Override
    public String format(@Nullable LogRecord logRecord) {
        if (logRecord == null) {
            return "null";
        }
        return this.predicate.evaluate(logRecord) ? this.delegate1.format(logRecord) : this.delegate2.format(logRecord);
    }

    public static final Formatter loggerLevelGreaterThan(final Level threshold, Formatter delegate1, Formatter delegate2) {
        return new SelectiveFormatter((Predicate<? super LogRecord>)new Predicate<LogRecord>(){

            @Override
            public boolean evaluate(@Nullable LogRecord logRecord) {
                return logRecord != null && !Logger.getLogger(logRecord.getLoggerName()).isLoggable(threshold);
            }
        }, delegate1, delegate2);
    }

    public static final Formatter logRecordLevelGreaterThan(final Level threshold, Formatter delegate1, Formatter delegate2) {
        return new SelectiveFormatter((Predicate<? super LogRecord>)new Predicate<LogRecord>(){

            @Override
            public boolean evaluate(@Nullable LogRecord logRecord) {
                return logRecord != null && logRecord.getLevel().intValue() > threshold.intValue();
            }
        }, delegate1, delegate2);
    }
}

