/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.RunnableWhichThrows;
import de.unkrig.commons.lang.Stoppable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadUtil {
    static final Logger LOGGER = Logger.getLogger(ThreadUtil.class.getName());

    private ThreadUtil() {
    }

    public static void runInBackground(Runnable runnable, String threadName) {
        Thread t = new Thread(runnable, threadName);
        t.setDaemon(true);
        t.start();
    }

    public static <EX extends Exception> void runInBackground(final RunnableWhichThrows<EX> runnable, String threadName) {
        ThreadUtil.runInBackground(new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Exception caught from runnable", e);
                }
            }
        }, threadName);
    }

    public static <EX extends Exception> void runInForeground(RunnableWhichThrows<EX> runnable) throws EX {
        runnable.run();
    }

    public static <EX extends Exception> void parallel(RunnableWhichThrows<EX> runnable1, RunnableWhichThrows<EX> runnable2, Stoppable stoppable) throws EX {
        ArrayList<RunnableWhichThrows<EX>> l = new ArrayList<RunnableWhichThrows<EX>>();
        l.add(runnable1);
        l.add(runnable2);
        ThreadUtil.parallel(l, Collections.singleton(stoppable));
    }

    public static <EX extends Exception> void parallel(Collection<RunnableWhichThrows<EX>> runnables, Collection<Stoppable> stoppables) throws EX {
        final Exception[] caughtException = new Exception[1];
        ArrayList<2> l = new ArrayList<2>();
        for (final RunnableWhichThrows<EX> runnable : runnables) {
            l.add(new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        caughtException[0] = e;
                    }
                }
            });
        }
        ThreadUtil.parallel(l.toArray(new Runnable[l.size()]), stoppables);
        if (caughtException[0] != null) {
            Exception ex = caughtException[0];
            throw ex;
        }
    }

    public static void parallel(Runnable[] runnables, final Collection<Stoppable> stoppables) {
        final RuntimeException[] caughtRuntimeException = new RuntimeException[1];
        final Thread[] threads = new Thread[runnables.length];
        int i = 0;
        while (i < runnables.length) {
            Thread t;
            final Runnable runnable = runnables[i];
            Runnable runnable2 = new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException re) {
                        caughtRuntimeException[0] = re;
                    }
                    Thread[] threadArray = threads;
                    int n = threads.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Thread thread = threadArray[n2];
                        if (thread != null) {
                            thread.interrupt();
                        }
                        ++n2;
                    }
                    for (Stoppable stoppable : stoppables) {
                        if (stoppable == null) continue;
                        stoppable.stop();
                    }
                }
            };
            if (i < runnables.length - 1) {
                t = new Thread(runnable2);
                t.setName(Thread.currentThread().getName());
                t.start();
            } else {
                runnable2.run();
                t = Thread.currentThread();
            }
            threads[i] = t;
            ++i;
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            ++n2;
        }
        if (caughtRuntimeException[0] != null) {
            throw caughtRuntimeException[0];
        }
    }
}

