/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.io.objectstream.ObjectStream;
import de.unkrig.commons.io.objectstream.UnexpectedObjectException;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.util.Producer;
import de.unkrig.commons.util.ProducerWhichThrows;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerUtil {
    private ProducerUtil() {
    }

    public static <T, E extends Throwable> ObjectStream<T, E> producerObjectStream(final ProducerWhichThrows<T, E> delegate) {
        return new ObjectStream<T, E>(){
            private T next = null;

            @Override
            public T peek() throws Throwable {
                if (this.next == null) {
                    this.next = delegate.produce();
                }
                return this.next;
            }

            @Override
            public T peek(int distance) throws Throwable {
                if (distance != 0) {
                    throw new UnsupportedOperationException("Unsupported peek distance " + distance);
                }
                return this.peek();
            }

            @Override
            public boolean peek(T ref) throws Throwable {
                return ObjectUtil.equals(this.peek(), ref);
            }

            @Override
            public int peek(T[] refs) throws Throwable {
                Object n = this.peek();
                int i = 0;
                while (i < refs.length) {
                    if (ObjectUtil.equals(n, refs[i])) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            public T read() throws UnexpectedObjectException, Throwable {
                if (this.next == null) {
                    Object result = delegate.produce();
                    if (result == null) {
                        throw new UnexpectedObjectException("Unexpected end-of-input");
                    }
                    return result;
                }
                Object result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void read(T ref) throws UnexpectedObjectException, Throwable {
                if (this.next == null) {
                    Object result = delegate.produce();
                    if (!ObjectUtil.equals(result, ref)) {
                        throw new UnexpectedObjectException(String.valueOf(result));
                    }
                } else {
                    if (!ObjectUtil.equals(this.next, ref)) {
                        throw new UnexpectedObjectException(String.valueOf(this.next));
                    }
                    this.next = null;
                }
            }

            @Override
            public int read(T[] refs) throws UnexpectedObjectException, Throwable {
                if (this.next == null) {
                    this.next = delegate.produce();
                }
                int i = 0;
                while (i < refs.length) {
                    if (ObjectUtil.equals(this.next, refs[i])) {
                        this.next = null;
                        return i;
                    }
                    ++i;
                }
                throw new UnexpectedObjectException(String.valueOf(this.next));
            }

            @Override
            public T peekRead() throws Throwable {
                if (this.next == null) {
                    this.next = delegate.produce();
                }
                if (this.next == null) {
                    return null;
                }
                Object result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public boolean peekRead(T ref) throws Throwable {
                if (this.next == null) {
                    this.next = delegate.produce();
                }
                if (ObjectUtil.equals(this.next, ref)) {
                    this.next = null;
                    return true;
                }
                return false;
            }

            @Override
            public int peekRead(T[] refs) throws Throwable {
                if (this.next == null) {
                    this.next = delegate.produce();
                }
                int i = 0;
                while (i < refs.length) {
                    if (ObjectUtil.equals(this.next, refs[i])) {
                        this.next = null;
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            public boolean atEoi() throws Throwable {
                if (this.next == null) {
                    this.next = delegate.produce();
                }
                return this.next == null;
            }

            @Override
            public void eoi() throws UnexpectedObjectException, Throwable {
                if (this.next != null) {
                    this.next = delegate.produce();
                }
                if (this.next != null) {
                    throw new UnexpectedObjectException("End-of-input expected instead of " + this.next);
                }
            }

            public String toString() {
                return delegate.toString();
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> cast(final Producer<T> source) {
        return new ProducerWhichThrows<T, EX>(){

            @Override
            public T produce() {
                return source.produce();
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends E1> ProducerWhichThrows<T, E1> cast(final ProducerWhichThrows<T, E2> source) {
        return new ProducerWhichThrows<T, E1>(){

            @Override
            public T produce() throws Throwable {
                return source.produce();
            }
        };
    }
}

