/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFactory {
    private MapFactory() {
    }

    public static <K, V> Map<K, V> defaultedMap(final Map<K, V> delegate, final Map<K, V> parent) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("clear");
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException("entrySet");
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException("keySet");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException("values");
            }

            @Override
            public boolean containsKey(Object key) {
                return delegate.containsKey(key) || parent.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return delegate.containsValue(value) || parent.containsValue(value);
            }

            @Override
            public V get(Object key) {
                Object value = delegate.get(key);
                return value != null || delegate.containsKey(key) ? value : parent.get(key);
            }

            @Override
            public boolean isEmpty() {
                return delegate.isEmpty() && parent.isEmpty();
            }

            @Override
            public V put(K key, V value) {
                return delegate.put(key, value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> map) {
                delegate.putAll(map);
            }

            @Override
            public int size() {
                return delegate.size() + parent.size();
            }
        };
    }

    public static <K, V> Map<K, V> augment(final Map<K, V> delegate, final K extraKey, final V extraValue) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("clear");
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException("entrySet");
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException("keySet");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException("values");
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("put");
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> map) {
                throw new UnsupportedOperationException("putAll");
            }

            @Override
            public boolean containsKey(Object key) {
                return MapFactory.equal(key, extraKey) || delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return MapFactory.equal(value, extraValue) || delegate.containsValue(value);
            }

            @Override
            public V get(Object key) {
                return MapFactory.equal(key, extraKey) ? extraValue : delegate.get(key);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public int size() {
                return delegate.size() + 1;
            }
        };
    }

    public static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

