/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.pattern;

import de.unkrig.commons.util.Predicate;
import de.unkrig.commons.util.pattern.IncludeExclude;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Glob
implements Predicate<String> {
    public static final Glob DEFAULT_EXCLUDES;
    public static final Glob NONE;

    static {
        IncludeExclude ie = new IncludeExclude();
        ie.appendExclude(Glob.compile(".svn"));
        ie.appendExclude(Glob.compile("***/.svn"));
        ie.appendExclude(Glob.compile("***!.svn"));
        ie.appendExclude(Glob.compile("CVS"));
        ie.appendExclude(Glob.compile("***/CVS"));
        ie.appendExclude(Glob.compile("***!CVS"));
        DEFAULT_EXCLUDES = ie;
        NONE = new Glob(){

            public boolean matches(String subject) {
                return false;
            }
        };
    }

    public abstract boolean matches(String var1);

    @Override
    public boolean evaluate(String subject) {
        return this.matches(subject);
    }

    public String replace(String subject) {
        return this.matches(subject) ? subject : null;
    }

    private static Glob compileInternal(String wildcardPattern, int flags) {
        String replacement = null;
        if ((flags & 0x10) == 0) {
            int idx = Glob.findMeta("*?./{=", wildcardPattern, 0);
            block8: while (idx != wildcardPattern.length()) {
                switch (wildcardPattern.charAt(idx)) {
                    case '*': {
                        String s = wildcardPattern.substring(idx);
                        if (s.startsWith("***")) {
                            wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + ".*" + wildcardPattern.substring(idx + 3);
                            idx += 2;
                            break;
                        }
                        if (s.startsWith("**")) {
                            wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "[^!]*" + wildcardPattern.substring(idx + 2);
                            idx += 5;
                            break;
                        }
                        if (File.separatorChar != '/') {
                            wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "[^/\\" + File.separatorChar + "!]*" + wildcardPattern.substring(idx + 1);
                            idx += 8;
                            break;
                        }
                        wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "[^/!]*" + wildcardPattern.substring(idx + 1);
                        idx += 6;
                        break;
                    }
                    case '?': {
                        if (File.separatorChar != '/') {
                            wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "[^/\\" + File.separatorChar + "!]" + wildcardPattern.substring(idx + 1);
                            idx += 7;
                            break;
                        }
                        wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "[^/!]" + wildcardPattern.substring(idx + 1);
                        idx += 5;
                        break;
                    }
                    case '.': {
                        wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "\\." + wildcardPattern.substring(idx + 1);
                        idx += 2;
                        break;
                    }
                    case '/': {
                        if (File.separatorChar != '/') {
                            wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "[/\\" + File.separatorChar + "]" + wildcardPattern.substring(idx + 1);
                            idx += 5;
                            break;
                        }
                        ++idx;
                        break;
                    }
                    case '{': {
                        String s = wildcardPattern.substring(idx);
                        if (s.startsWith("{0,1}")) {
                            wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "?" + wildcardPattern.substring(idx + 5);
                            ++idx;
                            break;
                        }
                        if (s.startsWith("{0,}")) {
                            wildcardPattern = String.valueOf(wildcardPattern.substring(0, idx)) + "*" + wildcardPattern.substring(idx + 4);
                            ++idx;
                            break;
                        }
                        ++idx;
                        break;
                    }
                    case '=': {
                        replacement = wildcardPattern.substring(idx + 1);
                        wildcardPattern = wildcardPattern.substring(0, idx);
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                idx = Glob.findMeta("*?./{=", wildcardPattern, idx);
            }
        }
        return Glob.compileRegex(Pattern.compile(wildcardPattern, flags), replacement);
    }

    public static Glob compileRegex(Pattern regex) {
        return Glob.compileRegex(regex, null);
    }

    public static Glob compileRegex(final Pattern regex, final String replacement) {
        return new Glob(){

            public boolean matches(String subject) {
                Matcher matcher = regex.matcher(subject);
                if (matcher.lookingAt()) {
                    if (matcher.end() == subject.length()) {
                        return true;
                    }
                    char c = subject.charAt(matcher.end());
                    return c == '/' || c == '!';
                }
                return !(!subject.endsWith("!") && !subject.endsWith("/") || !matcher.hitEnd() && !regex.matcher(subject.substring(0, subject.length() - 1)).matches());
            }

            public String replace(String subject) {
                Matcher matcher = regex.matcher(subject);
                if (matcher.lookingAt()) {
                    int matchEnd = matcher.end();
                    StringBuffer sb = new StringBuffer();
                    matcher.appendReplacement(sb, replacement);
                    if (matchEnd == subject.length()) {
                        return sb.toString();
                    }
                    char c = subject.charAt(matchEnd);
                    if (c == '/' || c == '!') {
                        return sb.append(subject.substring(matchEnd)).toString();
                    }
                    return null;
                }
                return null;
            }

            public String toString() {
                return regex.toString();
            }
        };
    }

    private static int findMeta(String metaCharacters, String subject, int offset) {
        int cc = 0;
        boolean q = false;
        int state = 0;
        while (offset != subject.length()) {
            char c = subject.charAt(offset);
            switch (state) {
                case 0: {
                    if (c == '\\') {
                        state = 1;
                        break;
                    }
                    if (c == '[') {
                        ++cc;
                        break;
                    }
                    if (c == ']' && cc > 0) {
                        --cc;
                        break;
                    }
                    if (cc > 0) break;
                    if (metaCharacters.indexOf(c) != -1 && !q) {
                        return offset;
                    }
                    if (c == '{') {
                        q = true;
                        break;
                    }
                    if (c != '}') break;
                    q = false;
                    break;
                }
                case 1: {
                    state = c == 'Q' ? 2 : 0;
                    break;
                }
                case 2: {
                    if (c != '\\') break;
                    state = 3;
                    break;
                }
                case 3: {
                    if (c == 'E') {
                        state = 0;
                        break;
                    }
                    if (c == '\\') break;
                    state = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++offset;
        }
        return offset;
    }

    public static Glob compile(String wildcardPattern) {
        return Glob.compile(wildcardPattern, 0);
    }

    public static Glob compile(String wildcardPattern, int flags) {
        int idx;
        IncludeExclude includeExclude;
        if (wildcardPattern.startsWith("~")) {
            includeExclude = new IncludeExclude();
            idx = Glob.findMeta(",~", wildcardPattern, 1);
            includeExclude.prependExclude(Glob.compileInternal(wildcardPattern.substring(1, idx), flags));
        } else {
            idx = Glob.findMeta(",~", wildcardPattern, 0);
            Glob glob = Glob.compileInternal(wildcardPattern.substring(0, idx), flags);
            if (idx == wildcardPattern.length()) {
                return glob;
            }
            includeExclude = new IncludeExclude();
            includeExclude.prependInclude(glob);
        }
        while (idx != wildcardPattern.length()) {
            char c = wildcardPattern.charAt(idx++);
            int n = idx;
            idx = Glob.findMeta(",~", wildcardPattern, idx);
            Glob glob = Glob.compileInternal(wildcardPattern.substring(n, idx), flags);
            if (c == ',') {
                includeExclude.prependInclude(glob);
                continue;
            }
            includeExclude.prependExclude(glob);
        }
        return includeExclude;
    }

    public static Glob and(Glob pattern1, final Glob pattern2) {
        return new Glob(){

            public boolean matches(String subject) {
                return Glob.this.matches(subject) && pattern2.matches(subject);
            }

            public String replace(String subject) {
                return Glob.this.matches(subject) ? pattern2.replace(subject) : null;
            }
        };
    }

    public static Glob or(Glob pattern1, final Glob pattern2) {
        return new Glob(){

            public boolean matches(String subject) {
                return Glob.this.matches(subject) || pattern2.matches(subject);
            }

            public String replace(String subject) {
                String replacement = Glob.this.replace(subject);
                if (replacement != null) {
                    return replacement;
                }
                return pattern2.replace(subject);
            }
        };
    }
}

