/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.AbstractPipeline;
import java.util.stream.Collector;
import java.util.stream.DistinctOps;
import java.util.stream.DoublePipeline;
import java.util.stream.DoubleStream;
import java.util.stream.FindOps;
import java.util.stream.ForEachOps;
import java.util.stream.IntPipeline;
import java.util.stream.IntStream;
import java.util.stream.LongPipeline;
import java.util.stream.LongStream;
import java.util.stream.MatchOps;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReduceOps;
import java.util.stream.Sink;
import java.util.stream.SliceOps;
import java.util.stream.SortedOps;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;

abstract class ReferencePipeline<P_IN, P_OUT>
extends AbstractPipeline<P_IN, P_OUT, Stream<P_OUT>>
implements Stream<P_OUT> {
    ReferencePipeline(Supplier<? extends Spliterator<?>> supplier, int n, boolean bl) {
        super(supplier, n, bl);
    }

    ReferencePipeline(Spliterator<?> spliterator, int n, boolean bl) {
        super(spliterator, n, bl);
    }

    ReferencePipeline(AbstractPipeline<?, P_IN, ?> abstractPipeline, int n) {
        super(abstractPipeline, n);
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.REFERENCE;
    }

    @Override
    final <P_IN> Node<P_OUT> evaluateToNode(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl, IntFunction<P_OUT[]> intFunction) {
        return Nodes.collect(pipelineHelper, spliterator, bl, intFunction);
    }

    @Override
    final <P_IN> Spliterator<P_OUT> wrap(PipelineHelper<P_OUT> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
        return new StreamSpliterators.WrappingSpliterator<P_IN, P_OUT>(pipelineHelper, supplier, bl);
    }

    @Override
    final Spliterator<P_OUT> lazySpliterator(Supplier<? extends Spliterator<P_OUT>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator(supplier);
    }

    @Override
    final void forEachWithCancel(Spliterator<P_OUT> spliterator, Sink<P_OUT> sink) {
        while (!sink.cancellationRequested() && spliterator.tryAdvance(sink)) {
        }
    }

    @Override
    final Node.Builder<P_OUT> makeNodeBuilder(long l, IntFunction<P_OUT[]> intFunction) {
        return Nodes.builder(l, intFunction);
    }

    @Override
    public final Iterator<P_OUT> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Stream<P_OUT> unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<P_OUT> sink) {
                return sink;
            }
        };
    }

    @Override
    public final Stream<P_OUT> filter(final Predicate<? super P_OUT> predicate) {
        Objects.requireNonNull(predicate);
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<P_OUT> sink) {
                return new Sink.ChainedReference<P_OUT, P_OUT>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT P_OUT) {
                        if (predicate.test(P_OUT)) {
                            this.downstream.accept(P_OUT);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> map(final Function<? super P_OUT, ? extends R> function) {
        Objects.requireNonNull(function);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<R> sink) {
                return new Sink.ChainedReference<P_OUT, R>(sink){

                    @Override
                    public void accept(P_OUT P_OUT) {
                        this.downstream.accept(function.apply(P_OUT));
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapToInt(final ToIntFunction<? super P_OUT> toIntFunction) {
        Objects.requireNonNull(toIntFunction);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink){

                    @Override
                    public void accept(P_OUT P_OUT) {
                        this.downstream.accept(toIntFunction.applyAsInt(P_OUT));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapToLong(final ToLongFunction<? super P_OUT> toLongFunction) {
        Objects.requireNonNull(toLongFunction);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedReference<P_OUT, Long>(sink){

                    @Override
                    public void accept(P_OUT P_OUT) {
                        this.downstream.accept(toLongFunction.applyAsLong(P_OUT));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapToDouble(final ToDoubleFunction<? super P_OUT> toDoubleFunction) {
        Objects.requireNonNull(toDoubleFunction);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedReference<P_OUT, Double>(sink){

                    @Override
                    public void accept(P_OUT P_OUT) {
                        this.downstream.accept(toDoubleFunction.applyAsDouble(P_OUT));
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> flatMap(final Function<? super P_OUT, ? extends Stream<? extends R>> function) {
        Objects.requireNonNull(function);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<R> sink) {
                return new Sink.ChainedReference<P_OUT, R>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT P_OUT) {
                        try (Stream stream = (Stream)function.apply(P_OUT);){
                            if (stream != null) {
                                ((Stream)stream.sequential()).forEach(this.downstream);
                            }
                        }
                    }
                };
            }
        };
    }

    @Override
    public final IntStream flatMapToInt(final Function<? super P_OUT, ? extends IntStream> function) {
        Objects.requireNonNull(function);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink){
                    IntConsumer downstreamAsInt;
                    {
                        this.downstreamAsInt = this.downstream::accept;
                    }

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT P_OUT) {
                        try (IntStream intStream = (IntStream)function.apply(P_OUT);){
                            if (intStream != null) {
                                intStream.sequential().forEach(this.downstreamAsInt);
                            }
                        }
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream flatMapToDouble(final Function<? super P_OUT, ? extends DoubleStream> function) {
        Objects.requireNonNull(function);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedReference<P_OUT, Double>(sink){
                    DoubleConsumer downstreamAsDouble;
                    {
                        this.downstreamAsDouble = this.downstream::accept;
                    }

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT P_OUT) {
                        try (DoubleStream doubleStream = (DoubleStream)function.apply(P_OUT);){
                            if (doubleStream != null) {
                                doubleStream.sequential().forEach(this.downstreamAsDouble);
                            }
                        }
                    }
                };
            }
        };
    }

    @Override
    public final LongStream flatMapToLong(final Function<? super P_OUT, ? extends LongStream> function) {
        Objects.requireNonNull(function);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedReference<P_OUT, Long>(sink){
                    LongConsumer downstreamAsLong;
                    {
                        this.downstreamAsLong = this.downstream::accept;
                    }

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT P_OUT) {
                        try (LongStream longStream = (LongStream)function.apply(P_OUT);){
                            if (longStream != null) {
                                longStream.sequential().forEach(this.downstreamAsLong);
                            }
                        }
                    }
                };
            }
        };
    }

    @Override
    public final Stream<P_OUT> peek(final Consumer<? super P_OUT> consumer) {
        Objects.requireNonNull(consumer);
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, 0){

            @Override
            Sink<P_OUT> opWrapSink(int n, Sink<P_OUT> sink) {
                return new Sink.ChainedReference<P_OUT, P_OUT>(sink){

                    @Override
                    public void accept(P_OUT P_OUT) {
                        consumer.accept(P_OUT);
                        this.downstream.accept(P_OUT);
                    }
                };
            }
        };
    }

    @Override
    public final Stream<P_OUT> distinct() {
        return DistinctOps.makeRef(this);
    }

    @Override
    public final Stream<P_OUT> sorted() {
        return SortedOps.makeRef(this);
    }

    @Override
    public final Stream<P_OUT> sorted(Comparator<? super P_OUT> comparator) {
        return SortedOps.makeRef(this, comparator);
    }

    @Override
    public final Stream<P_OUT> limit(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        return SliceOps.makeRef(this, 0L, l);
    }

    @Override
    public final Stream<P_OUT> skip(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        if (l == 0L) {
            return this;
        }
        return SliceOps.makeRef(this, l, -1L);
    }

    @Override
    public void forEach(Consumer<? super P_OUT> consumer) {
        this.evaluate(ForEachOps.makeRef(consumer, false));
    }

    @Override
    public void forEachOrdered(Consumer<? super P_OUT> consumer) {
        this.evaluate(ForEachOps.makeRef(consumer, true));
    }

    @Override
    public final <A> A[] toArray(IntFunction<A[]> intFunction) {
        IntFunction<T[]> intFunction2 = intFunction;
        return Nodes.flatten(this.evaluateToArrayNode(intFunction2), intFunction2).asArray(intFunction2);
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public final boolean anyMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final Optional<P_OUT> findFirst() {
        return this.evaluate(FindOps.makeRef(true));
    }

    @Override
    public final Optional<P_OUT> findAny() {
        return this.evaluate(FindOps.makeRef(false));
    }

    @Override
    public final P_OUT reduce(P_OUT P_OUT, BinaryOperator<P_OUT> binaryOperator) {
        return this.evaluate(ReduceOps.makeRef(P_OUT, binaryOperator, binaryOperator));
    }

    @Override
    public final Optional<P_OUT> reduce(BinaryOperator<P_OUT> binaryOperator) {
        return this.evaluate(ReduceOps.makeRef(binaryOperator));
    }

    @Override
    public final <R> R reduce(R r, BiFunction<R, ? super P_OUT, R> biFunction, BinaryOperator<R> binaryOperator) {
        return this.evaluate(ReduceOps.makeRef(r, biFunction, binaryOperator));
    }

    @Override
    public final <R, A> R collect(Collector<? super P_OUT, A, R> collector) {
        Object a;
        if (this.isParallel() && collector.characteristics().contains((Object)Collector.Characteristics.CONCURRENT) && (!this.isOrdered() || collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED))) {
            a = collector.supplier().get();
            BiConsumer biConsumer = collector.accumulator();
            this.forEach((Consumer<? super P_OUT>)((Consumer<Object>)object2 -> biConsumer.accept(a, (Object)object2)));
        } else {
            a = this.evaluate(ReduceOps.makeRef(collector));
        }
        return (R)(collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? a : collector.finisher().apply(a));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super P_OUT> biConsumer, BiConsumer<R, R> biConsumer2) {
        return this.evaluate(ReduceOps.makeRef(supplier, biConsumer, biConsumer2));
    }

    @Override
    public final Optional<P_OUT> max(Comparator<? super P_OUT> comparator) {
        return this.reduce((BinaryOperator<P_OUT>)BinaryOperator.maxBy(comparator));
    }

    @Override
    public final Optional<P_OUT> min(Comparator<? super P_OUT> comparator) {
        return this.reduce((BinaryOperator<P_OUT>)BinaryOperator.minBy(comparator));
    }

    @Override
    public final long count() {
        return this.mapToLong((ToLongFunction<? super P_OUT>)((ToLongFunction<Object>)object -> 1L)).sum();
    }

    static abstract class StatefulOp<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<E_OUT> opEvaluateParallel(PipelineHelper<E_OUT> var1, Spliterator<P_IN> var2, IntFunction<E_OUT[]> var3);
    }

    static abstract class StatelessOp<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        Head(Supplier<? extends Spliterator<?>> supplier, int n, boolean bl) {
            super(supplier, n, bl);
        }

        Head(Spliterator<?> spliterator, int n, boolean bl) {
            super(spliterator, n, bl);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int n, Sink<E_OUT> sink) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super E_OUT> consumer) {
            if (!this.isParallel()) {
                this.sourceStageSpliterator().forEachRemaining(consumer);
            } else {
                super.forEach(consumer);
            }
        }

        @Override
        public void forEachOrdered(Consumer<? super E_OUT> consumer) {
            if (!this.isParallel()) {
                this.sourceStageSpliterator().forEachRemaining(consumer);
            } else {
                super.forEachOrdered(consumer);
            }
        }
    }
}

