//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// Structure containing the callbacks of a CFArray.
/// Field: version The version number of the structure type being passed
/// in as a parameter to the CFArray creation functions. This
/// structure is version 0.
/// Field: retain The callback used to add a retain for the array on
/// values as they are put into the array. This callback returns
/// the value to store in the array, which is usually the value
/// parameter passed to this callback, but may be a different
/// value if a different value should be stored in the array.
/// The array's allocator is passed as the first argument.
/// Field: release The callback used to remove a retain previously added
/// for the array from values as they are removed from the
/// array. The array's allocator is passed as the first
/// argument.
/// Field: copyDescription The callback used to create a descriptive
/// string representation of each value in the array. This is
/// used by the CFCopyDescription() function.
/// Field: equal The callback used to compare values in the array for
/// equality for some operations.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfarrayretaincallback?language=objc)
pub type CFArrayRetainCallBack =
    Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void) -> *const c_void>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfarrayreleasecallback?language=objc)
pub type CFArrayReleaseCallBack =
    Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfarraycopydescriptioncallback?language=objc)
pub type CFArrayCopyDescriptionCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfarrayequalcallback?language=objc)
pub type CFArrayEqualCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void, *const c_void) -> Boolean>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfarraycallbacks?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFArrayCallBacks {
    pub version: CFIndex,
    pub retain: CFArrayRetainCallBack,
    pub release: CFArrayReleaseCallBack,
    pub copyDescription: CFArrayCopyDescriptionCallBack,
    pub equal: CFArrayEqualCallBack,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFArrayCallBacks {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <CFArrayRetainCallBack>::ENCODING,
            <CFArrayReleaseCallBack>::ENCODING,
            <CFArrayCopyDescriptionCallBack>::ENCODING,
            <CFArrayEqualCallBack>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFArrayCallBacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// Predefined CFArrayCallBacks structure containing a set of callbacks
    /// appropriate for use when the values in a CFArray are all CFTypes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcftypearraycallbacks?language=objc)
    pub static kCFTypeArrayCallBacks: CFArrayCallBacks;
}

/// Type of the callback function used by the apply functions of
/// CFArrays.
///
/// Parameter `value`: The current value from the array.
///
/// Parameter `context`: The user-defined context parameter given to the apply
/// function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfarrayapplierfunction?language=objc)
pub type CFArrayApplierFunction = Option<unsafe extern "C-unwind" fn(*const c_void, *mut c_void)>;

/// This is the type of a reference to immutable CFArrays.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfarray?language=objc)
#[repr(C)]
pub struct CFArray<T: ?Sized = Opaque> {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
    _generics: PhantomData<(*mut T,)>,
}

cf_type!(
    unsafe impl<T: ?Sized> CFArray<T> {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl<T: ?Sized> RefEncode<"__CFArray"> for CFArray<T> {}
);

/// This is the type of a reference to mutable CFArrays.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutablearray?language=objc)
#[repr(C)]
pub struct CFMutableArray<T: ?Sized = Opaque> {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
    _generics: PhantomData<(*mut T,)>,
}

cf_type!(
    unsafe impl<T: ?Sized> CFMutableArray<T>: CFArray<T> {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl<T: ?Sized> RefEncode<"__CFArray"> for CFMutableArray<T> {}
);

unsafe impl ConcreteType for CFArray {
    /// Returns the type identifier of all CFArray instances.
    #[doc(alias = "CFArrayGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFArrayGetTypeID() -> CFTypeID;
        }
        unsafe { CFArrayGetTypeID() }
    }
}

impl CFArray {
    /// Creates a new immutable array with the given values.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the array and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `values`: A C array of the pointer-sized values to be in the
    /// array. The values in the array are ordered in the same order
    /// in which they appear in this C array. This parameter may be
    /// NULL if the numValues parameter is 0. This C array is not
    /// changed or freed by this function. If this parameter is not
    /// a valid pointer to a C array of at least numValues pointers,
    /// the behavior is undefined.
    ///
    /// Parameter `numValues`: The number of values to copy from the values C
    /// array into the CFArray. This number will be the count of the
    /// array.
    /// If this parameter is negative, or greater than the number of
    /// values actually in the value's C array, the behavior is
    /// undefined.
    ///
    /// Parameter `callBacks`: A pointer to a CFArrayCallBacks structure
    /// initialized with the callbacks for the array to use on each
    /// value in the array. The retain callback will be used within
    /// this function, for example, to retain all of the new values
    /// from the values C array. A copy of the contents of the
    /// callbacks structure is made, so that a pointer to a
    /// structure on the stack can be passed in, or can be reused
    /// for multiple array creations. If the version field of this
    /// callbacks structure is not one of the defined ones for
    /// CFArray, the behavior is undefined. The retain field may be
    /// NULL, in which case the CFArray will do nothing to add a
    /// retain to the contained values for the array. The release
    /// field may be NULL, in which case the CFArray will do nothing
    /// to remove the array's retain (if any) on the values when the
    /// array is destroyed. If the copyDescription field is NULL,
    /// the array will create a simple description for the value. If
    /// the equal field is NULL, the array will use pointer equality
    /// to test for equality of values. This callbacks parameter
    /// itself may be NULL, which is treated as if a valid structure
    /// of version 0 with all fields NULL had been passed in.
    /// Otherwise, if any of the fields are not valid pointers to
    /// functions of the correct type, or this parameter is not a
    /// valid pointer to a  CFArrayCallBacks callbacks structure,
    /// the behavior is undefined. If any of the values put into the
    /// array is not one understood by one of the callback functions
    /// the behavior when that callback function is used is
    /// undefined.
    ///
    /// Returns: A reference to the new immutable CFArray.
    #[doc(alias = "CFArrayCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        values: *mut *const c_void,
        num_values: CFIndex,
        call_backs: *const CFArrayCallBacks,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFArrayCreate(
                allocator: Option<&CFAllocator>,
                values: *mut *const c_void,
                num_values: CFIndex,
                call_backs: *const CFArrayCallBacks,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFArrayCreate(allocator, values, num_values, call_backs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a new immutable array with the values from the given array.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the array and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `theArray`: The array which is to be copied. The values from the
    /// array are copied as pointers into the new array (that is,
    /// the values themselves are copied, not that which the values
    /// point to, if anything). However, the values are also
    /// retained by the new array. The count of the new array will
    /// be the same as the given array. The new array uses the same
    /// callbacks as the array to be copied. If this parameter is
    /// not a valid CFArray, the behavior is undefined.
    ///
    /// Returns: A reference to the new immutable CFArray.
    #[doc(alias = "CFArrayCreateCopy")]
    #[inline]
    pub unsafe fn new_copy(
        allocator: Option<&CFAllocator>,
        the_array: Option<&CFArray>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFArrayCreateCopy(
                allocator: Option<&CFAllocator>,
                the_array: Option<&CFArray>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFArrayCreateCopy(allocator, the_array) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFMutableArray {
    /// Creates a new empty mutable array.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the array and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `capacity`: A hint about the number of values that will be held
    /// by the CFArray. Pass 0 for no hint. The implementation may
    /// ignore this hint, or may use it to optimize various
    /// operations. An array's actual capacity is only limited by
    /// address space and available memory constraints). If this
    /// parameter is negative, the behavior is undefined.
    ///
    /// Parameter `callBacks`: A pointer to a CFArrayCallBacks structure
    /// initialized with the callbacks for the array to use on each
    /// value in the array. A copy of the contents of the
    /// callbacks structure is made, so that a pointer to a
    /// structure on the stack can be passed in, or can be reused
    /// for multiple array creations. If the version field of this
    /// callbacks structure is not one of the defined ones for
    /// CFArray, the behavior is undefined. The retain field may be
    /// NULL, in which case the CFArray will do nothing to add a
    /// retain to the contained values for the array. The release
    /// field may be NULL, in which case the CFArray will do nothing
    /// to remove the array's retain (if any) on the values when the
    /// array is destroyed. If the copyDescription field is NULL,
    /// the array will create a simple description for the value. If
    /// the equal field is NULL, the array will use pointer equality
    /// to test for equality of values. This callbacks parameter
    /// itself may be NULL, which is treated as if a valid structure
    /// of version 0 with all fields NULL had been passed in.
    /// Otherwise, if any of the fields are not valid pointers to
    /// functions of the correct type, or this parameter is not a
    /// valid pointer to a  CFArrayCallBacks callbacks structure,
    /// the behavior is undefined. If any of the values put into the
    /// array is not one understood by one of the callback functions
    /// the behavior when that callback function is used is
    /// undefined.
    ///
    /// Returns: A reference to the new mutable CFArray.
    #[doc(alias = "CFArrayCreateMutable")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
        call_backs: *const CFArrayCallBacks,
    ) -> Option<CFRetained<CFMutableArray>> {
        extern "C-unwind" {
            fn CFArrayCreateMutable(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
                call_backs: *const CFArrayCallBacks,
            ) -> Option<NonNull<CFMutableArray>>;
        }
        let ret = unsafe { CFArrayCreateMutable(allocator, capacity, call_backs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a new mutable array with the values from the given array.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the array and its storage for values. This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used. If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `capacity`: A hint about the number of values that will be held
    /// by the CFArray. Pass 0 for no hint. The implementation may
    /// ignore this hint, or may use it to optimize various
    /// operations. An array's actual capacity is only limited by
    /// address space and available memory constraints).
    /// This parameter must be greater than or equal
    /// to the count of the array which is to be copied, or the
    /// behavior is undefined. If this parameter is negative, the
    /// behavior is undefined.
    ///
    /// Parameter `theArray`: The array which is to be copied. The values from the
    /// array are copied as pointers into the new array (that is,
    /// the values themselves are copied, not that which the values
    /// point to, if anything). However, the values are also
    /// retained by the new array. The count of the new array will
    /// be the same as the given array. The new array uses the same
    /// callbacks as the array to be copied. If this parameter is
    /// not a valid CFArray, the behavior is undefined.
    ///
    /// Returns: A reference to the new mutable CFArray.
    #[doc(alias = "CFArrayCreateMutableCopy")]
    #[inline]
    pub unsafe fn new_copy(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
        the_array: Option<&CFArray>,
    ) -> Option<CFRetained<CFMutableArray>> {
        extern "C-unwind" {
            fn CFArrayCreateMutableCopy(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
                the_array: Option<&CFArray>,
            ) -> Option<NonNull<CFMutableArray>>;
        }
        let ret = unsafe { CFArrayCreateMutableCopy(allocator, capacity, the_array) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFArray {
    /// Returns the number of values currently in the array.
    ///
    /// Parameter `theArray`: The array to be queried. If this parameter is not a valid
    /// CFArray, the behavior is undefined.
    ///
    /// Returns: The number of values in the array.
    #[doc(alias = "CFArrayGetCount")]
    #[inline]
    pub fn count(self: &CFArray) -> CFIndex {
        extern "C-unwind" {
            fn CFArrayGetCount(the_array: &CFArray) -> CFIndex;
        }
        unsafe { CFArrayGetCount(self) }
    }

    /// Counts the number of times the given value occurs in the array.
    ///
    /// Parameter `theArray`: The array to be searched. If this parameter is not a
    /// valid CFArray, the behavior is undefined.
    ///
    /// Parameter `range`: The range within the array to search. If the range
    /// location or end point (defined by the location plus length
    /// minus 1) is outside the index space of the array (0 to
    /// N-1 inclusive, where N is the count of the array), the
    /// behavior is undefined. If the range length is negative, the
    /// behavior is undefined. The range may be empty (length 0).
    ///
    /// Parameter `value`: The value for which to find matches in the array. The
    /// equal() callback provided when the array was created is
    /// used to compare. If the equal() callback was NULL, pointer
    /// equality (in C, ==) is used. If value, or any of the values
    /// in the array, are not understood by the equal() callback,
    /// the behavior is undefined.
    ///
    /// Returns: The number of times the given value occurs in the array,
    /// within the specified range.
    #[doc(alias = "CFArrayGetCountOfValue")]
    #[inline]
    pub unsafe fn count_of_value(self: &CFArray, range: CFRange, value: *const c_void) -> CFIndex {
        extern "C-unwind" {
            fn CFArrayGetCountOfValue(
                the_array: &CFArray,
                range: CFRange,
                value: *const c_void,
            ) -> CFIndex;
        }
        unsafe { CFArrayGetCountOfValue(self, range, value) }
    }

    /// Reports whether or not the value is in the array.
    ///
    /// Parameter `theArray`: The array to be searched. If this parameter is not a
    /// valid CFArray, the behavior is undefined.
    ///
    /// Parameter `range`: The range within the array to search. If the range
    /// location or end point (defined by the location plus length
    /// minus 1) is outside the index space of the array (0 to
    /// N-1 inclusive, where N is the count of the array), the
    /// behavior is undefined. If the range length is negative, the
    /// behavior is undefined. The range may be empty (length 0).
    ///
    /// Parameter `value`: The value for which to find matches in the array. The
    /// equal() callback provided when the array was created is
    /// used to compare. If the equal() callback was NULL, pointer
    /// equality (in C, ==) is used. If value, or any of the values
    /// in the array, are not understood by the equal() callback,
    /// the behavior is undefined.
    ///
    /// Returns: true, if the value is in the specified range of the array,
    /// otherwise false.
    #[doc(alias = "CFArrayContainsValue")]
    #[inline]
    pub unsafe fn contains_value(self: &CFArray, range: CFRange, value: *const c_void) -> bool {
        extern "C-unwind" {
            fn CFArrayContainsValue(
                the_array: &CFArray,
                range: CFRange,
                value: *const c_void,
            ) -> Boolean;
        }
        let ret = unsafe { CFArrayContainsValue(self, range, value) };
        ret != 0
    }

    /// Retrieves the value at the given index.
    ///
    /// Parameter `theArray`: The array to be queried. If this parameter is not a
    /// valid CFArray, the behavior is undefined.
    ///
    /// Parameter `idx`: The index of the value to retrieve. If the index is
    /// outside the index space of the array (0 to N-1 inclusive,
    /// where N is the count of the array), the behavior is
    /// undefined.
    ///
    /// Returns: The value with the given index in the array.
    #[doc(alias = "CFArrayGetValueAtIndex")]
    #[inline]
    pub unsafe fn value_at_index(self: &CFArray, idx: CFIndex) -> *const c_void {
        extern "C-unwind" {
            fn CFArrayGetValueAtIndex(the_array: &CFArray, idx: CFIndex) -> *const c_void;
        }
        unsafe { CFArrayGetValueAtIndex(self, idx) }
    }

    /// Fills the buffer with values from the array.
    ///
    /// Parameter `theArray`: The array to be queried. If this parameter is not a
    /// valid CFArray, the behavior is undefined.
    ///
    /// Parameter `range`: The range of values within the array to retrieve. If
    /// the range location or end point (defined by the location
    /// plus length minus 1) is outside the index space of the
    /// array (0 to N-1 inclusive, where N is the count of the
    /// array), the behavior is undefined. If the range length is
    /// negative, the behavior is undefined. The range may be empty
    /// (length 0), in which case no values are put into the buffer.
    ///
    /// Parameter `values`: A C array of pointer-sized values to be filled with
    /// values from the array. The values in the C array are ordered
    /// in the same order in which they appear in the array. If this
    /// parameter is not a valid pointer to a C array of at least
    /// range.length pointers, the behavior is undefined.
    #[doc(alias = "CFArrayGetValues")]
    #[inline]
    pub unsafe fn values(self: &CFArray, range: CFRange, values: *mut *const c_void) {
        extern "C-unwind" {
            fn CFArrayGetValues(the_array: &CFArray, range: CFRange, values: *mut *const c_void);
        }
        unsafe { CFArrayGetValues(self, range, values) }
    }

    /// Calls a function once for each value in the array.
    ///
    /// Parameter `theArray`: The array to be operated upon. If this parameter is not
    /// a valid CFArray, the behavior is undefined.
    ///
    /// Parameter `range`: The range of values within the array to which to apply
    /// the function. If the range location or end point (defined by
    /// the location plus length minus 1) is outside the index
    /// space of the array (0 to N-1 inclusive, where N is the count
    /// of the array), the behavior is undefined. If the range
    /// length is negative, the behavior is undefined. The range may
    /// be empty (length 0).
    ///
    /// Parameter `applier`: The callback function to call once for each value in
    /// the given range in the array. If this parameter is not a
    /// pointer to a function of the correct prototype, the behavior
    /// is undefined. If there are values in the range which the
    /// applier function does not expect or cannot properly apply
    /// to, the behavior is undefined.
    ///
    /// Parameter `context`: A pointer-sized user-defined value, which is passed
    /// as the second parameter to the applier function, but is
    /// otherwise unused by this function. If the context is not
    /// what is expected by the applier function, the behavior is
    /// undefined.
    #[doc(alias = "CFArrayApplyFunction")]
    #[inline]
    pub unsafe fn apply_function(
        self: &CFArray,
        range: CFRange,
        applier: CFArrayApplierFunction,
        context: *mut c_void,
    ) {
        extern "C-unwind" {
            fn CFArrayApplyFunction(
                the_array: &CFArray,
                range: CFRange,
                applier: CFArrayApplierFunction,
                context: *mut c_void,
            );
        }
        unsafe { CFArrayApplyFunction(self, range, applier, context) }
    }

    /// Searches the array for the value.
    ///
    /// Parameter `theArray`: The array to be searched. If this parameter is not a
    /// valid CFArray, the behavior is undefined.
    ///
    /// Parameter `range`: The range within the array to search. If the range
    /// location or end point (defined by the location plus length
    /// minus 1) is outside the index space of the array (0 to
    /// N-1 inclusive, where N is the count of the array), the
    /// behavior is undefined. If the range length is negative, the
    /// behavior is undefined. The range may be empty (length 0).
    /// The search progresses from the smallest index defined by
    /// the range to the largest.
    ///
    /// Parameter `value`: The value for which to find a match in the array. The
    /// equal() callback provided when the array was created is
    /// used to compare. If the equal() callback was NULL, pointer
    /// equality (in C, ==) is used. If value, or any of the values
    /// in the array, are not understood by the equal() callback,
    /// the behavior is undefined.
    ///
    /// Returns: The lowest index of the matching values in the range, or
    /// kCFNotFound if no value in the range matched.
    #[doc(alias = "CFArrayGetFirstIndexOfValue")]
    #[inline]
    pub unsafe fn first_index_of_value(
        self: &CFArray,
        range: CFRange,
        value: *const c_void,
    ) -> CFIndex {
        extern "C-unwind" {
            fn CFArrayGetFirstIndexOfValue(
                the_array: &CFArray,
                range: CFRange,
                value: *const c_void,
            ) -> CFIndex;
        }
        unsafe { CFArrayGetFirstIndexOfValue(self, range, value) }
    }

    /// Searches the array for the value.
    ///
    /// Parameter `theArray`: The array to be searched. If this parameter is not a
    /// valid CFArray, the behavior is undefined.
    ///
    /// Parameter `range`: The range within the array to search. If the range
    /// location or end point (defined by the location plus length
    /// minus 1) is outside the index space of the array (0 to
    /// N-1 inclusive, where N is the count of the array), the
    /// behavior is undefined. If the range length is negative, the
    /// behavior is undefined. The range may be empty (length 0).
    /// The search progresses from the largest index defined by the
    /// range to the smallest.
    ///
    /// Parameter `value`: The value for which to find a match in the array. The
    /// equal() callback provided when the array was created is
    /// used to compare. If the equal() callback was NULL, pointer
    /// equality (in C, ==) is used. If value, or any of the values
    /// in the array, are not understood by the equal() callback,
    /// the behavior is undefined.
    ///
    /// Returns: The highest index of the matching values in the range, or
    /// kCFNotFound if no value in the range matched.
    #[doc(alias = "CFArrayGetLastIndexOfValue")]
    #[inline]
    pub unsafe fn last_index_of_value(
        self: &CFArray,
        range: CFRange,
        value: *const c_void,
    ) -> CFIndex {
        extern "C-unwind" {
            fn CFArrayGetLastIndexOfValue(
                the_array: &CFArray,
                range: CFRange,
                value: *const c_void,
            ) -> CFIndex;
        }
        unsafe { CFArrayGetLastIndexOfValue(self, range, value) }
    }

    /// Searches the array for the value using a binary search algorithm.
    ///
    /// Parameter `theArray`: The array to be searched. If this parameter is not a
    /// valid CFArray, the behavior is undefined. If the array is
    /// not sorted from least to greatest according to the
    /// comparator function, the behavior is undefined.
    ///
    /// Parameter `range`: The range within the array to search. If the range
    /// location or end point (defined by the location plus length
    /// minus 1) is outside the index space of the array (0 to
    /// N-1 inclusive, where N is the count of the array), the
    /// behavior is undefined. If the range length is negative, the
    /// behavior is undefined. The range may be empty (length 0).
    ///
    /// Parameter `value`: The value for which to find a match in the array. If
    /// value, or any of the values in the array, are not understood
    /// by the comparator callback, the behavior is undefined.
    ///
    /// Parameter `comparator`: The function with the comparator function type
    /// signature which is used in the binary search operation to
    /// compare values in the array with the given value. If this
    /// parameter is not a pointer to a function of the correct
    /// prototype, the behavior is undefined. If there are values
    /// in the range which the comparator function does not expect
    /// or cannot properly compare, the behavior is undefined.
    ///
    /// Parameter `context`: A pointer-sized user-defined value, which is passed
    /// as the third parameter to the comparator function, but is
    /// otherwise unused by this function. If the context is not
    /// what is expected by the comparator function, the behavior is
    /// undefined.
    ///
    /// Returns: The return value is either 1) the index of a value that
    /// matched, if the target value matches one or more in the
    /// range, 2) greater than or equal to the end point of the
    /// range, if the value is greater than all the values in the
    /// range, or 3) the index of the value greater than the target
    /// value, if the value lies between two of (or less than all
    /// of) the values in the range.
    #[doc(alias = "CFArrayBSearchValues")]
    #[inline]
    pub unsafe fn b_search_values(
        self: &CFArray,
        range: CFRange,
        value: *const c_void,
        comparator: CFComparatorFunction,
        context: *mut c_void,
    ) -> CFIndex {
        extern "C-unwind" {
            fn CFArrayBSearchValues(
                the_array: &CFArray,
                range: CFRange,
                value: *const c_void,
                comparator: CFComparatorFunction,
                context: *mut c_void,
            ) -> CFIndex;
        }
        unsafe { CFArrayBSearchValues(self, range, value, comparator, context) }
    }
}

impl CFMutableArray {
    /// Adds the value to the array giving it a new largest index.
    ///
    /// Parameter `theArray`: The array to which the value is to be added. If this
    /// parameter is not a valid mutable CFArray, the behavior is
    /// undefined.
    ///
    /// Parameter `value`: The value to add to the array. The value is retained by
    /// the array using the retain callback provided when the array
    /// was created. If the value is not of the sort expected by the
    /// retain callback, the behavior is undefined. The value is
    /// assigned to the index one larger than the previous largest
    /// index, and the count of the array is increased by one.
    #[doc(alias = "CFArrayAppendValue")]
    #[inline]
    pub unsafe fn append_value(the_array: Option<&CFMutableArray>, value: *const c_void) {
        extern "C-unwind" {
            fn CFArrayAppendValue(the_array: Option<&CFMutableArray>, value: *const c_void);
        }
        unsafe { CFArrayAppendValue(the_array, value) }
    }

    /// Adds the value to the array, giving it the given index.
    ///
    /// Parameter `theArray`: The array to which the value is to be added. If this
    /// parameter is not a valid mutable CFArray, the behavior is
    /// undefined.
    ///
    /// Parameter `idx`: The index to which to add the new value. If the index is
    /// outside the index space of the array (0 to N inclusive,
    /// where N is the count of the array before the operation), the
    /// behavior is undefined. If the index is the same as N, this
    /// function has the same effect as CFArrayAppendValue().
    ///
    /// Parameter `value`: The value to add to the array. The value is retained by
    /// the array using the retain callback provided when the array
    /// was created. If the value is not of the sort expected by the
    /// retain callback, the behavior is undefined. The value is
    /// assigned to the given index, and all values with equal and
    /// larger indices have their indexes increased by one.
    #[doc(alias = "CFArrayInsertValueAtIndex")]
    #[inline]
    pub unsafe fn insert_value_at_index(
        the_array: Option<&CFMutableArray>,
        idx: CFIndex,
        value: *const c_void,
    ) {
        extern "C-unwind" {
            fn CFArrayInsertValueAtIndex(
                the_array: Option<&CFMutableArray>,
                idx: CFIndex,
                value: *const c_void,
            );
        }
        unsafe { CFArrayInsertValueAtIndex(the_array, idx, value) }
    }

    /// Changes the value with the given index in the array.
    ///
    /// Parameter `theArray`: The array in which the value is to be changed. If this
    /// parameter is not a valid mutable CFArray, the behavior is
    /// undefined.
    ///
    /// Parameter `idx`: The index to which to set the new value. If the index is
    /// outside the index space of the array (0 to N inclusive,
    /// where N is the count of the array before the operation), the
    /// behavior is undefined. If the index is the same as N, this
    /// function has the same effect as CFArrayAppendValue().
    ///
    /// Parameter `value`: The value to set in the array. The value is retained by
    /// the array using the retain callback provided when the array
    /// was created, and the previous value with that index is
    /// released. If the value is not of the sort expected by the
    /// retain callback, the behavior is undefined. The indices of
    /// other values is not affected.
    #[doc(alias = "CFArraySetValueAtIndex")]
    #[inline]
    pub unsafe fn set_value_at_index(
        the_array: Option<&CFMutableArray>,
        idx: CFIndex,
        value: *const c_void,
    ) {
        extern "C-unwind" {
            fn CFArraySetValueAtIndex(
                the_array: Option<&CFMutableArray>,
                idx: CFIndex,
                value: *const c_void,
            );
        }
        unsafe { CFArraySetValueAtIndex(the_array, idx, value) }
    }

    /// Removes the value with the given index from the array.
    ///
    /// Parameter `theArray`: The array from which the value is to be removed. If
    /// this parameter is not a valid mutable CFArray, the behavior
    /// is undefined.
    ///
    /// Parameter `idx`: The index from which to remove the value. If the index is
    /// outside the index space of the array (0 to N-1 inclusive,
    /// where N is the count of the array before the operation), the
    /// behavior is undefined.
    #[doc(alias = "CFArrayRemoveValueAtIndex")]
    #[inline]
    pub unsafe fn remove_value_at_index(the_array: Option<&CFMutableArray>, idx: CFIndex) {
        extern "C-unwind" {
            fn CFArrayRemoveValueAtIndex(the_array: Option<&CFMutableArray>, idx: CFIndex);
        }
        unsafe { CFArrayRemoveValueAtIndex(the_array, idx) }
    }

    /// Removes all the values from the array, making it empty.
    ///
    /// Parameter `theArray`: The array from which all of the values are to be
    /// removed. If this parameter is not a valid mutable CFArray,
    /// the behavior is undefined.
    #[doc(alias = "CFArrayRemoveAllValues")]
    #[inline]
    pub fn remove_all_values(the_array: Option<&CFMutableArray>) {
        extern "C-unwind" {
            fn CFArrayRemoveAllValues(the_array: Option<&CFMutableArray>);
        }
        unsafe { CFArrayRemoveAllValues(the_array) }
    }

    /// Replaces a range of values in the array.
    ///
    /// Parameter `theArray`: The array from which all of the values are to be
    /// removed. If this parameter is not a valid mutable CFArray,
    /// the behavior is undefined.
    ///
    /// Parameter `range`: The range of values within the array to replace. If the
    /// range location or end point (defined by the location plus
    /// length minus 1) is outside the index space of the array (0
    /// to N inclusive, where N is the count of the array), the
    /// behavior is undefined. If the range length is negative, the
    /// behavior is undefined. The range may be empty (length 0),
    /// in which case the new values are merely inserted at the
    /// range location.
    ///
    /// Parameter `newValues`: A C array of the pointer-sized values to be placed
    /// into the array. The new values in the array are ordered in
    /// the same order in which they appear in this C array. This
    /// parameter may be NULL if the newCount parameter is 0. This
    /// C array is not changed or freed by this function. If this
    /// parameter is not a valid pointer to a C array of at least
    /// newCount pointers, the behavior is undefined.
    ///
    /// Parameter `newCount`: The number of values to copy from the values C
    /// array into the CFArray. If this parameter is different than
    /// the range length, the excess newCount values will be
    /// inserted after the range, or the excess range values will be
    /// deleted. This parameter may be 0, in which case no new
    /// values are replaced into the array and the values in the
    /// range are simply removed. If this parameter is negative, or
    /// greater than the number of values actually in the newValues
    /// C array, the behavior is undefined.
    #[doc(alias = "CFArrayReplaceValues")]
    #[inline]
    pub unsafe fn replace_values(
        the_array: Option<&CFMutableArray>,
        range: CFRange,
        new_values: *mut *const c_void,
        new_count: CFIndex,
    ) {
        extern "C-unwind" {
            fn CFArrayReplaceValues(
                the_array: Option<&CFMutableArray>,
                range: CFRange,
                new_values: *mut *const c_void,
                new_count: CFIndex,
            );
        }
        unsafe { CFArrayReplaceValues(the_array, range, new_values, new_count) }
    }

    /// Exchanges the values at two indices of the array.
    ///
    /// Parameter `theArray`: The array of which the values are to be swapped. If
    /// this parameter is not a valid mutable CFArray, the behavior
    /// is undefined.
    ///
    /// Parameter `idx1`: The first index whose values should be swapped. If the
    /// index is outside the index space of the array (0 to N-1
    /// inclusive, where N is the count of the array before the
    /// operation), the behavior is undefined.
    ///
    /// Parameter `idx2`: The second index whose values should be swapped. If the
    /// index is outside the index space of the array (0 to N-1
    /// inclusive, where N is the count of the array before the
    /// operation), the behavior is undefined.
    #[doc(alias = "CFArrayExchangeValuesAtIndices")]
    #[inline]
    pub unsafe fn exchange_values_at_indices(
        the_array: Option<&CFMutableArray>,
        idx1: CFIndex,
        idx2: CFIndex,
    ) {
        extern "C-unwind" {
            fn CFArrayExchangeValuesAtIndices(
                the_array: Option<&CFMutableArray>,
                idx1: CFIndex,
                idx2: CFIndex,
            );
        }
        unsafe { CFArrayExchangeValuesAtIndices(the_array, idx1, idx2) }
    }

    /// Sorts the values in the array using the given comparison function.
    ///
    /// Parameter `theArray`: The array whose values are to be sorted. If this
    /// parameter is not a valid mutable CFArray, the behavior is
    /// undefined.
    ///
    /// Parameter `range`: The range of values within the array to sort. If the
    /// range location or end point (defined by the location plus
    /// length minus 1) is outside the index space of the array (0
    /// to N-1 inclusive, where N is the count of the array), the
    /// behavior is undefined. If the range length is negative, the
    /// behavior is undefined. The range may be empty (length 0).
    ///
    /// Parameter `comparator`: The function with the comparator function type
    /// signature which is used in the sort operation to compare
    /// values in the array with the given value. If this parameter
    /// is not a pointer to a function of the correct prototype, the
    /// the behavior is undefined. If there are values in the array
    /// which the comparator function does not expect or cannot
    /// properly compare, the behavior is undefined. The values in
    /// the range are sorted from least to greatest according to
    /// this function.
    ///
    /// Parameter `context`: A pointer-sized user-defined value, which is passed
    /// as the third parameter to the comparator function, but is
    /// otherwise unused by this function. If the context is not
    /// what is expected by the comparator function, the behavior is
    /// undefined.
    #[doc(alias = "CFArraySortValues")]
    #[inline]
    pub unsafe fn sort_values(
        the_array: Option<&CFMutableArray>,
        range: CFRange,
        comparator: CFComparatorFunction,
        context: *mut c_void,
    ) {
        extern "C-unwind" {
            fn CFArraySortValues(
                the_array: Option<&CFMutableArray>,
                range: CFRange,
                comparator: CFComparatorFunction,
                context: *mut c_void,
            );
        }
        unsafe { CFArraySortValues(the_array, range, comparator, context) }
    }

    /// Adds the values from an array to another array.
    ///
    /// Parameter `theArray`: The array to which values from the otherArray are to
    /// be added. If this parameter is not a valid mutable CFArray,
    /// the behavior is undefined.
    ///
    /// Parameter `otherArray`: The array providing the values to be added to the
    /// array. If this parameter is not a valid CFArray, the
    /// behavior is undefined.
    ///
    /// Parameter `otherRange`: The range within the otherArray from which to add
    /// the values to the array. If the range location or end point
    /// (defined by the location plus length minus 1) is outside
    /// the index space of the otherArray (0 to N-1 inclusive, where
    /// N is the count of the otherArray), the behavior is
    /// undefined. The new values are retained by the array using
    /// the retain callback provided when the array was created. If
    /// the values are not of the sort expected by the retain
    /// callback, the behavior is undefined. The values are assigned
    /// to the indices one larger than the previous largest index
    /// in the array, and beyond, and the count of the array is
    /// increased by range.length. The values are assigned new
    /// indices in the array from smallest to largest index in the
    /// order in which they appear in the otherArray.
    #[doc(alias = "CFArrayAppendArray")]
    #[inline]
    pub unsafe fn append_array(
        the_array: Option<&CFMutableArray>,
        other_array: Option<&CFArray>,
        other_range: CFRange,
    ) {
        extern "C-unwind" {
            fn CFArrayAppendArray(
                the_array: Option<&CFMutableArray>,
                other_array: Option<&CFArray>,
                other_range: CFRange,
            );
        }
        unsafe { CFArrayAppendArray(the_array, other_array, other_range) }
    }
}

#[deprecated = "renamed to `CFArray::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFArrayCreate(
    allocator: Option<&CFAllocator>,
    values: *mut *const c_void,
    num_values: CFIndex,
    call_backs: *const CFArrayCallBacks,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFArrayCreate(
            allocator: Option<&CFAllocator>,
            values: *mut *const c_void,
            num_values: CFIndex,
            call_backs: *const CFArrayCallBacks,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFArrayCreate(allocator, values, num_values, call_backs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFArray::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFArrayCreateCopy(
    allocator: Option<&CFAllocator>,
    the_array: Option<&CFArray>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFArrayCreateCopy(
            allocator: Option<&CFAllocator>,
            the_array: Option<&CFArray>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFArrayCreateCopy(allocator, the_array) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableArray::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFArrayCreateMutable(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    call_backs: *const CFArrayCallBacks,
) -> Option<CFRetained<CFMutableArray>> {
    extern "C-unwind" {
        fn CFArrayCreateMutable(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            call_backs: *const CFArrayCallBacks,
        ) -> Option<NonNull<CFMutableArray>>;
    }
    let ret = unsafe { CFArrayCreateMutable(allocator, capacity, call_backs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableArray::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFArrayCreateMutableCopy(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    the_array: Option<&CFArray>,
) -> Option<CFRetained<CFMutableArray>> {
    extern "C-unwind" {
        fn CFArrayCreateMutableCopy(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            the_array: Option<&CFArray>,
        ) -> Option<NonNull<CFMutableArray>>;
    }
    let ret = unsafe { CFArrayCreateMutableCopy(allocator, capacity, the_array) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFArray::count`"]
#[inline]
pub extern "C-unwind" fn CFArrayGetCount(the_array: &CFArray) -> CFIndex {
    extern "C-unwind" {
        fn CFArrayGetCount(the_array: &CFArray) -> CFIndex;
    }
    unsafe { CFArrayGetCount(the_array) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFArray::count_of_value`"]
    pub fn CFArrayGetCountOfValue(
        the_array: &CFArray,
        range: CFRange,
        value: *const c_void,
    ) -> CFIndex;
}

#[deprecated = "renamed to `CFArray::contains_value`"]
#[inline]
pub unsafe extern "C-unwind" fn CFArrayContainsValue(
    the_array: &CFArray,
    range: CFRange,
    value: *const c_void,
) -> bool {
    extern "C-unwind" {
        fn CFArrayContainsValue(
            the_array: &CFArray,
            range: CFRange,
            value: *const c_void,
        ) -> Boolean;
    }
    let ret = unsafe { CFArrayContainsValue(the_array, range, value) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFArray::value_at_index`"]
    pub fn CFArrayGetValueAtIndex(the_array: &CFArray, idx: CFIndex) -> *const c_void;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFArray::values`"]
    pub fn CFArrayGetValues(the_array: &CFArray, range: CFRange, values: *mut *const c_void);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFArray::apply_function`"]
    pub fn CFArrayApplyFunction(
        the_array: &CFArray,
        range: CFRange,
        applier: CFArrayApplierFunction,
        context: *mut c_void,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFArray::first_index_of_value`"]
    pub fn CFArrayGetFirstIndexOfValue(
        the_array: &CFArray,
        range: CFRange,
        value: *const c_void,
    ) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFArray::last_index_of_value`"]
    pub fn CFArrayGetLastIndexOfValue(
        the_array: &CFArray,
        range: CFRange,
        value: *const c_void,
    ) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFArray::b_search_values`"]
    pub fn CFArrayBSearchValues(
        the_array: &CFArray,
        range: CFRange,
        value: *const c_void,
        comparator: CFComparatorFunction,
        context: *mut c_void,
    ) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::append_value`"]
    pub fn CFArrayAppendValue(the_array: Option<&CFMutableArray>, value: *const c_void);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::insert_value_at_index`"]
    pub fn CFArrayInsertValueAtIndex(
        the_array: Option<&CFMutableArray>,
        idx: CFIndex,
        value: *const c_void,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::set_value_at_index`"]
    pub fn CFArraySetValueAtIndex(
        the_array: Option<&CFMutableArray>,
        idx: CFIndex,
        value: *const c_void,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::remove_value_at_index`"]
    pub fn CFArrayRemoveValueAtIndex(the_array: Option<&CFMutableArray>, idx: CFIndex);
}

#[deprecated = "renamed to `CFMutableArray::remove_all_values`"]
#[inline]
pub extern "C-unwind" fn CFArrayRemoveAllValues(the_array: Option<&CFMutableArray>) {
    extern "C-unwind" {
        fn CFArrayRemoveAllValues(the_array: Option<&CFMutableArray>);
    }
    unsafe { CFArrayRemoveAllValues(the_array) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::replace_values`"]
    pub fn CFArrayReplaceValues(
        the_array: Option<&CFMutableArray>,
        range: CFRange,
        new_values: *mut *const c_void,
        new_count: CFIndex,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::exchange_values_at_indices`"]
    pub fn CFArrayExchangeValuesAtIndices(
        the_array: Option<&CFMutableArray>,
        idx1: CFIndex,
        idx2: CFIndex,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::sort_values`"]
    pub fn CFArraySortValues(
        the_array: Option<&CFMutableArray>,
        range: CFRange,
        comparator: CFComparatorFunction,
        context: *mut c_void,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableArray::append_array`"]
    pub fn CFArrayAppendArray(
        the_array: Option<&CFMutableArray>,
        other_array: Option<&CFArray>,
        other_range: CFRange,
    );
}
