/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.DescriptionScreen;
import com.install4j.runtime.beans.screens.componentselection.ComponentCellHandler;
import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class ComponentTree
extends JTree {
    private DescriptionScreen descriptionScreen;
    private ComponentCellHandler renderer;
    private ComponentCellHandler editor;
    private boolean isInStartEditing = false;

    public ComponentTree(DescriptionScreen descriptionScreen) {
        this.descriptionScreen = descriptionScreen;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    protected abstract ComponentTreeModel createTreeModel();

    public abstract String getIconTooltip(ComponentNodeConfig var1);

    public abstract Icon getLeafIcon(ComponentNodeConfig var1);

    public abstract int getLeafIconWidth();

    public DescriptionScreen getDescriptionScreen() {
        return this.descriptionScreen;
    }

    protected void setupControls() {
        this.renderer = this.createComponentCellHandler();
        this.editor = this.createComponentCellHandler();
    }

    protected ComponentCellHandler createComponentCellHandler() {
        return new ComponentCellHandler(this);
    }

    protected void setupComponent() {
        this.setRootVisible(false);
        ComponentTreeModel componentTreeModel = this.createTreeModel();
        this.setModel(componentTreeModel);
        this.setCellRenderer(this.renderer);
        this.setCellEditor(this.editor);
        this.modelSet();
        this.setRowHeight(0);
        this.setInvokesStopCellEditing(true);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)componentTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (defaultMutableTreeNode.getChildAt(i).getChildCount() <= 0) continue;
            bl = false;
            break;
        }
        this.setShowsRootHandles(!bl);
    }

    protected void modelSet() {
    }

    protected void setupEventHandlers() {
        this.addMouseListener(new ComponentTreeMouseListener());
        this.addKeyListener(new ComponentTreeKeyListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ComponentTree.this.resized();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                TreePath treePath;
                TreePath treePath2 = ComponentTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (!(treePath2 == null || (treePath = ComponentTree.this.getEditingPath()) != null && treePath.equals(treePath2))) {
                    ComponentTree.this.startEditingAtPath(treePath2);
                }
            }
        });
        this.editor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent changeEvent) {
                ComponentTree.this.requestFocus();
            }

            public void editingStopped(ChangeEvent changeEvent) {
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private void resized() {
        this.stopEditing();
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            TreePath treePath = this.getPathForRow(i);
            this.startEditingAtPath(treePath);
            this.stopEditing();
        }
    }

    public void updateAllNodes() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)defaultTreeModel.getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            defaultTreeModel.nodeChanged(defaultMutableTreeNode);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point;
        if (mouseEvent != null && (point = this.initRenderer(mouseEvent)) != null) {
            return this.renderer.getToolTipText(point);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEditingAtPath(TreePath treePath) {
        this.isInStartEditing = true;
        try {
            super.startEditingAtPath(treePath);
        }
        finally {
            this.isInStartEditing = false;
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (!this.isInStartEditing && this.getEditingPath() == null) {
            super.scrollRectToVisible(rectangle);
        }
    }

    public void scrollPathToVisible(TreePath treePath) {
        if (!this.isInStartEditing && this.getEditingPath() == null) {
            super.scrollPathToVisible(treePath);
        }
    }

    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        return null;
    }

    public void removeSelectionRow(int n) {
    }

    private Point initRenderer(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return null;
        }
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        Rectangle rectangle = this.getRowBounds(n);
        Point point = mouseEvent.getPoint();
        point.translate(-rectangle.x, -rectangle.y);
        this.renderer.getTreeCellRendererComponent(this, treePath.getLastPathComponent(), false, false, true, 0, false);
        this.renderer.setSize(this.renderer.getPreferredSize());
        this.renderer.doLayout();
        return point;
    }

    public void nodeToggled() {
    }

    public void selectionChanged(ComponentNode componentNode, boolean bl) {
    }

    private class ComponentTreeKeyListener
    extends KeyAdapter {
        private ComponentTreeKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TreePath treePath;
            if (keyEvent.getKeyCode() == 112) {
                ComponentNode componentNode;
                ComponentNodeConfig componentNodeConfig;
                TreePath treePath2 = ComponentTree.this.getSelectionPath();
                if (!(treePath2 == null || (componentNodeConfig = (componentNode = (ComponentNode)treePath2.getLastPathComponent()).getComponentNodeConfig()).isHideHelpButton() && componentNodeConfig.isInitialDisplayDescription())) {
                    componentNode.toggleDisplayDescription();
                }
            } else if (keyEvent.getKeyCode() == 32 && (treePath = ComponentTree.this.getSelectionPath()) != null) {
                ComponentTree.this.stopEditing();
                Object object = treePath.getLastPathComponent();
                ComponentNode componentNode = (ComponentNode)object;
                if (componentNode instanceof ComponentFolderNode && componentNode.isSelected() && !((ComponentFolderNode)componentNode).isAllSelected()) {
                    componentNode.setSelected(true, true);
                } else {
                    componentNode.setSelected(!componentNode.isSelected(), true);
                }
                ((DefaultTreeModel)ComponentTree.this.getModel()).nodeChanged(componentNode);
                keyEvent.consume();
                ComponentTree.this.startEditingAtPath(treePath);
            }
        }
    }

    private class ComponentTreeMouseListener
    extends MouseAdapter {
        private ComponentTreeMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TreePath treePath = ComponentTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                Point point = ComponentTree.this.initRenderer(mouseEvent);
                if (point == null) {
                    return;
                }
                if (ComponentTree.this.renderer.isPointInLabel(point)) {
                    if (ComponentTree.this.isExpanded(treePath)) {
                        ComponentTree.this.collapsePath(treePath);
                    } else {
                        ComponentTree.this.expandPath(treePath);
                    }
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!ComponentTree.this.isEnabled()) {
                return;
            }
            TreePath treePath = ComponentTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            Point point = ComponentTree.this.initRenderer(mouseEvent);
            if (point == null) {
                return;
            }
            if (ComponentTree.this.renderer.isPointInLabel(point)) {
                ComponentTree.this.stopEditing();
                ComponentTree.this.setSelectionPath(treePath);
            }
        }
    }
}

