/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class UnixJVMLocator {
    private static final String[] UNIX_DIR_KEYWORDS = new String[]{"java", "jre", "jdk", "j2sdk", "j2re", "j2jre"};
    public static final String[] JDK_FILES = new String[]{"bin/javac", "lib/tools.jar"};
    public static final String JAVA_EXECUTABLE = "bin/java";

    public static Collection getJVMLocations() {
        HashSet hashSet = new HashSet();
        String[] stringArray = new String[]{"/opt/i4j_jres", "/usr/local/i4j_jres", new File(Util.getUserHome(), ".i4j_jres").getAbsolutePath(), "/usr/bin", "/usr", "/usr/java", "/usr/lib/java", "/usr/lib/jvm", "/usr/local", "/usr/lib", "/usr/jdk", "/opt"};
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.addAll(UnixJVMLocator.searchRootLocation(stringArray[i]));
        }
        return hashSet;
    }

    private static Collection searchRootLocation(String string) {
        HashSet<JVMLocator.JVMLocation> hashSet = new HashSet<JVMLocator.JVMLocation>();
        File[] fileArray = new File(string).listFiles();
        if (fileArray != null) {
            block2: for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isDirectory()) continue;
                for (int j = 0; j < UNIX_DIR_KEYWORDS.length; ++j) {
                    if (file.getName().indexOf(UNIX_DIR_KEYWORDS[j]) <= -1) continue;
                    try {
                        JVMLocator.JVMLocation jVMLocation = JVMLocator.checkJVMLocation(file, JAVA_EXECUTABLE, JDK_FILES);
                        if (jVMLocation == null) continue block2;
                        hashSet.add(jVMLocation);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue block2;
                }
            }
        }
        return hashSet;
    }
}

