/***************************************************************************
 *   crwx-ng                                                               *
 *   Copyright (C) 2007 Vadim Lopatin <coolreader.org@gmail.com>           *
 *   Copyright (C) 2020,2023,2024 Aleksey Chernov <valexlin@gmail.com>     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,            *
 *   MA 02110-1301, USA.                                                   *
 ***************************************************************************/

#ifndef UTILS_H
#define UTILS_H

#include <wx/string.h>

#include <lvstring.h>

#include <crprops.h>

lString32 wx2cr(wxString str);
wxString cr2wx(lString32 str);

lString32 getMainDataDir();
lString32 getEngineDataDir();
lString32 getExeDir();
lString32 getConfigDir();
lString32 getEngineCacheDir();

/**
 * Adds properties missing from dest from source.
 * @param dest destination properties reference
 * @param source source properties reference
 * @return reference to destination
 *
 * If some property is present in both dest and source, then this property does not change.
 */
CRPropRef addProperties(CRPropRef dest, CRPropRef source);

#endif // UTILS_H
