// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/devtools/build/v1/publish_build_event.proto

package build

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The service level of the build request. Backends only uses this value when
// the BuildEnqueued event is published to determine what level of service
// this build should receive.
type PublishLifecycleEventRequest_ServiceLevel int32

const (
	// Non-interactive builds can tolerate longer event latencies. This is the
	// default ServiceLevel if callers do not specify one.
	PublishLifecycleEventRequest_NONINTERACTIVE PublishLifecycleEventRequest_ServiceLevel = 0
	// The events of an interactive build should be delivered with low latency.
	PublishLifecycleEventRequest_INTERACTIVE PublishLifecycleEventRequest_ServiceLevel = 1
)

// Enum value maps for PublishLifecycleEventRequest_ServiceLevel.
var (
	PublishLifecycleEventRequest_ServiceLevel_name = map[int32]string{
		0: "NONINTERACTIVE",
		1: "INTERACTIVE",
	}
	PublishLifecycleEventRequest_ServiceLevel_value = map[string]int32{
		"NONINTERACTIVE": 0,
		"INTERACTIVE":    1,
	}
)

func (x PublishLifecycleEventRequest_ServiceLevel) Enum() *PublishLifecycleEventRequest_ServiceLevel {
	p := new(PublishLifecycleEventRequest_ServiceLevel)
	*p = x
	return p
}

func (x PublishLifecycleEventRequest_ServiceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublishLifecycleEventRequest_ServiceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_build_v1_publish_build_event_proto_enumTypes[0].Descriptor()
}

func (PublishLifecycleEventRequest_ServiceLevel) Type() protoreflect.EnumType {
	return &file_google_devtools_build_v1_publish_build_event_proto_enumTypes[0]
}

func (x PublishLifecycleEventRequest_ServiceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublishLifecycleEventRequest_ServiceLevel.Descriptor instead.
func (PublishLifecycleEventRequest_ServiceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_publish_build_event_proto_rawDescGZIP(), []int{0, 0}
}

// Publishes 'lifecycle events' that update the high-level state of a build:
// - BuildEnqueued: When a build is scheduled.
// - InvocationAttemptStarted: When work for a build starts; there can be
//     multiple invocations for a build (e.g. retries).
// - InvocationAttemptCompleted: When work for a build finishes.
// - BuildFinished: When a build is finished.
type PublishLifecycleEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The interactivity of this build.
	ServiceLevel PublishLifecycleEventRequest_ServiceLevel `protobuf:"varint,1,opt,name=service_level,json=serviceLevel,proto3,enum=google.devtools.build.v1.PublishLifecycleEventRequest_ServiceLevel" json:"service_level,omitempty"`
	// Required. The lifecycle build event. If this is a build tool event, the RPC
	// will fail with INVALID_REQUEST.
	BuildEvent *OrderedBuildEvent `protobuf:"bytes,2,opt,name=build_event,json=buildEvent,proto3" json:"build_event,omitempty"`
	// If the next event for this build or invocation (depending on the event
	// type) hasn't been published after this duration from when {build_event}
	// is written to BES, consider this stream expired. If this field is not set,
	// BES backend will use its own default value.
	StreamTimeout *durationpb.Duration `protobuf:"bytes,3,opt,name=stream_timeout,json=streamTimeout,proto3" json:"stream_timeout,omitempty"`
	// Additional information about a build request. These are define by the event
	// publishers, and the Build Event Service does not validate or interpret
	// them. They are used while notifying internal systems of new builds and
	// invocations if the OrderedBuildEvent.event type is
	// BuildEnqueued/InvocationAttemptStarted.
	NotificationKeywords []string `protobuf:"bytes,4,rep,name=notification_keywords,json=notificationKeywords,proto3" json:"notification_keywords,omitempty"`
	// Required. The project this build is associated with.
	// This should match the project used for the initial call to
	// PublishLifecycleEvent (containing a BuildEnqueued message).
	ProjectId string `protobuf:"bytes,6,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *PublishLifecycleEventRequest) Reset() {
	*x = PublishLifecycleEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishLifecycleEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishLifecycleEventRequest) ProtoMessage() {}

func (x *PublishLifecycleEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishLifecycleEventRequest.ProtoReflect.Descriptor instead.
func (*PublishLifecycleEventRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_publish_build_event_proto_rawDescGZIP(), []int{0}
}

func (x *PublishLifecycleEventRequest) GetServiceLevel() PublishLifecycleEventRequest_ServiceLevel {
	if x != nil {
		return x.ServiceLevel
	}
	return PublishLifecycleEventRequest_NONINTERACTIVE
}

func (x *PublishLifecycleEventRequest) GetBuildEvent() *OrderedBuildEvent {
	if x != nil {
		return x.BuildEvent
	}
	return nil
}

func (x *PublishLifecycleEventRequest) GetStreamTimeout() *durationpb.Duration {
	if x != nil {
		return x.StreamTimeout
	}
	return nil
}

func (x *PublishLifecycleEventRequest) GetNotificationKeywords() []string {
	if x != nil {
		return x.NotificationKeywords
	}
	return nil
}

func (x *PublishLifecycleEventRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// States which event has been committed. Any failure to commit will cause
// RPC errors, hence not recorded by this proto.
type PublishBuildToolEventStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The stream that contains this event.
	StreamId *StreamId `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The sequence number of this event that has been committed.
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
}

func (x *PublishBuildToolEventStreamResponse) Reset() {
	*x = PublishBuildToolEventStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishBuildToolEventStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishBuildToolEventStreamResponse) ProtoMessage() {}

func (x *PublishBuildToolEventStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishBuildToolEventStreamResponse.ProtoReflect.Descriptor instead.
func (*PublishBuildToolEventStreamResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_publish_build_event_proto_rawDescGZIP(), []int{1}
}

func (x *PublishBuildToolEventStreamResponse) GetStreamId() *StreamId {
	if x != nil {
		return x.StreamId
	}
	return nil
}

func (x *PublishBuildToolEventStreamResponse) GetSequenceNumber() int64 {
	if x != nil {
		return x.SequenceNumber
	}
	return 0
}

// Build event with contextual information about the stream it belongs to and
// its position in that stream.
type OrderedBuildEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which build event stream this event belongs to.
	StreamId *StreamId `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The position of this event in the stream. The sequence numbers for a build
	// event stream should be a sequence of consecutive natural numbers starting
	// from one. (1, 2, 3, ...)
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	// The actual event.
	Event *BuildEvent `protobuf:"bytes,3,opt,name=event,proto3" json:"event,omitempty"`
}

func (x *OrderedBuildEvent) Reset() {
	*x = OrderedBuildEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderedBuildEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderedBuildEvent) ProtoMessage() {}

func (x *OrderedBuildEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderedBuildEvent.ProtoReflect.Descriptor instead.
func (*OrderedBuildEvent) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_publish_build_event_proto_rawDescGZIP(), []int{2}
}

func (x *OrderedBuildEvent) GetStreamId() *StreamId {
	if x != nil {
		return x.StreamId
	}
	return nil
}

func (x *OrderedBuildEvent) GetSequenceNumber() int64 {
	if x != nil {
		return x.SequenceNumber
	}
	return 0
}

func (x *OrderedBuildEvent) GetEvent() *BuildEvent {
	if x != nil {
		return x.Event
	}
	return nil
}

// Streaming request message for PublishBuildToolEventStream.
type PublishBuildToolEventStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The build event with position info.
	// New publishing clients should use this field rather than the 3 above.
	OrderedBuildEvent *OrderedBuildEvent `protobuf:"bytes,4,opt,name=ordered_build_event,json=orderedBuildEvent,proto3" json:"ordered_build_event,omitempty"`
	// The keywords to be attached to the notification which notifies the start
	// of a new build event stream. BES only reads this field when sequence_number
	// or ordered_build_event.sequence_number is 1 in this message. If this field
	// is empty, BES will not publish notification messages for this stream.
	NotificationKeywords []string `protobuf:"bytes,5,rep,name=notification_keywords,json=notificationKeywords,proto3" json:"notification_keywords,omitempty"`
	// Required. The project this build is associated with.
	// This should match the project used for the initial call to
	// PublishLifecycleEvent (containing a BuildEnqueued message).
	ProjectId string `protobuf:"bytes,6,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *PublishBuildToolEventStreamRequest) Reset() {
	*x = PublishBuildToolEventStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishBuildToolEventStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishBuildToolEventStreamRequest) ProtoMessage() {}

func (x *PublishBuildToolEventStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_build_v1_publish_build_event_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishBuildToolEventStreamRequest.ProtoReflect.Descriptor instead.
func (*PublishBuildToolEventStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_build_v1_publish_build_event_proto_rawDescGZIP(), []int{3}
}

func (x *PublishBuildToolEventStreamRequest) GetOrderedBuildEvent() *OrderedBuildEvent {
	if x != nil {
		return x.OrderedBuildEvent
	}
	return nil
}

func (x *PublishBuildToolEventStreamRequest) GetNotificationKeywords() []string {
	if x != nil {
		return x.NotificationKeywords
	}
	return nil
}

func (x *PublishBuildToolEventStreamRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

var File_google_devtools_build_v1_publish_build_event_proto protoreflect.FileDescriptor

var file_google_devtools_build_v1_publish_build_event_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76, 0x31,
	0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xab, 0x03, 0x0a, 0x1c, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x4c, 0x69, 0x66, 0x65,
	0x63, 0x79, 0x63, 0x6c, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x68, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x4c, 0x69, 0x66, 0x65, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x51, 0x0a, 0x0b, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x40,
	0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x12, 0x33, 0x0a, 0x15, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x33, 0x0a, 0x0c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x4e,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x22, 0x8f,
	0x01, 0x0a, 0x23, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54,
	0x6f, 0x6f, 0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x52, 0x08, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x22, 0xb9, 0x01, 0x0a, 0x11, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x52, 0x08, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x3a, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0xdf, 0x01, 0x0a,
	0x22, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x6f, 0x6f,
	0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x13, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x15, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x32, 0xde,
	0x04, 0x0a, 0x11, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0xc9, 0x01, 0x0a, 0x15, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x60,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x3d, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x3a, 0x01, 0x2a, 0x5a, 0x20,
	0x22, 0x1b, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x3a, 0x01, 0x2a,
	0x12, 0xa6, 0x02, 0x0a, 0x1b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x54, 0x6f, 0x6f, 0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x6f, 0x6f, 0x6c, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x6f, 0x6f, 0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x85, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x3d, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x3a, 0x01, 0x2a, 0x5a, 0x17, 0x22, 0x12, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x34, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x28, 0x01, 0x30, 0x01, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x88, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x42, 0x0c, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76, 0x31, 0x3b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0xf8,
	0x01, 0x01, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_devtools_build_v1_publish_build_event_proto_rawDescOnce sync.Once
	file_google_devtools_build_v1_publish_build_event_proto_rawDescData = file_google_devtools_build_v1_publish_build_event_proto_rawDesc
)

func file_google_devtools_build_v1_publish_build_event_proto_rawDescGZIP() []byte {
	file_google_devtools_build_v1_publish_build_event_proto_rawDescOnce.Do(func() {
		file_google_devtools_build_v1_publish_build_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_build_v1_publish_build_event_proto_rawDescData)
	})
	return file_google_devtools_build_v1_publish_build_event_proto_rawDescData
}

var file_google_devtools_build_v1_publish_build_event_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_devtools_build_v1_publish_build_event_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_devtools_build_v1_publish_build_event_proto_goTypes = []interface{}{
	(PublishLifecycleEventRequest_ServiceLevel)(0), // 0: google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel
	(*PublishLifecycleEventRequest)(nil),           // 1: google.devtools.build.v1.PublishLifecycleEventRequest
	(*PublishBuildToolEventStreamResponse)(nil),    // 2: google.devtools.build.v1.PublishBuildToolEventStreamResponse
	(*OrderedBuildEvent)(nil),                      // 3: google.devtools.build.v1.OrderedBuildEvent
	(*PublishBuildToolEventStreamRequest)(nil),     // 4: google.devtools.build.v1.PublishBuildToolEventStreamRequest
	(*durationpb.Duration)(nil),                    // 5: google.protobuf.Duration
	(*StreamId)(nil),                               // 6: google.devtools.build.v1.StreamId
	(*BuildEvent)(nil),                             // 7: google.devtools.build.v1.BuildEvent
	(*emptypb.Empty)(nil),                          // 8: google.protobuf.Empty
}
var file_google_devtools_build_v1_publish_build_event_proto_depIdxs = []int32{
	0, // 0: google.devtools.build.v1.PublishLifecycleEventRequest.service_level:type_name -> google.devtools.build.v1.PublishLifecycleEventRequest.ServiceLevel
	3, // 1: google.devtools.build.v1.PublishLifecycleEventRequest.build_event:type_name -> google.devtools.build.v1.OrderedBuildEvent
	5, // 2: google.devtools.build.v1.PublishLifecycleEventRequest.stream_timeout:type_name -> google.protobuf.Duration
	6, // 3: google.devtools.build.v1.PublishBuildToolEventStreamResponse.stream_id:type_name -> google.devtools.build.v1.StreamId
	6, // 4: google.devtools.build.v1.OrderedBuildEvent.stream_id:type_name -> google.devtools.build.v1.StreamId
	7, // 5: google.devtools.build.v1.OrderedBuildEvent.event:type_name -> google.devtools.build.v1.BuildEvent
	3, // 6: google.devtools.build.v1.PublishBuildToolEventStreamRequest.ordered_build_event:type_name -> google.devtools.build.v1.OrderedBuildEvent
	1, // 7: google.devtools.build.v1.PublishBuildEvent.PublishLifecycleEvent:input_type -> google.devtools.build.v1.PublishLifecycleEventRequest
	4, // 8: google.devtools.build.v1.PublishBuildEvent.PublishBuildToolEventStream:input_type -> google.devtools.build.v1.PublishBuildToolEventStreamRequest
	8, // 9: google.devtools.build.v1.PublishBuildEvent.PublishLifecycleEvent:output_type -> google.protobuf.Empty
	2, // 10: google.devtools.build.v1.PublishBuildEvent.PublishBuildToolEventStream:output_type -> google.devtools.build.v1.PublishBuildToolEventStreamResponse
	9, // [9:11] is the sub-list for method output_type
	7, // [7:9] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_devtools_build_v1_publish_build_event_proto_init() }
func file_google_devtools_build_v1_publish_build_event_proto_init() {
	if File_google_devtools_build_v1_publish_build_event_proto != nil {
		return
	}
	file_google_devtools_build_v1_build_events_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_build_v1_publish_build_event_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishLifecycleEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_publish_build_event_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishBuildToolEventStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_publish_build_event_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderedBuildEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_build_v1_publish_build_event_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishBuildToolEventStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_build_v1_publish_build_event_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_build_v1_publish_build_event_proto_goTypes,
		DependencyIndexes: file_google_devtools_build_v1_publish_build_event_proto_depIdxs,
		EnumInfos:         file_google_devtools_build_v1_publish_build_event_proto_enumTypes,
		MessageInfos:      file_google_devtools_build_v1_publish_build_event_proto_msgTypes,
	}.Build()
	File_google_devtools_build_v1_publish_build_event_proto = out.File
	file_google_devtools_build_v1_publish_build_event_proto_rawDesc = nil
	file_google_devtools_build_v1_publish_build_event_proto_goTypes = nil
	file_google_devtools_build_v1_publish_build_event_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PublishBuildEventClient is the client API for PublishBuildEvent service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PublishBuildEventClient interface {
	// Publish a build event stating the new state of a build (typically from the
	// build queue). The BuildEnqueued event must be publishd before all other
	// events for the same build ID.
	//
	// The backend will persist the event and deliver it to registered frontend
	// jobs immediately without batching.
	//
	// The commit status of the request is reported by the RPC's util_status()
	// function. The error code is the canoncial error code defined in
	// //util/task/codes.proto.
	PublishLifecycleEvent(ctx context.Context, in *PublishLifecycleEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Publish build tool events belonging to the same stream to a backend job
	// using bidirectional streaming.
	PublishBuildToolEventStream(ctx context.Context, opts ...grpc.CallOption) (PublishBuildEvent_PublishBuildToolEventStreamClient, error)
}

type publishBuildEventClient struct {
	cc grpc.ClientConnInterface
}

func NewPublishBuildEventClient(cc grpc.ClientConnInterface) PublishBuildEventClient {
	return &publishBuildEventClient{cc}
}

func (c *publishBuildEventClient) PublishLifecycleEvent(ctx context.Context, in *PublishLifecycleEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publishBuildEventClient) PublishBuildToolEventStream(ctx context.Context, opts ...grpc.CallOption) (PublishBuildEvent_PublishBuildToolEventStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PublishBuildEvent_serviceDesc.Streams[0], "/google.devtools.build.v1.PublishBuildEvent/PublishBuildToolEventStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &publishBuildEventPublishBuildToolEventStreamClient{stream}
	return x, nil
}

type PublishBuildEvent_PublishBuildToolEventStreamClient interface {
	Send(*PublishBuildToolEventStreamRequest) error
	Recv() (*PublishBuildToolEventStreamResponse, error)
	grpc.ClientStream
}

type publishBuildEventPublishBuildToolEventStreamClient struct {
	grpc.ClientStream
}

func (x *publishBuildEventPublishBuildToolEventStreamClient) Send(m *PublishBuildToolEventStreamRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *publishBuildEventPublishBuildToolEventStreamClient) Recv() (*PublishBuildToolEventStreamResponse, error) {
	m := new(PublishBuildToolEventStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// PublishBuildEventServer is the server API for PublishBuildEvent service.
type PublishBuildEventServer interface {
	// Publish a build event stating the new state of a build (typically from the
	// build queue). The BuildEnqueued event must be publishd before all other
	// events for the same build ID.
	//
	// The backend will persist the event and deliver it to registered frontend
	// jobs immediately without batching.
	//
	// The commit status of the request is reported by the RPC's util_status()
	// function. The error code is the canoncial error code defined in
	// //util/task/codes.proto.
	PublishLifecycleEvent(context.Context, *PublishLifecycleEventRequest) (*emptypb.Empty, error)
	// Publish build tool events belonging to the same stream to a backend job
	// using bidirectional streaming.
	PublishBuildToolEventStream(PublishBuildEvent_PublishBuildToolEventStreamServer) error
}

// UnimplementedPublishBuildEventServer can be embedded to have forward compatible implementations.
type UnimplementedPublishBuildEventServer struct {
}

func (*UnimplementedPublishBuildEventServer) PublishLifecycleEvent(context.Context, *PublishLifecycleEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishLifecycleEvent not implemented")
}
func (*UnimplementedPublishBuildEventServer) PublishBuildToolEventStream(PublishBuildEvent_PublishBuildToolEventStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method PublishBuildToolEventStream not implemented")
}

func RegisterPublishBuildEventServer(s *grpc.Server, srv PublishBuildEventServer) {
	s.RegisterService(&_PublishBuildEvent_serviceDesc, srv)
}

func _PublishBuildEvent_PublishLifecycleEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishLifecycleEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublishBuildEventServer).PublishLifecycleEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublishBuildEventServer).PublishLifecycleEvent(ctx, req.(*PublishLifecycleEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublishBuildEvent_PublishBuildToolEventStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PublishBuildEventServer).PublishBuildToolEventStream(&publishBuildEventPublishBuildToolEventStreamServer{stream})
}

type PublishBuildEvent_PublishBuildToolEventStreamServer interface {
	Send(*PublishBuildToolEventStreamResponse) error
	Recv() (*PublishBuildToolEventStreamRequest, error)
	grpc.ServerStream
}

type publishBuildEventPublishBuildToolEventStreamServer struct {
	grpc.ServerStream
}

func (x *publishBuildEventPublishBuildToolEventStreamServer) Send(m *PublishBuildToolEventStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *publishBuildEventPublishBuildToolEventStreamServer) Recv() (*PublishBuildToolEventStreamRequest, error) {
	m := new(PublishBuildToolEventStreamRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _PublishBuildEvent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.build.v1.PublishBuildEvent",
	HandlerType: (*PublishBuildEventServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PublishLifecycleEvent",
			Handler:    _PublishBuildEvent_PublishLifecycleEvent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PublishBuildToolEventStream",
			Handler:       _PublishBuildEvent_PublishBuildToolEventStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/devtools/build/v1/publish_build_event.proto",
}
