
"""
This script is meant to be sourced inside GDB when debugging a program that
uses gpr_parser. It installs Langkit's "GDB helpers": pretty-printers and
custom commands that are convenient when debugging gpr_parser. Note that GDB
helpers require the Langkit Python library.
"""

import sys


sys.path.append('/home/chouteau/src/github/langkit')


try:
    import langkit.gdb
except ImportError as exc:
    print(
        f"{__file__}: Cannot import the 'langkit.gdb' Python package: langkit"
        " GDB helpers require it",
        file=sys.stderr,
    )
else:
    
    langkit.gdb.setup(
        lib_name='gpr_parser',
        astnode_names=['Gpr_Node', 'All_Qualifier', 'All_Qualifier_Absent', 'All_Qualifier_Present', 'Attribute_Decl', 'Attribute_Reference', 'Base_List', 'Case_Item_List', 'Gpr_Node_List', 'Choices', 'Term_List', 'Identifier_List', 'String_Literal_List', 'Term_List_List', 'With_Decl_List', 'Builtin_Function_Call', 'Case_Construction', 'Case_Item', 'Compilation_Unit', 'Empty_Decl', 'Expr', 'Prefix', 'Single_Tok_Node', 'Identifier', 'Num_Literal', 'String_Literal', 'Limited_Node', 'Limited_Absent', 'Limited_Present', 'Others_Designator', 'Package_Decl', 'Package_Extension', 'Package_Renaming', 'Package_Spec', 'Project', 'Project_Declaration', 'Project_Extension', 'Project_Qualifier', 'Project_Qualifier_Abstract', 'Project_Qualifier_Aggregate', 'Project_Qualifier_Aggregate_Library', 'Project_Qualifier_Configuration', 'Project_Qualifier_Library', 'Project_Qualifier_Standard', 'String_Literal_At', 'Terms', 'Type_Reference', 'Typed_String_Decl', 'Variable_Decl', 'Variable_Reference', 'With_Decl'],
        astnode_kinds={1: 'All_Qualifier_Absent', 2: 'All_Qualifier_Present', 3: 'Attribute_Decl', 4: 'Attribute_Reference', 5: 'Case_Item_List', 6: 'Gpr_Node_List', 7: 'Choices', 8: 'Term_List', 9: 'Identifier_List', 10: 'String_Literal_List', 11: 'Term_List_List', 12: 'With_Decl_List', 13: 'Builtin_Function_Call', 14: 'Case_Construction', 15: 'Case_Item', 16: 'Compilation_Unit', 17: 'Empty_Decl', 18: 'Prefix', 19: 'Identifier', 20: 'Num_Literal', 21: 'String_Literal', 22: 'Limited_Absent', 23: 'Limited_Present', 24: 'Others_Designator', 25: 'Package_Decl', 26: 'Package_Extension', 27: 'Package_Renaming', 28: 'Package_Spec', 29: 'Project', 30: 'Project_Declaration', 31: 'Project_Extension', 32: 'Project_Qualifier_Abstract', 33: 'Project_Qualifier_Aggregate', 34: 'Project_Qualifier_Aggregate_Library', 35: 'Project_Qualifier_Configuration', 36: 'Project_Qualifier_Library', 37: 'Project_Qualifier_Standard', 38: 'String_Literal_At', 39: 'Terms', 40: 'Type_Reference', 41: 'Typed_String_Decl', 42: 'Variable_Decl', 43: 'Variable_Reference', 44: 'With_Decl'},
        prefix='gpr_parser'
    )
