# To get a package list without version numbers from a target system
# rpm -qa --qf "%{n} " > packages.txt
# Put contents of packages.txt after "-y install \" line below

rm -rf /root/ostemplate ; mkdir /root/ostemplate
mkdir -p /root/ostemplate/var/lib
touch /root/ostemplate/var/lib/random-seed

dnf \
--installroot=/root/ostemplate \
--nogpg \
--releasever=22 \
--disablerepo=* --enablerepo="fedora" --enablerepo="updates" \
-y install \
mailx filesystem screen basesystem sudo quota-nls logrotate ncurses-base vim-enhanced tzdata tmpwatch libgcc elfutils man-pages jwhois glibc-common attr xz-libs unzip ncurses-libs ed pcre time \
libselinux traceroute info telnet popt ethtool audit-libs bzip2-libs nspr readline libattr libcap libuuid libidn expat libtevent libtdb libgcrypt cyrus-sasl-lib pkgconfig shared-mime-info \
libwbclient groff-base libcap-ng perl-HTTP-Tiny perl-podlators perl-Text-ParseWords perl-Pod-Escapes perl-Pod-Usage perl-Time-Local perl-Time-HiRes perl-libs perl-threads-shared perl-macros \
perl-File-Path perl-Pod-Simple perl-File-Temp perl-Filter perl apr-util libassuan e2fsprogs-libs kmod-libs iptables slang lm_sensors-libs perl-Data-Dumper avahi-libs libmetalink acl libdb-utils \
libss cpio diffutils aspell file-libs procmail xz ncurses gmp ustr nss-tools gzip cracklib-dicts libpwquality libmount shadow-utils systemd-libs libutempter nss-sysinit libldb procps-ng libusb \
usermode krb5-libs libpcap p11-kit-trust openssl-libs python python-six httpd-tools libcurl python-urlgrabber rpm-libs net-snmp-agent-libs newt-python bind-libs fipscheck \
dnf openssl cups-libs mariadb-libs gnupg2 rpm-python pygpgme linux-atm-libs aspell-en device-mapper cryptsetup-libs dbus cronie-noanacron crontabs libsmbclient \
iptables-services cyrus-sasl sendmail sendmail-doc net-snmp nscd openssh-server finger-server bind authconfig gnupg stunnel wget tcpdump setup setuptool bind-license e2fsprogs \
fedora-logos-httpd binutils vim-filesystem tcsh mailcap xz-lzma-compat fedora-release quota rootfiles ntsysv nss-softokn-freebl tar glibc ftp libstdc++ bzip2 bash sharutils libsepol lsof zlib \
talk libcom_err ncompress chkconfig finger libdb tcp_wrappers-libs grep libtalloc libacl sed nss-util libgpg-error libbsd libxml2 elfutils-libelf lua libffi glib2 dbus-libs apr sqlite gdbm \
perl-parent perl-Pod-Perldoc perl-version perl-Encode perl-Carp perl-constant perl-Socket perl-Scalar-List-Utils perl-threads perl-Storable perl-Module-CoreList perl-Getopt-Long perl-PathTools \
perl-Exporter nss-softokn p11-kit hesiod gawk kmod keyutils-libs newt hostname less elfutils-libs vim-minimal tcp_wrappers pinentry m4 findutils which make psmisc vim-common libedit gpm-libs \
libaio libsemanage openldap cracklib nss libuser coreutils pam libblkid util-linux dhcp-libs dhcp-common libusbx passwd libverto libtirpc libtasn1 ca-certificates python-libs net-snmp-libs \
python-iniparse libssh2 python-pycurl curl rpm pytalloc pyliblzma pyxattr fipscheck-lib openssh bind-libs-lite pth rpm-build-libs gpgme libpipeline iproute qrencode-libs \
device-mapper-libs systemd cronie iputils httpd initscripts dhclient sendmail-cf mlocate rsync talk-server rpcbind man-db \
openssh-clients net-snmp-utils lynx fetchmail nano screen tmux mc links net-tools fedora-release net-tools

# Fix up /etc/fstab
echo "none /dev/pts devpts rw,gid=5,mode=620 0 0" > /root/ostemplate/etc/fstab
echo "none /dev/shm tmpfs defaults 0 0" >> /ostemplate/etc/fstab
ln -sf /proc/mounts /root/ostemplate/etc/mtab
touch /root/ostemplate/etc/fstab

# Get rid of gettys
# sed -i -e 's/ACTIVE_CONSOLES=\/dev\/tty\[1\-6\]/ACTIVE_CONSOLES=/g' /root/ostemplate/etc/sysconfig/init

# Clean up yum, etc
# yum --installroot=/root/ostemplate clean all
rm -rf /root/ostemplate/var/cache/dnf/*
rm -rf /root/ostemplate/var/lib/dnf/yumdb/*
rm -f /root/ostemplate/dev/null
mknod -m 600 /root/ostemplate/dev/console c 5 1

# Fix networking
cd /root/ostemplate/etc/rc.d/rc3.d ; ln -sf ../init.d/network S10network

# Copy the scripts into the new container
cp /root/create-fedora22* /root/ostemplate/root/

# Create .tar.xz file
cd /root/ostemplate ; tar -cvJf /root/fedora-22-x86_64-$(date +%Y%m%d).tar.xz . 
ls -lh /root/fedora-22-x86_64-$(date +%Y%m%d).tar.xz 
echo "Done building OS Template.  Now test it."
