/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int ((*)())()
 *   XSetAfterFunction(display, procedure)
 *   Display *display;
 *   int (*procedure)();
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetAfterFunction	1
char    *TestName = "XSetAfterFunction";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetAfterFunction function
 */
static Display *display;
static int (*procedure)();


static int 	ValueReturn;

static	int	counter = 0;

static int
afterfunction(display)
Display *display;
{
	trace("In afterfunction(), screen number %d", XDefaultScreen(display));
	return(counter++);
}
static int
_afterfunction(display)
Display *display;
{
	trace("In _afterfunction(), screen number %d", XDefaultScreen(display));
	return(--counter);
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	procedure = afterfunction;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	oldcounter;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetAfterFunction-1.(A)");
	report_assertion("A call to XSetAfterFunction sets the after function to");
	report_assertion("procedure.");

	report_strategy("Create window.");
	report_strategy("Verify that afterfunction was not called.");
	report_strategy("Call XSetAfterFunction to set the after function to afterfunction.");
	report_strategy("Create window.");
	report_strategy("Verify that the after function was called.");

	tpstartup();
	setargs();
	oldcounter = counter;
/* Create window. */
	mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Verify that afterfunction was not called. */
	if (counter != oldcounter) {
		delete("After function already set to afterfunction.");
		return;
	}
	else
		CHECK;
/* Call XSetAfterFunction to set the after function to afterfunction. */
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetAfterFunction(display, procedure);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Create window. */
	mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Verify that the after function was called. */
	if (counter == oldcounter) {
		report("After function not called.");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	(*proc)();
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetAfterFunction-2.(A)");
	report_assertion("A call to XSetAfterFunction returns the previous after");
	report_assertion("function.");

	report_strategy("Call XSetAfterFunction to set after function to afterfunction.");
	report_strategy("Call XSetAfterFunction to set after function to _afterfunction.");
	report_strategy("Verify that XSetAfterFunction returned afterfunction.");
	report_strategy("Call XSetAfterFunction to set after function to afterfunction.");
	report_strategy("Verify that XSetAfterFunction returned _afterfunction.");

	tpstartup();
	setargs();
/* Call XSetAfterFunction to set after function to afterfunction. */
	procedure = afterfunction;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetAfterFunction(display, procedure);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Call XSetAfterFunction to set after function to _afterfunction. */
	procedure = _afterfunction;
	startcall(display);
	if (isdeleted())
		return;
	proc = XSetAfterFunction(display, procedure);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that XSetAfterFunction returned afterfunction. */
	if (proc != afterfunction) {
		report("Returned 0x%x, expected 0x%x", proc, afterfunction);
		FAIL;
	}
	else
		CHECK;
/* Call XSetAfterFunction to set after function to afterfunction. */
	procedure = afterfunction;
	startcall(display);
	if (isdeleted())
		return;
	proc = XSetAfterFunction(display, procedure);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that XSetAfterFunction returned _afterfunction. */
	if (proc != _afterfunction) {
		report("Returned 0x%x, expected 0x%x", proc, _afterfunction);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.363740 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetAfterFunction-3.(B)");
	report_assertion("After a call to XSetAfterFunction, all Xlib functions that");
	report_assertion("generate protocol requests call procedure before returning.");
	report_assertion("Reason for omission: Creating a test would require an unreasonable amount of test development time.");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.363740 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
