/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XrmQGetSearchList(database, names, classes, list_return, list_length)
 *   XrmDatabase database;
 *   XrmNameList names;
 *   XrmClassList classes;
 *   XrmHashTable *list_return;
 *   int list_length;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmQGetSearchList	1
char    *TestName = "XrmQGetSearchList";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmQGetSearchList function
 */
static XrmDatabase database;
static XrmNameList names;
static XrmClassList classes;
static XrmHashTable *list_return;
static int list_length;



#define XQGSL_LENGTH 3
static	XrmHashTable	sl[XQGSL_LENGTH];

#define XQGSL_N_QUARK 10

static	XrmName	nl[XQGSL_N_QUARK];
static	XrmClass	cl[XQGSL_N_QUARK];

#define XQGSL_T3_ENTRIES 2
static char *t3_data[XQGSL_T3_ENTRIES] = {
	"a:one",
	"b:two" };

#define XQGSL_T4_ENTRIES 10
static char *t4_data[XQGSL_T4_ENTRIES] = {
	"a*z:one",
	"a.b*z:two",
	"a.b.c*z:three",
	"a.b.c.d*z:four",
	"a.b.c.d.e*z:five",
	"A*Z:six",
	"A.B*Z:seven",
	"A.B.C*Z:eight",
	"A.B.C.D*Z:nine",
	"A.B.C.D.E*Z:ten" };


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	database = (XrmDatabase)NULL;
	names = nl;
	classes = cl;
	list_return = sl; 	/* This is a XrmSearchList */
	list_length = XQGSL_LENGTH;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file Mdefcode.tmc.309668 */
static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmQGetSearchList-1.(B)");
	report_assertion("A call to XrmQGetSearchList returns a list of database");
	report_assertion("levels in list_return where a match for the specified names");
	report_assertion("and classes in the database could occur.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.309668 */

/* Including from file Mdefcode.tmc.309668 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmQGetSearchList-2.(B)");
	report_assertion("On a call to XrmQGetSearchList, the list returned in");
	report_assertion("list_return is in best-to-worst match order.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.309668 */

static void t003(){

int a;
Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmQGetSearchList-3.(A)");
	report_assertion("When list_length is greater than or equal to the number of");
	report_assertion("database levels where a match could occur, then a call to");
	report_assertion("XrmQGetSearchList returns True.");

	report_strategy("Create a test database with insufficient database levels to fill the list.");
	report_strategy("Call XrmQGetSearchList to obtain search list.");
	report_strategy("Verify that True was returned.");

	tpstartup();
	setargs();
/* Create a test database with insufficient database levels to fill the list. */
	for(a=0; a<XQGSL_T3_ENTRIES; a++) {
		XrmPutLineResource(&database, t3_data[a]);
	}

/* Call xname to obtain search list. */
	for(a=0; a<XQGSL_N_QUARK; a++) {
		nl[a]=(XrmName)0;
		cl[a]=(XrmClass)0;
	}
	XrmStringToNameList( "a", nl );
	XrmStringToClassList("A", cl );
	startcall(Dsp);
	if (isdeleted())
		return;
	ret = XrmQGetSearchList(database, names, classes, list_return, list_length);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that True was returned. */
	if (ret != True) {
		FAIL;
		report("%s did not return True when the list_length was",
			TestName);
		report("greater than or equal to the number of");
		report("possible match database levels.");
		report("Returned value: %s", boolname(ret));
	} else
		CHECK;

	CHECKPASS(1);

	XrmDestroyDatabase(database);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int a;
Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XrmQGetSearchList-4.(A)");
	report_assertion("When list_length is less than the number of database levels");
	report_assertion("where a match could occur, then a call to XrmQGetSearchList");
	report_assertion("returns False.");

	report_strategy("Create a test database with sufficient database levels to fill the list.");
	report_strategy("Call XrmQGetSearchList to obtain search list.");
	report_strategy("Verify that False was returned.");

	tpstartup();
	setargs();
/* Create a test database with sufficient database levels to fill the list. */
	for(a=0; a<XQGSL_T4_ENTRIES; a++) {
		XrmPutLineResource(&database, t4_data[a]);
	}

/* Call xname to obtain search list. */
	for(a=0; a<XQGSL_N_QUARK; a++) {
		nl[a]=(XrmName)0;
		cl[a]=(XrmClass)0;
	}
	XrmStringToNameList( "a.b.c.d.e.f.g.h.z", nl );
	XrmStringToClassList( "A.B.C.D.E.F.G.H.Z", cl );
	startcall(Dsp);
	if (isdeleted())
		return;
	ret = XrmQGetSearchList(database, names, classes, list_return, list_length);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that False was returned. */
	if (ret != False) {
		FAIL;
		report("%s did not return False when the list_length was",
			TestName);
		report("less than the number of possible match database levels.");
		report("Returned value: %s", boolname(ret));
	} else
		CHECK;

	CHECKPASS(1);

	XrmDestroyDatabase(database);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
