/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* Copyright (c) Open Text SA and/or Open Text ULC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XMapSubwindows(display, w)
 *   Display	*display;
 *   Window	w;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XMapSubwindows	1
char    *TestName = "XMapSubwindows";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XMapSubwindows function
 */
static Display	*display;
static Window	w;




#define	WINDOW_NOTIFY	001
#define	PARENT_NOTIFY	002

char	*T1[] = {
	".",
	"A . (10,10) 40x40 unmap",
	"B . (3,40) 40x40 unmap",
	"C . (20,22) 40x40 unmap",
	"D . (45,23) 40x40 unmap",
	"E . (30,30) 40x40 unmap",
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

XWindowAttributes	atts;
struct	buildtree	*btlist;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XMapSubwindows-1.(A)");
	report_assertion("A call to XMapSubwindows maps all subwindows of the");
	report_assertion("specified window in top to bottom stacking order.");

	report_strategy("Create unmapped subwindows of a window.");
	report_strategy("Map subwindows.");
	report_strategy("Verify map state of each subwindow is IsViewable.");
	report_strategy("Verify that windows show on screen.");

	tpstartup();
	setargs();
	w = defwin(display);
	btlist = buildtree(display, w, T1, NELEM(T1));

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 1; i < NELEM(T1); i++) {
		XGetWindowAttributes(display, btlist[i].wid, &atts);
		if (atts.map_state != IsViewable) {
			report("map state after map was %s, expecting %s",
				mapstatename(atts.map_state), mapstatename(IsViewable));
			report("  Window name was %s", btlist[i].name);
			FAIL;
		} else
			CHECK;
	}

	PIXCHECK(display, w);

	CHECKPASS(1+NELEM(T1)-1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XMapSubwindows-2.(-)");
	report_assertion("When a call to XMapSubwindows is made on a window that is");
	report_assertion("mapped and has no unmapped ancestors, then the subwindows");
	report_assertion("become viewable.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

Window	base;
struct	buildtree	*btp;
XWindowAttributes	atts;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XMapSubwindows-3.(A)");
	report_assertion("When a call to XMapSubwindows is made on a window that is");
	report_assertion("unmapped or has an unmapped ancester, then the subwindows do");
	report_assertion("not become viewable.");

	report_strategy("Create stack of unmapped windows.");
	report_strategy("Call XMapSubwindows on one of these window that has an unmapped ancestor.");
	report_strategy("Verify map state of each subwindow is IsUnviewable.");
	report_strategy("Verify that nothing becomes visible.");

	tpstartup();
	setargs();
	base = defwin(display);

	/* Create an unmapped test window */
	w = creunmapchild(display, base, (struct area *)0);
	btp = buildtree(display, w, T1, NELEM(T1));

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 1; i < NELEM(T1); i++) {
		XGetWindowAttributes(display, btp[i].wid, &atts);
		if (atts.map_state != IsUnviewable) {
			report("map state after map was %s, expecting %s",
				mapstatename(atts.map_state), mapstatename(IsUnviewable));
			FAIL;
		} else
			CHECK;
	}

	if (checkarea(display, base, (struct area *)0, W_BG, W_BG, CHECK_ALL))
		CHECK;
	else {
		report("Somthing became visible after mapping subwindows with unmapped ancestors");
		FAIL;
	}

	CHECKPASS(1+NELEM(T1)-1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Window	base;
XWindowAttributes	atts;
struct	buildtree	*bt;
XImage	*imp;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XMapSubwindows-4.(A)");
	report_assertion("When all the subwindows are already mapped, then a call to");
	report_assertion("XMapSubwindows has no effect.");

	report_strategy("Create subwindows.");
	report_strategy("Map subwindow.");
	report_strategy("Enable events.");
	report_strategy("Attempt to map subwindows again.");
	report_strategy("Verify that no difference occurred on screen.");
	report_strategy("Verify that map-state is still IsViewable.");
	report_strategy("Verify that no events are generated.");

	tpstartup();
	setargs();
	base = defwin(display);
	bt = buildtree(display, base, T1, NELEM(T1));

	w = base;
	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	imp = savimage(display, base);

	for (i = 0; i < NELEM(T1); i++)
		XSelectInput(display, bt[i].wid, ALLEVENTS);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 0; i < NELEM(T1); i++)
		XSelectInput(display, bt[i].wid, NoEventMask);

	if (compsavimage(display, base, imp))
		CHECK;
	else {
		report("Difference occurred on screen after re-mapping subwindows");
		FAIL;
	}

	for (i = 1; i < NELEM(T1); i++) {
		XGetWindowAttributes(display, bt[i].wid, &atts);
		if (atts.map_state != IsViewable) {
			report("map state after map was %s, expecting %s",
				mapstatename(atts.map_state), mapstatename(IsViewable));
			report("  window name %s", bt[i].name);
			FAIL;
		} else
			CHECK;
	}

	if (XPending(display) != 0) {
		report("Re-mapping subwindow produced event");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2+NELEM(T1)-1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Display	*client2;
XSetWindowAttributes	setatts;
XWindowAttributes	atts;
XMapRequestEvent	good;
XMapRequestEvent	*mrp;
struct	buildtree	*bt;
struct	buildtree	*btp;
XEvent	ev;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XMapSubwindows-5.(A)");
	report_assertion("When the override_redirect attribute of a subwindow is");
	report_assertion("False and some other client has selected");
	report_assertion("SubstructureRedirectMask on its parent window, then a");
	report_assertion("MapRequest event is generated, and the call to");
	report_assertion("XMapSubwindows does not map the subwindow.");

	report_strategy("Create base window.");
	report_strategy("Create unmapped subwindows on base window.");
	report_strategy("Set override-redirect attribute to False on each subwindow.");
	report_strategy("Create second client.");
	report_strategy("Select SubstructureRedirectMask for second client on base window.");
	report_strategy("Call XMapSubwindows on base window.");
	report_strategy("Verify that the MapRequest event is generated for each subwindow.");
	report_strategy("Verify that map-state is still IsUnmapped.");

	tpstartup();
	setargs();
	w = defwin(display);
	bt = buildtree(display, w, T1, NELEM(T1));

	for (i = 1; i < NELEM(T1); i++) {
		setatts.override_redirect = False;
		XChangeWindowAttributes(display, bt[i].wid, CWOverrideRedirect, &setatts);
	}

	if (isdeleted())
		return;

	client2 = opendisplay();
	XSelectInput(client2, w, SubstructureRedirectMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

	good.type = MapRequest;
	good.serial = 0;
	good.send_event = False;
	good.display = client2;
	good.parent = w;

	/* Should go through this loop NELEM(T1)-1 times */
	while (getevent(client2, &ev)) {

		mrp = (XMapRequestEvent*)&ev;
		btp = btwtobtp(bt, mrp->window);
		if (btp == NULL) {
			report("Event received for unknown window");
			FAIL;
			continue;
		}
		if (mrp->parent != w) {
			report("Map request received on a window other than the parent");
			FAIL;
		} else
			CHECK;

		btp->uflags++;
		good.window = btp->wid;

		if (checkevent((XEvent *)&good, &ev)) {
			report("Bad event on window '%s'", btp->name);
			FAIL;
		} else
			CHECK;
	}

	for (i = 1; i < NELEM(T1); i++) {

		if (bt[i].uflags == 0) {
			report("No map request for window '%s'", bt[i].name);
			FAIL;
		} else if (bt[i].uflags > 1) {
			report("Repeat map request for window '%s'", bt[i].name);
			FAIL;
		} else
			CHECK;

		XGetWindowAttributes(display, bt[i].wid, &atts);
		if (atts.map_state != IsUnmapped) {
			report("map state after map was %s, expecting %s",
				mapstatename(atts.map_state), mapstatename(IsUnmapped));
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(4*(NELEM(T1)-1));
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display	*client2;
Window	base;
XSetWindowAttributes	setatts;
XWindowAttributes	atts;
XMapEvent	good;
XMapEvent	*mp;
struct	buildtree	*bt;
struct	buildtree	*btp;
XEvent	ev;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XMapSubwindows-6.(A)");
	report_assertion("When the override-redirect attribute of a subwindow is True");
	report_assertion("and the subwindow is not already mapped, then the window is");
	report_assertion("mapped and a MapNotify event is generated.");

	report_strategy("Create base window.");
	report_strategy("Create unmapped subwindows on base window.");
	report_strategy("Set override-redirect attribute to True on each subwindow.");
	report_strategy("Select StructureNotify events on each subwindow.");
	report_strategy("Create second client.");
	report_strategy("Select SubstructureRedirect and SubstructureNotify for second client on base window.");
	report_strategy("Call XMapSubwindows on base window.");
	report_strategy("Verify that a MapNotify event is generated on parent for each subwindow.");
	report_strategy("Verify that a MapNotify event is generated on each subwindow.");
	report_strategy("Verify that the map_state of each subwindow is IsViewable.");

	tpstartup();
	setargs();
	base = defwin(display);
	bt = buildtree(display, base, T1, NELEM(T1));

	w = base;

	for (i = 1; i < NELEM(T1); i++) {
		setatts.override_redirect = True;
		XChangeWindowAttributes(display, bt[i].wid, CWOverrideRedirect, &setatts);
		/*
		 * Would normally select ALLEVENTS to test for spurious events.
		 * This cannot be done here, since we would possibly get valid 
		 * EnterNotify's etc.
		 */
		XSelectInput(display, bt[i].wid, StructureNotifyMask);
	}

	if (isdeleted())
		return;

	client2 = opendisplay();
	XSelectInput(client2, base,SubstructureRedirectMask|SubstructureNotifyMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

	/*
	 * Check for Map event on parent.
	 */
	good.type = MapNotify;
	good.serial = 0;
	good.send_event = False;
	good.display = client2;
	good.event = base;
	good.window = w;
	good.override_redirect = True;

	/* Should go through this loop NELEM(T1)-1 times */
	while (getevent(client2, &ev)) {

		mp = (XMapEvent*)&ev;
		btp = btwtobtp(bt, mp->window);
		if (btp == NULL) {
			report("Event received for unknown window");
			FAIL;
			continue;
		}
		if (mp->event != base) {
			report("Map request received on a window other than the parent");
			FAIL;
		} else
			CHECK;

		if (btp->uflags & PARENT_NOTIFY) {
			report("Repeat event received on parent for window '%s'", btp->name);
			FAIL;
		} else {
			btp->uflags |= PARENT_NOTIFY;
			CHECK;
		}

		good.window = btp->wid;

		if (checkevent((XEvent *)&good, &ev)) {
			report("Bad event on window '%s'", btp->name);
			FAIL;
		} else
			CHECK;
	}

	/*
	 * Now check for map notify on the window itself.
	 */
	good.display = display;

	/* Should go through this loop NELEM(T1)-1 times */
	while (getevent(display, &ev)) {

		mp = (XMapEvent*)&ev;
		btp = btwtobtp(bt, mp->window);
		if (btp == NULL) {
			report("Event received for unknown window");
			FAIL;
			continue;
		}

		if (btp->uflags & WINDOW_NOTIFY) {
			report("Repeat map notify event received on window '%s'", btp->name);
			FAIL;
		} else {
			btp->uflags |= WINDOW_NOTIFY;
			CHECK;
		}

		good.window = btp->wid;
		good.event = btp->wid;

		if (checkevent((XEvent *)&good, &ev)) {
			report("Bad event on window '%s'", btp->name);
			FAIL;
		} else
			CHECK;
	}

	for (i = 1; i < NELEM(T1); i++) {

		if (bt[i].uflags & WINDOW_NOTIFY)
			CHECK;
		else {
			report("No map notify received on window '%s'", bt[i].name);
			FAIL;
		}
		if (bt[i].uflags & PARENT_NOTIFY)
			CHECK;
		else {
			report("No map notify received on parent of window '%s'", bt[i].name);
			FAIL;
		}
		XGetWindowAttributes(display, w, &atts);
		if (atts.map_state != IsViewable) {
			report("map state after map was %s, expecting %s",
				mapstatename(atts.map_state), mapstatename(IsViewable));
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(8*(NELEM(T1)-1));
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Display	*client2;
Window	base;
XSetWindowAttributes	setatts;
XWindowAttributes	atts;
XMapEvent	good;
XMapEvent	*mp;
struct	buildtree	*bt;
struct	buildtree	*btp;
XEvent	ev;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XMapSubwindows-7.(A)");
	report_assertion("When no other client has selected SubstructureRedirectMask");
	report_assertion("on the parent window and the window is not already mapped,");
	report_assertion("then the window is mapped and a MapNotify event is");
	report_assertion("generated.");

	report_strategy("Create base window.");
	report_strategy("Create unmapped subwindows on base window.");
	report_strategy("Set override-redirect attribute to False on each subwindow.");
	report_strategy("Select StructureNotify events on each subwindow.");
	report_strategy("Create second client.");
	report_strategy("Select SubstructureNotify for second client on base window.");
	report_strategy("Call XMapSubwindows on base window.");
	report_strategy("Verify that a MapNotify event is generated on parent for each subwindow.");
	report_strategy("Verify that a MapNotify event is generated on each subwindow.");
	report_strategy("Verify that the map_state of each subwindow is IsViewable.");

	tpstartup();
	setargs();
	base = defwin(display);
	bt = buildtree(display, base, T1, NELEM(T1));

	w = base;

	for (i = 1; i < NELEM(T1); i++) {
		setatts.override_redirect = False;
		XChangeWindowAttributes(display, bt[i].wid, CWOverrideRedirect, &setatts);
		/*
		 * Would normally select ALLEVENTS to test for spurious events.
		 * This cannot be done here, since we would possibly get valid 
		 * EnterNotify's etc.
		 */
		XSelectInput(display, bt[i].wid, StructureNotifyMask);
	}

	if (isdeleted())
		return;

	client2 = opendisplay();
	XSelectInput(client2, base, SubstructureNotifyMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

	/*
	 * Check for Map event on parent.
	 */
	good.type = MapNotify;
	good.serial = 0;
	good.send_event = False;
	good.display = client2;
	good.event = base;
	good.window = w;
	good.override_redirect = False;

	/* Should go through this loop NELEM(T1)-1 times */
	while (getevent(client2, &ev)) {

		mp = (XMapEvent*)&ev;
		btp = btwtobtp(bt, mp->window);
		if (btp == NULL) {
			report("Event received for unknown window");
			FAIL;
			continue;
		}
		if (mp->event != base) {
			report("Map request received on a window other than the parent");
			FAIL;
		} else
			CHECK;

		if (btp->uflags & PARENT_NOTIFY) {
			report("Repeat event received on parent for window '%s'", btp->name);
			FAIL;
		} else {
			btp->uflags |= PARENT_NOTIFY;
			CHECK;
		}

		good.window = btp->wid;

		if (checkevent((XEvent *)&good, &ev)) {
			report("Bad event on window '%s'", btp->name);
			FAIL;
		} else
			CHECK;
	}

	/*
	 * Now check for map notify on the window itself.
	 */
	good.display = display;

	/* Should go through this loop NELEM(T1)-1 times */
	while (getevent(display, &ev)) {

		mp = (XMapEvent*)&ev;
		btp = btwtobtp(bt, mp->window);
		if (btp == NULL) {
			report("Event received for unknown window");
			FAIL;
			continue;
		}

		if (btp->uflags & WINDOW_NOTIFY) {
			report("Repeat map notify event received on window '%s'", btp->name);
			FAIL;
		} else {
			btp->uflags |= WINDOW_NOTIFY;
			CHECK;
		}

		good.window = btp->wid;
		good.event = btp->wid;

		if (checkevent((XEvent *)&good, &ev)) {
			report("Bad event on window '%s'", btp->name);
			FAIL;
		} else
			CHECK;
	}

	for (i = 1; i < NELEM(T1); i++) {

		if (bt[i].uflags & WINDOW_NOTIFY)
			CHECK;
		else {
			report("No map notify received on window '%s'", bt[i].name);
			FAIL;
		}
		if (bt[i].uflags & PARENT_NOTIFY)
			CHECK;
		else {
			report("No map notify received on parent of window '%s'", bt[i].name);
			FAIL;
		}
		XGetWindowAttributes(display, w, &atts);
		if (atts.map_state != IsViewable) {
			report("map state after map was %s, expecting %s",
				mapstatename(atts.map_state), mapstatename(IsViewable));
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(8*(NELEM(T1)-1));
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Window	base;
Window	win;
Window	win2;
Pixmap	tile;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XMapSubwindows-8.(A)");
	report_assertion("When one of the subwindows becomes viewable after a call to");
	report_assertion("XMapSubwindows and no earlier contents for it are");
	report_assertion("remembered, then the subwindow is tiled with its background.");

	report_strategy("Create subwindows.");
	report_strategy("Create tile.");
	report_strategy("Set background of each subwindow to tile.");
	report_strategy("Map subwindows.");
	report_strategy("Verify that subwindows are tiled.");
	report_strategy("Re-run with an inferior window.");

	tpstartup();
	setargs();
	base = defwin(display);

	win = creunmapchild(display, base, (struct area *)0);

	w = base;

	tile = maketile(display, win);
	XSetWindowBackgroundPixmap(display, win, tile);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (checktile(display, win, (struct area *)0, 0, 0, tile))
		CHECK;
	else {
		report("Window not tiled with its background correctly");
		FAIL;
	}

	/*
	 * Create an unmapped window and a mapped inferior of that window.
	 * When we map the window the inferior becomes viewable and so it
	 * should be tiled.
	 */
	base = defwin(display);
	win = creunmapchild(display, base, (struct area *)0);
	win2 = crechild(display, win, (struct area *)0);
	w = base;
	XSetWindowBackgroundPixmap(display, win2, tile);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (checktile(display, win2, (struct area *)0, 0, 0, tile))
		CHECK;
	else {
		report("Inferior window not tiled with its background correctly");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Window	base;
Window	ch1;
struct	buildtree	*bt;
struct	area	area;
XImage	*imp;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XMapSubwindows-9.(A)");
	report_assertion("When the background of the subwindow is undefined then the");
	report_assertion("existing screen contents from the parent or an inferior of");
	report_assertion("the parent are not altered, and zero or more Expose events");
	report_assertion("are generated.");

	report_strategy("Create window as parent.");
	report_strategy("Draw pattern on parent.");
	report_strategy("Create inferior window and draw pattern on that too.");
	report_strategy("Create unmapped subwindows that overlap inferior.");
	report_strategy("Set background pixmap to None on each subwindow.");
	report_strategy("Map subwindows.");
	report_strategy("Verify that screen contents have not been altered.");
	report_strategy("");
	report_strategy("Unmap subwindows.");
	report_strategy("For each subwindow");
	report_strategy("	Select for expose events.");
	report_strategy("	Call setforexpose() to draw into window (for if backing store in use)");
	report_strategy("Call XMapSubwindows to map subwindows.");
	report_strategy("For each window");
	report_strategy("	Verify that window was restored from backing store or received expose");
	report_strategy("	events that cover the window with exposecheck().");

	tpstartup();
	setargs();
	base = defwin(display);
	pattern(display, base);

	w = base;

	setarea(&area, 7, 7, 50, 50);
	ch1 = crechild(display, base, &area);
	pattern(display, ch1);

	/* Save original contents */
	imp = savimage(display, base);

	bt = buildtree(display, base, T1, NELEM(T1));

	for (i = 1; i < NELEM(T1); i++)
		XSetWindowBackgroundPixmap(display, bt[i].wid, None);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (compsavimage(display, base, imp))
		CHECK;
	else {
		report("Screen contents altered by mapping window with undefined background");
		FAIL;
	}

	/*
	 * Check expose events.  Unmap the windows and draw into them with
	 * setforexpose(), (this will normally have no effect unless backing
	 * store is active).  Map the window and check that either
	 *  - there are zero expose events and backing store has preserved the
	 *    contents.
	 *  - there are enough expose events to cover the window.
	 */
	XUnmapSubwindows(display, w);

	for (i = 1; i < NELEM(T1); i++) {
		XSelectInput(display, bt[i].wid, ExposureMask);
		setforexpose(display, bt[i].wid);
		/* because setforexpose() changes the background */
		XSetWindowBackgroundPixmap(display, bt[i].wid, None);
		/*
		 * Border width is set to zero, because otherwise the border potentialy
		 * confuses things.
		 */
		XSetWindowBorderWidth(display, bt[i].wid, None);
	}

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 1; i < NELEM(T1); i++)
		exposefill(display, bt[i].wid);
	for (i = 1; i < NELEM(T1); i++) {
		/* Compute unobscured region */
		int j;
		XRectangle rect;
		Region sub = makeregion();
		Region rgn = makeregion();
		rect.x = 0;
		rect.y = 0;
		rect.width = bt[i].width;
		rect.height = bt[i].height;
		XUnionRectWithRegion(&rect, rgn, rgn);
		for (j = i+1; j < NELEM(T1); j++) {
			XSubtractRegion(sub, sub, sub);
			rect.x = bt[j].x - bt[i].x;
			rect.y = bt[j].y - bt[i].y;
			rect.width = bt[j].width;
			rect.height = bt[j].height;
			XUnionRectWithRegion(&rect, sub, sub);
			XSubtractRegion(rgn, sub, rgn);
		}
		if (checkregion(display, bt[i].wid, rgn, W_FG, W_FG, CHECK_IN))
			CHECK;
		else {
			report("Neither Expose events or backing store processing");
			report("could correctly restore the window contents.");
			FAIL;
		}
	}

	CHECKPASS(1 + (NELEM(T1)-1));
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.364248 */
static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XMapSubwindows-10.(B)");
	report_assertion("When the background of the subwindow is undefined then the");
	report_assertion("existing screen contents not from the parent or an inferior");
	report_assertion("of the parent are undefined, and zero or more Expose events");
	report_assertion("are generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.364248 */

static void t011(){

XSetWindowAttributes	setatts;
XEvent	ev;
Window	base;
Window	ch;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XMapSubwindows-11.(D)");
	report_assertion("If backing store is supported: When backing store has been");
	report_assertion("maintained while a particular subwindow was unmapped, then");
	report_assertion("no Expose events are generated for that subwindow.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If backing store is supported");
	report_strategy("  Create base window.");
	report_strategy("  Create child of this window to unmap.");
	report_strategy("  Set backing store hint of child to Always.");
	report_strategy("  Write into child window.");
	report_strategy("  Unmap child window.");
	report_strategy("  Enable Expose events.");
	report_strategy("  Map child window by calling XMapSubwindows on base window.");
	report_strategy("  If child window contents are unaltered.");
	report_strategy("	Backing store was maintained.");
	report_strategy("	Verify that no Expose events were received.");
	report_strategy("  else");
	report_strategy("	Backing store was not maintained.");
	report_strategy("	Test result is UNTESTED.");
	report_strategy("else");
	report_strategy("  Test result is UNSUPPORTED.");

	tpstartup();
	setargs();
	if (DoesBackingStore(DefaultScreenOfDisplay(display)) != Always) {
		unsupported("Backing store not supported while unmapped");
		return;
	}

	base = defwin(display);
	ch = crechild(display, base, (struct area *)0);

	setatts.backing_store = Always;
	XChangeWindowAttributes(display, ch, CWBackingStore, &setatts);

	dset(display, ch, W_FG);
	XUnmapWindow(display, ch);
	XSelectInput(display, ch, ExposureMask);

	w = base;
	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, ch, NoEventMask);

	if (checkarea(display, ch, (struct area *)0, W_FG, W_FG, CHECK_ALL|CHECK_DIFFER)) {
		/*
		 * Backing store apeared to be active during the unmap.
		 */
		if (XCheckTypedWindowEvent(display, ch, Expose, &ev)) {
			/* Received Exposes */
			report("Expose received when backing store was active");
			FAIL;
		} else
			CHECK;
	} else {
		/*
		 * There is nothing wrong here, but it is possibly of interest.
		 */
		trace("NOTE: Server claims to support backing store but it was not active in the test");
		UNTESTED;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	n;
Window	base;
Window	ch;
Window	ch1;
XEvent	ev;
struct	area	area;
struct	area	charea;
XExposeEvent	*ep;
XSetWindowAttributes	setatts;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XMapSubwindows-12.(D)");
	report_assertion("If backing store is supported: When the server elects to");
	report_assertion("now maintain backing store for a subwindow, then an Expose");
	report_assertion("event for the whole window is generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If backing store is supported.");
	report_strategy("  Create small window.");
	report_strategy("  Ask for backing store when mapped.");
	report_strategy("  Create (and map) windows that would obscure the test window.");
	report_strategy("  Enable Expose events.");
	report_strategy("  Map window.");
	report_strategy("  If no Expose");
	report_strategy("	Untested - maybe got backing store always.");
	report_strategy("  Verify Expose event is for whole window.");
	report_strategy("else");
	report_strategy("  Untested.");

	tpstartup();
	setargs();
	if (DoesBackingStore(DefaultScreenOfDisplay(display)) == NotUseful) {
		unsupported("Backing store is not supported");
		return;
	}

	base = defwin(display);

	setarea(&area, 0, 0, 70, 70);
	ch = creunmapchild(display, base, &area);
	setatts.backing_store = WhenMapped;
	XChangeWindowAttributes(display, ch, CWBackingStore, &setatts);

	/* Create a child that will cover the test window */
	setarea(&charea, 0, 0, 20, 20);
	ch1 = crechild(display, base, &charea);

	XSelectInput(display, ch, ExposureMask);
	w = base;
	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSelectInput(display, ch, NoEventMask);

	n = XPending(display);
	if (n == 0) {
		trace("No Expose events on mapping window with backing-store WhenMapped");
		UNTESTED;
	} else
		CHECK;

	if (n == 1) {
		getevent(display, &ev);
		if (ev.type != Expose) {
			/* Only Expose events were enabled */
			delete("Unexpected event received (%s)", eventname(ev.type));
		} else {
			ep = (XExposeEvent*)&ev;
			if (ep->x == area.x && ep->y == area.y && ep->width == area.width && ep->height == area.height) {
				/* Full window Expose received */
				CHECK;
			} else {
				/*
				 * Since there was only one event and it does not cover
				 * the whole window then it is incorrect.
				 */
				report("Expose event covered wrong area");
				report("x=%d, y=%d, width=%d, height=%d", ep->x, ep->y, ep->width, ep->height);
				FAIL;
			}
		}
	} else {
		trace("Did not appear to get backing store");
		UNTESTED;
	}
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	n;
Window	base;
Window	ch;
Window	ch1;
struct	area	area;
struct	area	charea;
XSetWindowAttributes	setatts;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XMapSubwindows-13.(A)");
	report_assertion("When the server elects to not maintain backing store for a");
	report_assertion("subwindow, then Expose events are generated only for visible");
	report_assertion("regions.");

	report_strategy("Create small window.");
	report_strategy("Ask for no backing store.");
	report_strategy("Create (and map) windows that would obscure the test window.");
	report_strategy("Map window.");
	report_strategy("If Expose event is for whole window.");
	report_strategy("  Untested - maybe got backing store.");
	report_strategy("else");
	report_strategy("  Verify that only visible regions got Expose events.");

	tpstartup();
	setargs();
	base = defwin(display);

	setarea(&area, 0, 0, 70, 70);
	ch = creunmapchild(display, base, &area);
	setatts.backing_store = NotUseful;
	XChangeWindowAttributes(display, ch, CWBackingStore, &setatts);

	/* Create a child that will cover the test window */
	setarea(&charea, 0, 0, 20, 20);
	ch1 = crechild(display, base, &charea);

	XSelectInput(display, ch, ExposureMask);
	w = base;
	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSelectInput(display, ch, NoEventMask);

	n = XPending(display);
	if (n == 0) {
		trace("No Expose events on mapping window with backing-store NotUseful");
		UNTESTED;
	} else
		CHECK;

	if (n == 1) {
		trace("Appeared to get backing store when asked for NotUseful");
		UNTESTED;
	} else {
		/*
		 * Remove the child window.  Clear the test window, and then
		 * redraw it according to the Expose events.  This should leave
		 * the part that was not visible after the map in the background
		 * pixel.
		 */
		XUnmapWindow(display, ch1);
		dclear(display, ch);
		exposefill(display, ch);
		if (checkarea(display, ch, &charea, W_BG, W_FG, CHECK_ALL))
			CHECK;
		else {
			report("Some part of non-visible regions received Expose events");
			report("  or not all visible regions exposed");
			FAIL;
		}
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XMapSubwindows-14.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XMapSubwindows(display, w);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
