/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtRemoveCallbacks()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** Callback to be invoked
*/
void XtCBP_ProcOne(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(1, 1);
}
/*
** Callback not to be invoked
*/
void XtCBP_ProcTwo(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	sprintf(ebuf, "ERROR: Deleted callback XtCBP_ProcTwo invoked");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}
/*
** Callback not to be invoked
*/
void XtCBP_ProcThree(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	sprintf(ebuf, "ERROR: Deleted Callback XtCBP_ProcThree invoked");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}


#define T_XtRemoveCallbacks	1
char    *TestName = "XtRemoveCallbacks";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good;
int first = 0;
XtCallbackRec callbacks[] = {
	{ (XtCallbackProc)XtCBP_ProcOne, (XtPointer) NULL },
	{ (XtCallbackProc)XtCBP_ProcTwo, (XtPointer) NULL },
	{ (XtCallbackProc)XtCBP_ProcThree , (XtPointer) NULL },
	{ (XtCallbackProc) NULL, (XtPointer) NULL }
};
XtCallbackRec remove_list[] = {
	{ (XtCallbackProc)XtCBP_ProcTwo, (XtPointer) NULL },
	{ (XtCallbackProc)XtCBP_ProcThree, (XtPointer) NULL } ,
	{ (XtCallbackProc) NULL, (XtPointer) NULL }
};
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtRemoveCallbacks-1.(A)");
	report_assertion("A successful call to void XtRemoveCallbacks(w,");
	report_assertion("callback_name, callbacks) shall delete each entry from the");
	report_assertion("widget w's callback list specified by callback_name whose");
	report_assertion("callback procedure and client data matches a callback/client");
	report_assertion("data pair in the list specified by callbacks.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trmcalbks1", "XtRemoveCallbacks");
	tet_infoline("PREP: Create labelw_good widget Hello in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add a list of callback procedures to labelw_good widget");
	XtAddCallbacks(labelw_good,
			XtNdestroyCallback,
			&callbacks[0]
			);
	tet_infoline("PREP: Remove some of the callbacks form the list");
	XtRemoveCallbacks(labelw_good,
		 XtNdestroyCallback,
		 &remove_list[0]
		 );
	tet_infoline("PREP: labelw_good destroyed should not invoke the removed functions");
	XtDestroyWidget(labelw_good);
	tet_infoline("TEST: Only the callback not removed is invoked");
	first = avs_get_event(1);
	if (!first) {
		sprintf(ebuf, "ERROR: Function XtCBP_ProcOne was not invoked");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.361564 */
/* End of included file Mdefcode.tmc.361564 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
