/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   KeySym
 *   XtGetActionKeysym()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <AvsWid.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/* keysym sent */
KeySym keysym;

void AvsWidAction1(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	KeySym k;
	/* Indicate that action procedure was called */
	avs_set_event(1,1);
	/* Check XtGetActionKeysym returns keysym for event 
	 * KeyPress or KeyRelease
	*/
	tet_infoline("TEST: XtGetActionKeysym returns correct keysym");
	k = XtGetActionKeysym(event, NULL);
	if (k != keysym) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct keysym (got %ld, wanted %ld", k, keysym);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
#define AVS_WID_ACTION1 "AvsWidAction1"
XtActionsRec actions1[] = {
	{AVS_WID_ACTION1, AvsWidAction1},
};
void AvsWidAction2(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	KeySym k;
	/* Indicate that action procedure was called */
	avs_set_event(1,1);
	tet_infoline("TEST: XtGetActionKeysym returns correct keysym");
	k = XtGetActionKeysym(event, (Modifiers*)0);
	if (k != keysym) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct keysym (got %ld, wanted %ld", k, keysym);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
#define AVS_WID_ACTION2 "AvsWidAction2"
XtActionsRec actions2[] = {
	{AVS_WID_ACTION2, AvsWidAction2},
};
void AvsWidAction3(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	Modifiers modret;
	KeySym k;
	/* Indicate that action procedure was called */
	avs_set_event(1,1);
	/* Check XtGetActionKeysym returns keysym for event 
	 * KeyPress or KeyRelease
	*/
	tet_infoline("TEST: XtGetActionKeysym returns correct keysym");
	k = XtGetActionKeysym(event, &modret);
	if (k != keysym) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct keysym (got %ld, wanted %ld", k, keysym);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: XtGetActionKeysym returns correct modifiers");
	if (modret != ShiftMask) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct modifiers (got %ld, wanted %ld", modret, ShiftMask);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
#define AVS_WID_ACTION3 "AvsWidAction3"
XtActionsRec actions3[] = {
	{AVS_WID_ACTION3, AvsWidAction3},
};

/* keysym received */
KeySym k;

/* keysym sent */
KeySym keysymA;
KeySym keysymB;

XEvent eventA, eventB;

void AvsWidAction5(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	KeySym k;
	/* Indicate that action procedure was called */
	avs_set_event(1,1);
	tet_infoline("PREP: Call XtGetActionKeysym with event for 'B'");
	k = XtGetActionKeysym(&eventB, (Modifiers*)0);
	tet_infoline("TEST: XtGetActionKeysym returns correct keysym");
	if (k != keysymB) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct keysym (got %ld, wanted %ld", k, keysymB);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
#define AVS_WID_ACTION5 "AvsWidAction5"
XtActionsRec actions5[] = {
	{AVS_WID_ACTION5, AvsWidAction5},
};

void AvsWidAction6(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	KeySym k;
	/* Indicate that action procedure was called */
	avs_set_event(1,1);
	tet_infoline("PREP: Call XtGetActionKeysym with event for 'B'");
	k = XtGetActionKeysym(&eventB, (Modifiers*)0);
	tet_infoline("TEST: XtGetActionKeysym returns correct keysym");
	if (k != keysymB) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct keysym (got %ld, wanted %ld", k, keysymB);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
#define AVS_WID_ACTION6 "AvsWidAction6"
XtActionsRec actions6[] = {
	{AVS_WID_ACTION6, AvsWidAction6},
};
void AvsWidAction7(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	KeySym k;
	/* Indicate that action procedure was called */
	avs_set_event(1,1);
	/* Check XtGetActionKeysym returns keysym for event 
	 * KeyPress or KeyRelease
	*/
	tet_infoline("TEST: NoSymbol is returned");
	k = XtGetActionKeysym(event, (Modifiers*)0);
	if (k != NoSymbol) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return NoSymbol (got %ld, wanted %ld", k, NoSymbol);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
#define AVS_WID_ACTION7 "AvsWidAction7"
XtActionsRec actions7[] = {
	{AVS_WID_ACTION7, AvsWidAction7},
};


#define T_XtGetActionKeysym	1
char    *TestName = "XtGetActionKeysym";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget test_widget;
XEvent event;
KeyCode *keycodes_return;
Cardinal keycount_return;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetActionKeysym-1.(A)");
	report_assertion("When KeySym XtGetActionKeysym(event, modifiers_return) is");
	report_assertion("called from an action procedure, the event pointer event has");
	report_assertion("the same value as the event pointer passed to the action");
	report_assertion("procedure, and the event is a KeyPress it shall return the");
	report_assertion("KeySym that matches the final event specification in the");
	report_assertion("traslation table.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym1", "XtGetActionKeysym");
	tet_infoline("PREP: Create AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw", avsWidgetClass, boxw1, NULL);
	tet_infoline("PREP: Register action table with resource manager");
	XtAppAddActions(app_ctext, actions1, XtNumber(actions1) );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'A'");
	keysym = XStringToKeysym("A");
	tet_infoline("PREP: Get keycode list for keysym");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysym, &keycodes_return, &keycount_return);
	tet_infoline("PREP: Invoke action procedure");
	event.type = KeyPress;
	event.xkey.type = KeyPress;
	event.xkey.keycode = *keycodes_return;
	event.xkey.state = ShiftMask;
	event.xkey.display = display;
	XtCallActionProc(test_widget, AVS_WID_ACTION1, &event,
			(String *)NULL, (Cardinal)0);
	tet_infoline("TEST: Procedure was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "action procedure invoked status");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

static void t002(){

Widget test_widget;
XEvent event;
KeyCode *keycodes_return;
Cardinal keycount_return;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetActionKeysym-2.(A)");
	report_assertion("When KeySym XtGetActionKeysym(event, modifiers_return) is");
	report_assertion("called from an action procedure, the event pointer event has");
	report_assertion("the same value as the event pointer passed to the action");
	report_assertion("procedure, and the event is a KeyRelease it shall return the");
	report_assertion("KeySym that matches the final event specification in the");
	report_assertion("traslation table.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym2", "XtGetActionKeysym");
	tet_infoline("PREP: Create AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw",
			 avsWidgetClass, boxw1, NULL);
	tet_infoline("PREP: Register action table with resource manager");
	XtAppAddActions(app_ctext, actions2, XtNumber(actions2));
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'A'");
	keysym = XStringToKeysym("A");
	tet_infoline("PREP: Get keycode list for keysym");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysym,
			&keycodes_return, &keycount_return);
	tet_infoline("PREP: Invoke action procedure");
	event.type = KeyRelease;
	event.xkey.type = KeyRelease;
	event.xkey.keycode = *keycodes_return;
	event.xkey.state = ShiftMask;
	event.xkey.display = display;
	XtCallActionProc(test_widget, AVS_WID_ACTION2, &event,
			 (String *)NULL, (Cardinal)0);
	tet_infoline("TEST: Action Procedure was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "action procedure invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

static void t003(){

Widget test_widget;
XEvent event;
KeyCode *keycodes_return;
Cardinal keycount_return;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGetActionKeysym-3.(A)");
	report_assertion("When KeySym XtGetActionKeysym(event, modifiers_return) is");
	report_assertion("called from an action procedure, the event pointer event has");
	report_assertion("the same value as the event pointer passed to the action");
	report_assertion("procedure, the event is a KeyRelease or a KeyPress event,");
	report_assertion("and modifiers_return is non-NULL it shall return the");
	report_assertion("modifiers used to generate the KeySym in modifiers_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym3", "XtGetActionKeysym");
	tet_infoline("PREP: Create AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw",
			 avsWidgetClass, boxw1, NULL);
	tet_infoline("PREP: Register action table with resource manager");
	XtAppAddActions(app_ctext, actions3, XtNumber(actions3));
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'A'");
	keysym = XStringToKeysym("A");
	tet_infoline("PREP: Get keycode list for keysym");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysym,
			&keycodes_return, &keycount_return);
	tet_infoline("PREP: Invoke action procedure");
	event.type = KeyRelease;
	event.xkey.type = KeyRelease;
	event.xkey.keycode = *keycodes_return;
	event.xkey.state = ShiftMask;
	event.xkey.display = display;
	XtCallActionProc(test_widget, AVS_WID_ACTION3, &event,
			 (String *)NULL, (Cardinal)0);
	tet_infoline("TEST: Action Procedure was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "action procedure invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

static void t004(){

Widget test_widget;
XEvent event;
KeyCode *keycodes_return;
Cardinal keycount_return;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtGetActionKeysym-4.(A)");
	report_assertion("When KeySym XtGetActionKeysym(event, modifiers_return) is");
	report_assertion("not called from an action procedure and the event is a");
	report_assertion("KeyPress it shall invoke the currently registered");
	report_assertion("KeyCode-to-KeySym translator for the KeyCode specified by");
	report_assertion("the event pointer event and return the associated KeySym and");
	report_assertion("a constant that indicates the subset of all modifiers");
	report_assertion("examined by the translator in modifiers_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym4", "XtGetActionKeysym");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'A'");
	keysym = XStringToKeysym("A");
	tet_infoline("PREP: Get keycode list for keysym");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysym,
			&keycodes_return, &keycount_return);
	tet_infoline("PREP: Call XtGetActionKeysym");
	event.type = KeyPress;
	event.xkey.type = KeyPress;
	event.xkey.keycode = *keycodes_return;
	event.xkey.state = ShiftMask;
	event.xkey.display = display;
	tet_infoline("TEST: XtGetActionKeysym returns correct keysym");
	k = XtGetActionKeysym(&event, (Modifiers*)NULL);
	if (k != keysym) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct keysym (got %ld, wanted %ld", k, keysym);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

static void t005(){

Widget test_widget;
XEvent event;
KeyCode *keycodes_return;
Cardinal keycount_return;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtGetActionKeysym-5.(A)");
	report_assertion("When KeySym XtGetActionKeysym(event, modifiers_return) is");
	report_assertion("not called from an action procedure and the event is a");
	report_assertion("KeyRelease it shall invoke the currently registered");
	report_assertion("KeyCode-to-KeySym translator for the KeyCode specified by");
	report_assertion("the event pointer event and return the associated KeySym and");
	report_assertion("a constant that indicates the subset of all modifiers");
	report_assertion("examined by the translator in modifiers_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym4", "XtGetActionKeysym");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'A'");
	keysym = XStringToKeysym("A");
	tet_infoline("PREP: Get keycode list for keysym");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysym,
			&keycodes_return, &keycount_return);
	tet_infoline("PREP: Call XtGetActionKeysym");
	event.type = KeyRelease;
	event.xkey.type = KeyRelease;
	event.xkey.keycode = *keycodes_return;
	event.xkey.state = ShiftMask;
	event.xkey.display = display;
	tet_infoline("TEST: XtGetActionKeysym returns correct keysym");
	k = XtGetActionKeysym(&event, (Modifiers*)NULL);
	if (k != keysym) {
		sprintf(ebuf, "ERROR: XtGetActionKeysym did not return correct keysym (got %ld, wanted %ld", k, keysym);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

static void t006(){

Widget test_widget;
KeyCode *keycodes_returnA;
KeyCode *keycodes_returnB;
Cardinal keycount_returnA;
Cardinal keycount_returnB;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtGetActionKeysym-6.(A)");
	report_assertion("When KeySym XtGetActionKeysym(event, modifiers_return) is");
	report_assertion("called from an action procedure, the event pointed to by");
	report_assertion("event does not have the same value as the event passed to");
	report_assertion("the action procedure, and the event is a KeyPress it shall");
	report_assertion("invoke the currently registered KeyCode-to-KeySym translator");
	report_assertion("for the KeyCode specified by the event pointer event and");
	report_assertion("return the associated KeySym and a constant that indicates");
	report_assertion("the subset of all modifiers examined by the translator in");
	report_assertion("modifiers_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym5", "XtGetActionKeysym");
	tet_infoline("PREP: Create AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw",
			 avsWidgetClass, boxw1, NULL);
	tet_infoline("PREP: Register action table with resource manager");
	XtAppAddActions(app_ctext, actions5, XtNumber(actions5) );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysyms for alphabet 'A' and 'B'");
	keysymA = XStringToKeysym("A");
	keysymB = XStringToKeysym("B");
	tet_infoline("PREP: Get keycode lists for keysyms");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysymA, &keycodes_returnA, &keycount_returnA);
	XtKeysymToKeycodeList(display, keysymB, &keycodes_returnB, &keycount_returnB);
	tet_infoline("PREP: Invoke action procedure with event for 'A'");
	eventA.type = KeyPress;
	eventB.type = KeyPress;
	eventA.xkey.type = KeyPress;
	eventB.xkey.type = KeyPress;
	eventA.xkey.keycode = *keycodes_returnA;
	eventB.xkey.keycode = *keycodes_returnB;
	eventA.xkey.state = ShiftMask;
	eventB.xkey.state = ShiftMask;
	eventA.xkey.display = display;
	eventB.xkey.display = display;
	XtCallActionProc(test_widget, AVS_WID_ACTION5, &eventA,
			 (String *)NULL, (Cardinal)0);
	tet_infoline("TEST: Action Procedure was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "action procedure invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

static void t007(){

Widget test_widget;
KeyCode *keycodes_returnA;
KeyCode *keycodes_returnB;
Cardinal keycount_returnA;
Cardinal keycount_returnB;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtGetActionKeysym-7.(A)");
	report_assertion("When KeySym XtGetActionKeysym(event, modifiers_return) is");
	report_assertion("called from an action procedure, the event pointed to by");
	report_assertion("event does not have the same value as the event passed to");
	report_assertion("the action procedure, and the event is a KeyRelease it shall");
	report_assertion("invoke the currently registered KeyCode-to-KeySym translator");
	report_assertion("for the KeyCode specified by the event pointer event and");
	report_assertion("return the associated KeySym and a constant that indicates");
	report_assertion("the subset of all modifiers examined by the translator in");
	report_assertion("modifiers_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym6", "XtGetActionKeysym");
	tet_infoline("PREP: Create AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw",
			 avsWidgetClass, boxw1, NULL);
	tet_infoline("PREP: Register action table with resource manager");
	XtAppAddActions(app_ctext, actions6, XtNumber(actions6) );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysyms for alphabet 'A' and 'B'");
	keysymA = XStringToKeysym("A");
	keysymB = XStringToKeysym("B");
	tet_infoline("PREP: Get keycode lists for keysyms");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysymA, &keycodes_returnA, &keycount_returnA);
	XtKeysymToKeycodeList(display, keysymB, &keycodes_returnB, &keycount_returnB);
	tet_infoline("PREP: Invoke action procedure with event for 'A'");
	eventA.type = KeyRelease;
	eventB.type = KeyRelease;
	eventA.xkey.type = KeyRelease;
	eventB.xkey.type = KeyRelease;
	eventA.xkey.keycode = *keycodes_returnA;
	eventB.xkey.keycode = *keycodes_returnB;
	eventA.xkey.state = ShiftMask;
	eventB.xkey.state = ShiftMask;
	eventA.xkey.display = display;
	eventB.xkey.display = display;
	XtCallActionProc(test_widget, AVS_WID_ACTION6, &eventA,
			 (String *)NULL, (Cardinal)0);
	tet_infoline("TEST: Action Procedure was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "action procedure invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

static void t008(){

XEvent event;
Widget test_widget;
KeySym keysym, keysym_good;
KeyCode *keycodes_return, code;
Cardinal keycount_return;
Display *display;
int invoked = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtGetActionKeysym-8.(A)");
	report_assertion("When the event pointed to by event is neither a KeyPress");
	report_assertion("nor a KeyRelease event a call to KeySym");
	report_assertion("XtGetActionKeysym(event, modifiers_return) shall return");
	report_assertion("NoSymbol and ignore modifiers_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtacksym7", "XtGetActionKeysym");
	tet_infoline("PREP: Create AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw",
			 avsWidgetClass, boxw1, NULL);
	tet_infoline("PREP: Register action table with resource manager");
	XtAppAddActions(app_ctext, actions7, XtNumber(actions7) );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'a'");
	keysym = XStringToKeysym("a");
	tet_infoline("PREP: Get keycode list for keysym");
	display = XtDisplay(topLevel);
	XtKeysymToKeycodeList(display, keysym,
			&keycodes_return, &keycount_return);
	tet_infoline("PREP: Invoke action procedure");
	event.type = ButtonPress;
	event.xbutton.state = ShiftMask;
	event.xbutton.display = display;
	XtCallActionProc(test_widget, AVS_WID_ACTION7, &event,
			(String *)NULL, (Cardinal)0);
	tet_infoline("TEST: Action Procedure was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "action procedure invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.359464 */
/* End of included file Mdefcode.tmc.359464 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
