/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAddExposureToRegion()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern char *event_names[];

/*
** Procedure XtEVT1_Proc
*/
void XtEVT1_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
Region test_region;

	if ( event->type == Expose ) {
		tet_infoline("PREP: Create a region");
		test_region = XCreateRegion();
		tet_infoline("TEST: Add exposure to region");
		XtAddExposureToRegion((XEvent *)&event, test_region);
		/*unclear how verify this worked with opaque type*/
		avs_set_event(1,avs_get_event(1)+1);
		exit(0);
	}
	else {
		sprintf(ebuf, "ERROR: Expected Expose event Received %s", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
void XtEVT_Proc1(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
Region test_region;

	if (event->type == GraphicsExpose ) {
		tet_infoline("PREP: Create a region");
		test_region = XCreateRegion();
		tet_infoline("TEST: Add exposure to region");
		XtAddExposureToRegion((XEvent *)&event, test_region);
		/*unclear how verify this worked with opaque type*/
		avs_set_event(2,avs_get_event(2)+1);
		exit(0);
	}
	else {
		sprintf(ebuf, "ERROR: Expected GraphicsExpose event Received %s", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*
** Procedure XtEVT2_Proc
*/
void XtEVT2_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
Region test_region;

	if ( event->type == KeyPress ) {
		tet_infoline("PREP: Create a region");
		test_region = XCreateRegion();
		tet_infoline("PREP: Add exposure to region using KeyPress event");
		XtAddExposureToRegion((XEvent *)&event, test_region);
		avs_set_event(1,avs_get_event(1)+1);
		exit(0);
	}
	else {
		sprintf(ebuf, "ERROR: Expected KeyPress event Received %s", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*
** Installed Warning handler
*/
void XtEMH2_Proc(str, str2, str3, str4, str5, car)
String str, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(3,1);
	exit(0);
}
/*
** Installed Error handler
*/
void XtEMH_Proc(str, str2, str3, str4, str5, car)
String str, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(2,1);
	exit(0);
}


#define T_XtAddExposureToRegion	1
char    *TestName = "XtAddExposureToRegion";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAddExposureToRegion-1.(A)");
	report_assertion("A call to void XtAddExposureToRegion(event, region) when");
	report_assertion("event specifies an Expose event shall compute the union of");
	report_assertion("the rectangle defined by the specified event and the region");
	report_assertion("region and store the result in region.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadexptor1", "XtAddExposureToRegion");
	tet_infoline("PREP: XtEVT1_Proc to handle events to labelw");
	XtAddEventHandler(labelw,
		 ExposureMask,
		 False,
		 XtEVT1_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	send_event(labelw, Expose, ExposureMask, TRUE);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Event handler was called");
	status = avs_get_event(1);
	check_dec(1, status, "XtEVT1_Proc invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.356008 */
/* End of included file Mdefcode.tmc.356008 */

static void t002(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAddExposureToRegion-2.(A)");
	report_assertion("A call to void XtAddExposureToRegion(event, region) when");
	report_assertion("event specifies a GraphicsExpose event shall compute the");
	report_assertion("union of the rectangle defined by the specified event and");
	report_assertion("the region region and store the result in region.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadexptor1", "XtAddExposureToRegion");
	tet_infoline("PREP: XtEVT1_Proc to handle events to labelw");
	XtAddEventHandler(labelw,
		 0,
		 True,
		 XtEVT_Proc1,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	send_event(labelw, GraphicsExpose, ExposureMask, TRUE);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Event handler was called");
	status = avs_get_event(2);
	check_dec(1, status, "handler invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.356008 */
/* End of included file Mdefcode.tmc.356008 */

static void t003(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAddExposureToRegion-3.(A)");
	report_assertion("When the event specified by event is neither an Expose nor");
	report_assertion("a GraphicsExpose event a call to void");
	report_assertion("XtAddExposureToRegion(event, region) shall not issue an");
	report_assertion("error and not modify region.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadexptor2", "XtAddExposureToRegion");
	tet_infoline("PREP: Register error and warning handler");
	XtAppSetWarningMsgHandler(app_ctext, XtEMH2_Proc);
	XtAppSetErrorMsgHandler(app_ctext, XtEMH_Proc);
	tet_infoline("PREP: XtEVT2_Proc to handle key press events to labelw");
	XtAddEventHandler(labelw,
		 KeyPressMask,
		 False,
		 XtEVT2_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyPress event");
	send_event(labelw, KeyPress, KeyPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: No error or warning was generated");
	status = avs_get_event(2);
	check_dec(0, status, "Error message count");
	status = avs_get_event(3);
	check_dec(0, status, "Warning message count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.356008 */
/* End of included file Mdefcode.tmc.356008 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
