/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtNameToWidget()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtNameToWidget	1
char    *TestName = "XtNameToWidget";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good, widget_good;
char string[10];
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtNameToWidget-1.(A)");
	report_assertion("When names specifies a simple object name a successful call");
	report_assertion("to Widget XtNameToWidget(reference, names) shall return a");
	report_assertion("pointer to the immediate descendant of the widget reference");
	report_assertion("that matches the specified name.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tnmtowidg1", "XtNameToWidget");
	tet_infoline("PREP: Create test label widget name `Hello' in rowcol widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Unqualified child name returns direct descendent");
	if ((widget_good = (Widget)XtNameToWidget(rowcolw, "Hello")) == NULL) {
			sprintf(ebuf, "ERROR: Expected a Widget, got NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	strcpy(string, XtName(widget_good) );
	check_str("Hello", string, "Widget name");
	tet_infoline("TEST: Unqualified child name returns only direct descendent");
	if ((widget_good = (Widget)XtNameToWidget(boxw1, "Hello")) != NULL) {
		sprintf(ebuf, "ERROR: Expected NULL, got a Widget");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361800 */
/* End of included file Mdefcode.tmc.361800 */

static void t002(){

Widget labelw_good, widget_good;
char string[10];
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtNameToWidget-2.(A)");
	report_assertion("When names specifies a series of simple object name");
	report_assertion("components separated by periods and asterisks a successful");
	report_assertion("call to Widget XtNameToWidget(reference, names) shall search");
	report_assertion("the subtree rooted at the widget reference in a");
	report_assertion("breadth-first order for the first object that matches the");
	report_assertion("specified name, where each component of names matches");
	report_assertion("exactly the corresponding component of the name obtained by");
	report_assertion("qualifying the object name and names of all its ancestors up");
	report_assertion("to but not including the widget reference and asterisk");
	report_assertion("matches any series of components, including none, and return");
	report_assertion("a pointer to it.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tnmtowidg3", "XtNameToWidget");
	tet_infoline("PREP: Create test label widget name `Hello' in rowcol widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Name with period returns correct descendent");
	if ((widget_good = (Widget)XtNameToWidget(boxw1, "rowcolw.Hello")) == NULL) {
		sprintf(ebuf, "ERROR: Expected a Widget, got NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	strcpy(string, XtName(widget_good) );
	check_str("Hello", string, "Widget name");
	tet_infoline("TEST: Name with asterisk returns correct descendent");
	if ((widget_good = (Widget)XtNameToWidget(boxw1, "*Hello")) == NULL) {
		sprintf(ebuf, "ERROR: Expected a Widget, got NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	strcpy(string, XtName(widget_good) );
	check_str("Hello", string, "Widget name");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361800 */
/* End of included file Mdefcode.tmc.361800 */

static void t003(){

Widget widget_bad;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtNameToWidget-3.(A)");
	report_assertion("A call to Widget XtNameToWidget(reference, names) when no");
	report_assertion("object matching names exists in the subtree rooted at the");
	report_assertion("widget reference shall return NULL.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tnmtowidg2", "XtNameToWidget");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Non-existant widget shall return NULL");
	if ((widget_bad = (Widget)XtNameToWidget(rowcolw, "Help")) != NULL ) {
		sprintf(ebuf, "ERROR: Expected NULL returned widget instance");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361800 */
/* End of included file Mdefcode.tmc.361800 */

/* Including from file Mdefcode.tmc.361800 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtNameToWidget-4.(B)");
	report_assertion("The object returned by a call to Widget");
	report_assertion("XtNameToWidget(reference, names) when multiple objects that");
	report_assertion("match names exist at the same level in the subtree rooted at");
	report_assertion("reference.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.361800 */

static void t005(){

Widget labelw_good, widget_good;
char string[10];
pid_t pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtNameToWidget-5.(A)");
	report_assertion("A call to Widget XtNameToWidget(reference, names) shall");
	report_assertion("interpret consecutive asterisks in names as a single");
	report_assertion("asterisk.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tnmtowidg6", "XtNameToWidget");
	tet_infoline("PREP: Create test label widget name `Hello' in rowcol widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Multiple asterisks same as one");
	if ((widget_good = (Widget)XtNameToWidget(boxw1, "*****Hello")) == NULL) {
		sprintf(ebuf, "ERROR: Expected a Widget, got NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	strcpy(string, XtName(widget_good) );
	check_str("Hello", string, "Widget name");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361800 */
/* End of included file Mdefcode.tmc.361800 */

static void t006(){

Widget labelw_good, widget_good;
char string[10];
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtNameToWidget-6.(A)");
	report_assertion("A call to Widget XtNameToWidget(reference, names) shall");
	report_assertion("interpret consecutive periods that include at least one");
	report_assertion("asterisk in names as a single asterisk.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tnmtowidg6", "XtNameToWidget");
	tet_infoline("PREP: Create test label widget name `Hello' in rowcol widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Consecutive periods and asterisks same as one asterisk");
	if ((widget_good = (Widget)XtNameToWidget(boxw1, ".*...Hello")) == NULL) {
		sprintf(ebuf, "ERROR: Expected a Widget, got NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	strcpy(string, XtName(widget_good) );
	check_str("Hello", string, "Widget name");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361800 */
/* End of included file Mdefcode.tmc.361800 */

static void t007(){

Widget labelw_good, widget_good;
char string[10];
pid_t pid2;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtNameToWidget-7.(A)");
	report_assertion("A call to Widget XtNameToWidget(reference, names) shall");
	report_assertion("interpret consecutive periods in names as a single period.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tnmtowidg5", "XtNameToWidget");
	tet_infoline("PREP: Create test label widget name `Hello' in rowcol widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Multiple periods same as one");
	if ((widget_good = (Widget)XtNameToWidget(boxw1, "rowcolw....Hello")) == NULL) {
		sprintf(ebuf, "ERROR: Expected a Widget, got NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	strcpy(string, XtName(widget_good) );
	check_str("Hello", string, "Widget name");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361800 */
/* End of included file Mdefcode.tmc.361800 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
