/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtDestroyApplicationContext()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** Procedure XtEVT_Proc
*/
void XtEVT_Proc(w, client_data, event, flag)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *flag;
{
    if (event->type == ButtonPress) {
	XtDestroyApplicationContext((XtAppContext)client_data);
        avs_set_event(1,1);
        exit(0);
    }
}


#define T_XtDestroyApplicationContext	1
char    *TestName = "XtDestroyApplicationContext";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDestroyApplicationContext-1.(A)");
	report_assertion("A call to void XtDestroyApplicationContext(app_context)");
	report_assertion("shall destroy the application context app_context and close");
	report_assertion("all the display connections associated with it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tdstryappl1", "XtDestroyApplicationContext");
	tet_infoline("TEST: Destroy an application context");
	XtDestroyApplicationContext(app_ctext);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364632 */
/* End of included file Mdefcode.tmc.364632 */

static void t002(){

Widget labelw_msg;
char *msg = "Test widget";
pid_t pid2;
int invoked = 0;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDestroyApplicationContext-2.(A)");
	report_assertion("A call to void XtDestroyApplicationContext(app_context)");
	report_assertion("when called from within an event dispatch shall not destroy");
	report_assertion("the application context until the dispatch is complete.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tdstryappl2", "XtDestroyApplicationContext");
	tet_infoline("PREP: Create labelw_msg widget in boxw1");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register procedure to handle ButtonPress events to");
	tet_infoline("PREP: labelw_msg widget");
	XtAddEventHandler(labelw_msg,
		  ButtonPressMask,
		  False,
		  XtEVT_Proc,
		  (XtPointer)app_ctext
		  );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Simulate ButtonPress on widget labelw_msg");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, FALSE);
	tet_infoline("TEST: Loop for events");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Context terminated on event handler completion");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "Event handler invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364632 */
/* End of included file Mdefcode.tmc.364632 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
