/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtSetArg()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

extern char * event_names[];

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtSetArg	1
char    *TestName = "XtSetArg";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display;
Arg testarg;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSetArg-1.(A)");
	report_assertion("A call to void XtSetArg(arg, resource_name, value) when the");
	report_assertion("size of value is less than or equal to the size of XtArgVal");
	report_assertion("shall set the arg.name member of the structure arg to");
	report_assertion("resource_name and the arg.value member to value.");
	FORK(pid);
	initconfig();

	tet_infoline("TEST: XtSetArg sets arg members correctly");
	XtSetArg(testarg, "ApTest", 1);
	if (strcmp(testarg.name, "ApTest") != 0) {
		sprintf(ebuf, "ERROR: expected arg name = \"ApTest\", was \"%s\"", testarg.name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (testarg.value  != 1) {
		sprintf(ebuf, "ERROR: expected value = 1, was %d", testarg.value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.365200 */
/* End of included file Mdefcode.tmc.365200 */

static void t002(){

Display *display;
Arg testarg;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSetArg-2.(A)");
	report_assertion("A call to void XtSetArg(arg, resource_name, value) when the");
	report_assertion("size of value is greater than the size of XtArgVal shall");
	report_assertion("store a pointer to value in the arg.value member of the");
	report_assertion("structure arg.");
	FORK(pid);
	initconfig();

	tet_infoline("TEST: XtSetArg sets arg members correctly");
	XtSetArg(testarg, "ApTest2", "A string");
	if (strcmp(testarg.name, "ApTest2") != 0) {
		sprintf(ebuf, "ERROR: expected arg name = \"ApTest2\", was \"%s\"", testarg.name);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (strncmp((char *)testarg.value, "A string", strlen("A string"))  != 0) {
		tet_infoline("ERROR: expected value to point to string");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.365200 */
/* End of included file Mdefcode.tmc.365200 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
