/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtUnmanageChild()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xaw/Label.h>
#include <AvsComp2.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtEMH2_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(2,1);
}
/*
** Installed Error handler
*/
void XtEMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(1,1);
}


#define T_XtUnmanageChild	1
char    *TestName = "XtUnmanageChild";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean status;
Widget labelw_good;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtUnmanageChild-1.(A)");
	report_assertion("A successful call to void XtUnmanageChild(w) when the");
	report_assertion("widget w is managed by its parent shall make the widget to");
	report_assertion("be unmanaged.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tunmgchld1", "XtUnmanageChild");
	tet_infoline("PREP: Create a managed widget labelw_good");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Unmanage child");
	XtUnmanageChild(labelw_good);
	tet_infoline("TEST: labelw_good widget is managed shall return False");
	status = XtIsManaged(labelw_good);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363696 */
/* End of included file Mdefcode.tmc.363696 */

/* Including from file Mdefcode.tmc.363696 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtUnmanageChild-2.(B)");
	report_assertion("On a successful call to void XtUnmanageChild(w) when the");
	report_assertion("widget w is realized and has become unmanaged the window of");
	report_assertion("the widget shall be unmapped.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.363696 */

static void t003(){

int status;
Widget test2_widget, test_widget;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtUnmanageChild-3.(A)");
	report_assertion("When the parent is realized and the widget w has become");
	report_assertion("unmanaged a successful call to void XtUnmanageChild(w) shall");
	report_assertion("invoke the change_managed routine of the parent.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tunmgchdn2", "XtUnmanageChild");
	tet_infoline("PREP: Create a test parent");
	test_widget = XtVaCreateManagedWidget("avsw2", avsComp2WidgetClass, boxw1, NULL);
	tet_infoline("PREP: Create a managed child widget");
	test2_widget = (Widget) CreateLabelWidget("Hello", test_widget);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Unmanage child");
	XtUnmanageChild(test2_widget);
	tet_infoline("TEST: Change managed procedure invoked");
	/*this is a test widget class with a special change managed routine*/
	/*that sets this when its called - see AvsComp2.h in the avsxt library*/
	status = avs_get_event(5);
	if (status != 1 ) {
		sprintf(ebuf, "ERROR: Change_managed routine not invoked");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363696 */
/* End of included file Mdefcode.tmc.363696 */

static void t004(){

Widget menuw;
Widget labelw_good;
Widget pushb_good;
Boolean value_good;
Widget labelw1, labelw2;
Widget children[2];
Widget rowcolw_good;
int invoked;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtUnmanageChild-4.(A)");
	report_assertion("When the parent of the widget w is not a subclass of");
	report_assertion("compositeWidgetClass a successful call to void");
	report_assertion("XtUnmanageChild(w) shall issue an invalidParent error.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tunmgchdn4", "XtUnmanageChild");
	tet_infoline("PREP: Create child of non-Composite widget");
	labelw_good = XtVaCreateWidget(
			"ApTest",		 /* arbitrary widget name */
			labelWidgetClass,	/* widget class */
			labelw,			/* parent widget */
			(char *)NULL		/* terminate list */
			);
	tet_infoline("PREP: Register error handler");
	XtAppSetErrorMsgHandler(app_ctext, XtEMH_Proc);
	XtAppSetWarningMsgHandler(app_ctext, XtEMH2_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Unmanage child of non-composite widget");
	XtUnmanageChild(labelw_good);
	tet_infoline("TEST: Error handler was invoked");
	invoked = avs_get_event(1);
	if (!invoked) {
		sprintf(ebuf, "ERROR: Error handler was not invoked");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	invoked = avs_get_event(2);
	if (invoked) {
		sprintf(ebuf, "ERROR: Warning message was generated instead of error message");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363696 */
/* End of included file Mdefcode.tmc.363696 */

/* Including from file Mdefcode.tmc.363696 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtUnmanageChild-5.(B)");
	report_assertion("A successful call to void XtUnmanageChild(w) when the");
	report_assertion("parent of the widget w is being destroyed shall return");
	report_assertion("immediately.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.363696 */

/* Including from file Mdefcode.tmc.363696 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtUnmanageChild-6.(B)");
	report_assertion("A call to void XtUnmanageChild(w) when the widget w is in");
	report_assertion("the process of being destroyed shall return without");
	report_assertion("unmanaging the widget.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.363696 */

static void t007(){

int status;
Widget test2_widget, test_widget;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtUnmanageChild-7.(A)");
	report_assertion("A call to void XtUnmanageChild(w) when the widget w is");
	report_assertion("already unmanaged shall have no effect.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tunmgchdn2", "XtUnmanageChild");
	tet_infoline("PREP: Create a test parent");
	test_widget = XtVaCreateManagedWidget("avsw2", avsComp2WidgetClass, boxw1, NULL);
	tet_infoline("PREP: Create a managed child widget");
	test2_widget = (Widget) CreateLabelWidget("Hello", test_widget);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Unmanage child");
	XtUnmanageChild(test2_widget);
	tet_infoline("TEST: Change managed procedure invoked");
	/*this is a test widget class with a special change managed routine*/
	/*that sets this when its called - see AvsComp2.h in the avsxt library*/
	status = avs_get_event(5);
	if (status != 1) {
		sprintf(ebuf, "ERROR: Change_managed routine not invoked");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Unmanage child again");
	XtUnmanageChild(test2_widget);
	tet_infoline("TEST: Change managed procedure not invoked");
	avs_set_event(5, 0);
	status = avs_get_event(5);
	if (status != 0) {
		sprintf(ebuf, "ERROR: Change_managed routine was invoked again");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363696 */
/* End of included file Mdefcode.tmc.363696 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
