/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtGeometryResult
 *   XtMakeResizeRequest()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <AvsForm.h>
#include <AvsForm2.h>
#include <AvsForm3.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

Widget cooperative_widget5;
XtWidgetGeometry intended5, geom5;

/*destroy callback for test 5*/
void XtCBP(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	XtGeometryResult result;
	Dimension width, height;
	Dimension width_return, height_return;

	tet_infoline("INFO: Inside destroy callback");
        avs_set_event(2,1);
	tet_infoline("PREP: Change geometry of cooperative widget");
	width = geom5.width + 10;
	height = geom5.height + 10;
	result = XtMakeResizeRequest(cooperative_widget5, width, height, &width_return, &height_return);
	tet_infoline("TEST: Return value is XtGeometyNo");
	check_dec(XtGeometryNo, result, "XtGeometryYes");
}

void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
        avs_set_event(1,1);
        exit(1);
}

extern WidgetClass avsWidgetClass, avsCompWidgetClass;



#define T_XtMakeResizeRequest	1
char    *TestName = "XtMakeResizeRequest";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget cooperative_composite, cooperative_widget;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Dimension width, height;
Dimension width_return, height_return;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtMakeResizeRequest-1.(A)");
	report_assertion("When the widget w is unmanaged a call to XtGeometryResult");
	report_assertion("XtMakeResizeRequest(w, width, height, width_return,");
	report_assertion("height_return) shall change the width and the height of the");
	report_assertion("widget to width and height respectively and return");
	report_assertion("XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Createcooperative composite widget in boxw1");
	cooperative_composite = XtCreateManagedWidget("cooperative_widget",
						avsCompWidgetClass,
						boxw1,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create cooperative widget in cooperative composite");
	cooperative_widget = XtCreateManagedWidget("cooperative_widget",
						avsWidgetClass,
						cooperative_composite,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Query geometry of cooperative widget");
	intended.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget, &intended, &geom);
	tet_infoline("PREP: Change geometry of cooperative widget");
	width = geom.width + 10;
	height = geom.height + 10;
	result = XtMakeResizeRequest(cooperative_widget, width, height, &width_return, &height_return);
	tet_infoline("TEST: Return value is XtGeometyYes");
	check_dec(XtGeometryYes, result, "XtGeometryYes");
	tet_infoline("TEST: Returned width and height");
	check_dec(width, width_return, "width");
	check_dec(height, height_return, "height");
	tet_infoline("PREP: Request geometry of cooperative_widget widget");
	intended.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget, NULL, &geom);
	tet_infoline("TEST: Cooperative_widget widget is resized");
	check_dec(width, geom.width, "width");
	check_dec(height, geom.height, "height");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t002(){

Widget cooperative_composite, cooperative_widget;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Dimension width, height;
Dimension width_return, height_return;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtMakeResizeRequest-2.(A)");
	report_assertion("When the parent of the widget w is not realized a call to");
	report_assertion("XtGeometryResult XtMakeResizeRequest(w, width, height,");
	report_assertion("width_return, height_return) shall change the width and the");
	report_assertion("height of the widget to width and height respectively and");
	report_assertion("return XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Createcooperative composite widget in boxw1");
	cooperative_composite = XtCreateManagedWidget("cooperative_widget",
						avsCompWidgetClass,
						boxw1,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create cooperative widget in cooperative composite");
	cooperative_widget = XtCreateManagedWidget("cooperative_widget",
						avsWidgetClass,
						cooperative_composite,
						(ArgList) 0, 0);
	tet_infoline("PREP: Query geometry of cooperative widget");
	intended.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget, &intended, &geom);
	tet_infoline("PREP: Change geometry of cooperative widget");
	width = geom.width + 10;
	height = geom.height + 10;
	result = XtMakeResizeRequest(cooperative_widget, width, height, &width_return, &height_return);
	tet_infoline("TEST: Return value is XtGeometyYes");
	check_dec(XtGeometryYes, result, "XtGeometryYes");
	tet_infoline("TEST: Returned width and height");
	check_dec(width, width_return, "width");
	check_dec(height, height_return, "height");
	tet_infoline("PREP: Request geometry of cooperative_widget widget");
	intended.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget, NULL, &geom);
	tet_infoline("TEST: Cooperative_widget widget is resized");
	check_dec(width, geom.width, "width");
	check_dec(height, geom.height, "height");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t003(){

Widget cooperative_composite, cooperative_widget, cooperative_widget2;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Dimension width, height;
Dimension width_return, height_return;
Widget labelw_good, labelw_good2;
pid_t pid2;
int	invoked;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtMakeResizeRequest-3.(A)");
	report_assertion("When the class of the parent of the widget w is not a");
	report_assertion("subclass of compositeWidgetClass a call to XtGeometryResult");
	report_assertion("XtMakeResizeRequest(w, width, height, width_return,");
	report_assertion("height_return) shall issue an invalidParent error.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkrsizrt3", "XtMakeResizeRequest");
        XtAppSetErrorMsgHandler(app_ctext, XtWMH_Proc);
        tet_infoline("PREP: Create test widgets");
        labelw_good = XtVaCreateWidget(
                        "labelw_good",
                        coreWidgetClass,
                        boxw1,
                        NULL
                        );
        labelw_good2 = XtVaCreateWidget(
                        "labelw_good2",
                        coreWidgetClass,
                        labelw_good,
                        NULL
                        );
        ConfigureDimension(topLevel, labelw_good);
        ConfigureDimension(topLevel, labelw_good2);
	tet_infoline("TEST: Call XtMakeResizeRequest");
	result = XtMakeResizeRequest(labelw_good2, width, height, &width_return, &height_return);
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Error handler was invoked");
        invoked = avs_get_event(1);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Error handler was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t004(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget formw_good, formw_good2, labelw_good;
pid_t pid2;
int invoked;
Dimension width_return, height_return;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtMakeResizeRequest-4.(A)");
	report_assertion("When the geometry_manager field of the parent of the widget");
	report_assertion("w is NULL a call to XtGeometryResult XtMakeResizeRequest(w,");
	report_assertion("width, height, width_return, height_return) shall issue an");
	report_assertion("invalidGeometryManager error.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkrsizrt1", "XtMakeGeometryRequest");
        XtAppSetErrorMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create avsform3 widget in avsform widget");
	formw_good2 = XtCreateManagedWidget("avsform3",
			avsform3WidgetClass,
			boxw1,
			NULL,
			0);
	labelw_good = (Widget) CreateLabelWidget("Hello", formw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Call XtMakeResizeRequest");
	result = XtMakeResizeRequest(labelw_good, 10, 10, &width_return, &height_return);
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Error handler was invoked");
        invoked = avs_get_event(1);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Error handler was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t005(){

int	invoked;
Widget cooperative_composite;
pid_t pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtMakeResizeRequest-5.(A)");
	report_assertion("When the being_destroyed field of the widget w is True a");
	report_assertion("call to XtGeometryResult XtMakeResizeRequest(w, width,");
	report_assertion("height, width_return, height_return) shall return");
	report_assertion("XtGeometryNo.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

        avs_set_event(2,0);
	FORK(pid2);
	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Createcooperative composite widget in boxw1");
	cooperative_composite = XtCreateManagedWidget("cooperative_widget",
						avsCompWidgetClass,
						boxw1,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create cooperative widget in cooperative composite");
	cooperative_widget5 = XtCreateManagedWidget("cooperative_widget",
						avsWidgetClass,
						cooperative_composite,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Query geometry of cooperative widget");
	intended5.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget5, &intended5, &geom5);
	tet_infoline("PREP: Add destroy callback procedure to cooperative widget");
	XtAddCallback(cooperative_widget5,
			XtNdestroyCallback,
			XtCBP,
			(XtPointer)NULL
			);
	tet_infoline("PREP: Destroy cooperative widget");
	XtDestroyWidget(cooperative_widget5);
        LKROF(pid2, AVSXTTIMEOUT-2);
        invoked = avs_get_event(2);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Destroy callback was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        } else
		tet_result(TET_PASS);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t006(){

Widget cooperative_composite, cooperative_widget;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Dimension width, height;
Dimension width_return, height_return;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtMakeResizeRequest-6.(A)");
	report_assertion("When the width and the height fields of the widget w are");
	report_assertion("equal to width and height respectively a call to");
	report_assertion("XtGeometryResult XtMakeResizeRequest(w, width, height,");
	report_assertion("width_return, height_return) shall return XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Createcooperative composite widget in boxw1");
	cooperative_composite = XtCreateManagedWidget("cooperative_widget",
						avsCompWidgetClass,
						boxw1,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create cooperative widget in cooperative composite");
	cooperative_widget = XtCreateManagedWidget("cooperative_widget",
						avsWidgetClass,
						cooperative_composite,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Query geometry of cooperative widget");
	intended.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget, &intended, &geom);
	tet_infoline("PREP: Do not change width and height of cooperative widget");
	width = geom.width;
	height = geom.height;
	result = XtMakeResizeRequest(cooperative_widget, width, height, &width_return, &height_return);
	tet_infoline("TEST: Return value is XtGeometyYes");
	check_dec(XtGeometryYes, result, "XtGeometryYes");
	tet_infoline("TEST: Returned width and height");
	check_dec(width, width_return, "width");
	check_dec(height, height_return, "height");
	tet_infoline("PREP: Request geometry of cooperative_widget widget");
	intended.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget, NULL, &geom);
	tet_infoline("TEST: Cooperative_widget widget is resized");
	check_dec(width, geom.width, "width");
	check_dec(height, geom.height, "height");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t007(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget formw_good, formw_good2, labelw_good;
pid_t pid2;
int invoked;
Dimension width_return, height_return;
Dimension width, height;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtMakeResizeRequest-7.(A)");
	report_assertion("When the width field of the widget w is not equal to width");
	report_assertion("or the height field is not equal to height a call to");
	report_assertion("XtGeometryResult XtMakeResizeRequest(w, width, height,");
	report_assertion("width_return, height_return) shall call the geometry_manager");
	report_assertion("procedure of the specified widget's parent.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Create avsform widget in boxw1 widget");
	formw_good = XtCreateManagedWidget("avsform",
			avsformWidgetClass,
			boxw1,
			NULL,
			0);
	tet_infoline("PREP: Create avsform2 widget in avsform widget");
	formw_good2 = XtCreateManagedWidget("avsform2",
			avsform2WidgetClass,
			formw_good,
			NULL,
			0);
	labelw_good = (Widget) CreateLabelWidget("Hello", formw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Change size of avsform2 widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(formw_good2, &intended, &geom);
	width = geom.width + 10;
	height = geom.height + 10;
	result = XtMakeResizeRequest(formw_good2, width, height, &width_return, &height_return);
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Parent's Geometry manager was invoked");
        invoked = avs_get_event(5);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Geometry manager was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

/* Including from file Mdefcode.tmc.364720 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtMakeResizeRequest-8.(B)");
	report_assertion("On a call to XtGeometryResult XtMakeResizeRequest(w, width,");
	report_assertion("height, width_return, height_return) when the widget w is");
	report_assertion("realized, the width field of the widget is not equal to");
	report_assertion("width or the height field is not equal to height, and the");
	report_assertion("call to the geometry_manager procedure of the widget's");
	report_assertion("parent returns XtGeometryYes with request->request_mode set");
	report_assertion("to a value other than XtCWQueryOnly it shall call the");
	report_assertion("XConfigureWindow Xlib function.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364720 */

static void t009(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget formw_good, formw_good2, labelw_good;
pid_t pid2;
int invoked;
Dimension width_return, height_return;
Dimension width, height;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtMakeResizeRequest-9.(A)");
	report_assertion("A call to XtGeometryResult XtMakeResizeRequest(w, width,");
	report_assertion("height, width_return, height_return) when the widget w is");
	report_assertion("realized, the width field of the widget is not equal to");
	report_assertion("width or the height field is not equal to height, and the");
	report_assertion("call to the geometry_manager procedure of the widget's");
	report_assertion("parent returns XtGeometryDone shall return XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

/*this test does not pass prior do R6.4gamma due to issues with
consistency of the spec, test suite, and sample code*/
if (config.coverage < 2) {
	FORK(pid2);
	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Create avsform widget in boxw1 widget");
	formw_good = XtCreateManagedWidget("avsform",
			avsformWidgetClass,
			boxw1,
			NULL,
			0);
	tet_infoline("PREP: Create avsform2 widget in avsform widget");
	formw_good2 = XtCreateManagedWidget("avsform2",
			avsform2WidgetClass,
			formw_good,
			NULL,
			0);
	labelw_good = (Widget) CreateLabelWidget("Hello", formw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Change geometry of avsform2 widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(formw_good2, &intended, &geom);
	width = geom.width + 10;
	height = geom.height + 10;
	/*this forces the avsForm (parent) widget's geometry manager to
	return XtMakeGeometryDone*/
	avs_set_event(5, 77);
	result = XtMakeResizeRequest(formw_good2, width, height, &width_return, &height_return);
	tet_infoline("TEST: return value is XtGeometryYes");
	check_dec(XtGeometryYes, result, "XtMakeGeometryRequest result");
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Parent's Geometry manager was invoked");
        invoked = avs_get_event(5);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Geometry manager was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);
} else {
	tet_infoline("INFO: Test surpressed due to XT_COVERAGE value");
	tet_result(TET_UNTESTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t010(){

Widget cooperative_composite, cooperative_widget;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Dimension width, height;
Dimension width_return, height_return;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtMakeResizeRequest-10.(A)");
	report_assertion("A call to XtGeometryResult XtMakeResizeRequest(w, width,");
	report_assertion("height, width_return, height_return) when the widget w is");
	report_assertion("realized, the width field of the widget is not equal to");
	report_assertion("width or the height field is not equal to height, and the");
	report_assertion("call to the geometry_manager procedure of the the widget's");
	report_assertion("parent neither returns XtGeometryYes with");
	report_assertion("request->request_mode set to a value other than");
	report_assertion("XtCWQueryOnly nor returns XtGeometryDone shall return what");
	report_assertion("the geometry_manager procedure returns.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Createcooperative composite widget in boxw1");
	cooperative_composite = XtCreateManagedWidget("cooperative_widget",
						avsCompWidgetClass,
						boxw1,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create cooperative widget in cooperative composite");
	cooperative_widget = XtCreateManagedWidget("cooperative_widget",
						avsWidgetClass,
						cooperative_composite,
						(ArgList) 0, 0);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Query geometry of cooperative widget");
	intended.request_mode = CWWidth|CWHeight;
	XtQueryGeometry(cooperative_widget, &intended, &geom);
	tet_infoline("PREP: Change width and height of cooperative widget");
	width = geom.width+10;
	height = geom.height+10;
	result = XtMakeResizeRequest(cooperative_widget, width, height, &width_return, &height_return);
	tet_infoline("TEST: Return value is XtGeometyYes");
	check_dec(XtGeometryYes, result, "XtGeometryYes");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

static void t011(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget formw_good, formw_good2, labelw_good;
pid_t pid2;
int invoked;
Dimension width_return, height_return;
Dimension width, height;
pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtMakeResizeRequest-11.(A)");
	report_assertion("On a call to XtGeometryResult XtMakeResizeRequest(w, width,");
	report_assertion("height, width_return, height_return) when the return value");
	report_assertion("is XtGeometryAlmost, width_return and height_return shall");
	report_assertion("contain the compromise width and height respectively.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkrsizrt1", "XtMakeResizeRequest");
	tet_infoline("PREP: Create avsform widget in boxw1 widget");
	formw_good = XtCreateManagedWidget("avsform",
			avsformWidgetClass,
			boxw1,
			NULL,
			0);
	tet_infoline("PREP: Create avsform2 widget in avsform widget");
	formw_good2 = XtCreateManagedWidget("avsform2",
			avsform2WidgetClass,
			formw_good,
			NULL,
			0);
	labelw_good = (Widget) CreateLabelWidget("Hello", formw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Change geometry of avsform2 widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(formw_good2, &intended, &geom);
	width = geom.width + 10;
	height = geom.height + 10;
	/*this forces the avsForm (parent) widget's geometry manager to
	return XtMakeGeometryAlmost*/
	avs_set_event(5, 88);
	result = XtMakeResizeRequest(formw_good2, width, height, &width_return, &height_return);
	tet_infoline("TEST: return value is XtGeometryAlmost");
	check_dec(XtGeometryAlmost, result, "XtMakeGeometryRequest result");
	tet_infoline("TEST: Returned width and height");
	check_dec(88, width_return, "width");
	check_dec(99, height_return, "height");
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Parent's Geometry manager was invoked");
        invoked = avs_get_event(5);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Geometry manager was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364720 */
/* End of included file Mdefcode.tmc.364720 */

/* Including from file Mdefcode.tmc.364720 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtMakeResizeRequest-12.(B)");
	report_assertion("When width and height are both NULL a call to");
	report_assertion("XtGeometryResult XtMakeResizeRequest(w, width, height,");
	report_assertion("width_return, height_return) shall not return");
	report_assertion("XtGeometryAlmost.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364720 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
