#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>
#include "uxsock.h"

/*
 * keep writing until its all sent
 */
int write_all(int fd, const void *buf, size_t len)
{
	size_t total = 0;
	while (len) {
		int n = write(fd, buf, len);
		if (n < 0) {
			perror("failed to send message to multipathd");
			return total;
		}
		buf = n + (char *)buf;
		len -= n;
		total += n;
	}
	
	return total;
}

/*
 * keep reading until its all read
 */
int read_all(int fd, void *buf, size_t len)
{
	size_t total = 0;
	while (len) {
		int n = read(fd, buf, len);
		if (n < 0) {
			perror("failed to receive message from multipathd");
			return total;
		}
		buf = n + (char *)buf;
		len -= n;
		total += n;
	}
	return total;
}

void print_usage(FILE *f)
{
	fprintf(f, "Usage: mpath_ctl (add|remove) (map|path) devname\n");
	fprintf(f, "\tdevname is the sysfs name for the device without\n");
	fprintf(f, "\tthe leading {sysfs_root}/block/\n");
}

int main(int argc, char **argv)
{
	int sock;
	struct sockaddr_un sun;
	int len;
	char reply[6];

	if (argc == 1 || (!strcmp(argv[1], "-h")) ||
	    (!strcmp(argv[1], "--help"))) {
		print_usage(stdout);
		exit(0);
	}
	if (argc != 2) {
		print_usage(stderr);
		exit(1);
	}
	len = strlen(argv[1]) + 1;
	if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0){
		perror("cannot create unix stream socket");
		exit(1);
	}
	sun.sun_family = AF_UNIX;
	strncpy(sun.sun_path, SOCKET_NAME, sizeof(sun.sun_path));
	sun.sun_path[sizeof(sun.sun_path)-1] = 0;
	if (connect(sock, (struct sockaddr *)&sun, sizeof(sun)) < 0) {
		perror("cannot connect to "SOCKET_NAME);
		exit(0);
	}
	if (write_all(sock, &len, sizeof(len)) != sizeof(len))
		exit(1);
	if (write_all(sock, argv[1], len) != len)
		exit(1);
	if (read_all(sock, &len, sizeof(len)) != sizeof(len))
		exit(1);
	if (len > 6){
		fprintf(stderr, "reply from multipathd too long\n");
		exit(1);
	}
	if (read_all(sock, &reply, len) != len)
		exit(1);
	if (!strcmp(reply, "fail\n")){
		fprintf(stderr, "operation failed\n");
		exit(1);
	}
	if (strcmp(reply, "ok")){
		fprintf(stderr, "unexpected reply from multipathd '%s'\n",
			reply);
		exit(1);
	}
	close(sock);
	return 0;
}
	
