<!-- Fragment document type declaration subset:
ArborText, Inc., 1988-1997, v.4001
<!DOCTYPE BOOK PUBLIC "-//Davenport//DTD DocBook V3.0//EN" [
<!ENTITY html SYSTEM "html.sgm">
<!ENTITY print SYSTEM "print.sgm">
<!ENTITY dprhtm "<?html-filename pr-ver.htm>">
<!ENTITY dlibhtm "<?html-filename lib-ver.htm>">
<!ENTITY dhtmhtm "<?html-filename html-ver.htm>">
<!ENTITY dcmnhtm "<?html-filename cmn-ver.htm>">
<!ENTITY doc-dblib SYSTEM "dblib.sgm">
<!ENTITY doc-dbparam SYSTEM "dbparam.sgm">
<!ENTITY print-version SYSTEM "n:\share\dsssl\docbook\print\version.dsl">
<!ENTITY % dsssl-documentation "INCLUDE">
<!ENTITY % dsssl-source "IGNORE">
<!ENTITY common-version SYSTEM "n:\share\dsssl\docbook\common\version.sgm">
<!ENTITY lib-version SYSTEM "n:\share\dsssl\docbook\lib\version.sgm">
]>
-->
<?Pub Inc>
<![ %dsssl-source; [;; $Id: version.dsl,v 1.1 1998/02/18 13:13:55 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; If **ANY** change is made to this file, you _MUST_ alter the
;; following definition:

(define %stylesheet-version%
  "Modular DocBook HTML Stylesheet version 1.05")

]]><![ %dsssl-documentation; [<article id="htmlchanges" role="nonav"><artheader>
<title>Change Log: HTML Stylesheet</title>
<subtitle>Changes to the Modular DocBook Stylesheet</subtitle></artheader>&dhtmhtm;
<para>This document summarizes the changes made to the Modular DocBook HTML
Stylesheet:</para>
<variablelist>
<varlistentry>
<term>Version 1.05, 15 Feb 1998</term><listitem>
<itemizedlist>
<listitem><para>Fixed some bugs in the way ToCs and chapter ToCs were produced.
</para>
</listitem>
<listitem><para>Moved common localization functions into the common directory.
</para>
</listitem>
<listitem><para>Created a public identifier for the HTML stylesheet: <screen>
-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN</screen>and added a <filename>
CATALOG</filename> file to the distribution.</para>
</listitem><?Pub Caret1>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>Version 1.04, 08 Feb 1998</term><listitem>
<itemizedlist>
<listitem><para>Fixed some bugs with admonitions. If a <sgmltag>Title</sgmltag>
is present on an admonition, it is used <emphasis>in place of</emphasis> the
automatically generated title. This was the intended behavior in the past,
but it was not implemented properly. Admonitions containing <sgmltag>SimPara
</sgmltag> now work.</para>
</listitem>
<listitem><para>Changed heuristic for finding <sgmltag>Title</sgmltag> and <sgmltag>
SubTitle</sgmltag> elements in <sgmltag>*Info</sgmltag> nodes. The stylesheet
now unwraps one level of <sgmltag>BookBiblio</sgmltag>, <sgmltag>BiblioMisc
</sgmltag>, or <sgmltag>BiblioSet</sgmltag>.</para>
</listitem>
<listitem><para><sgmltag>Editor</sgmltag>s are now supported in the book meta.
</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>Version 1.03, 06 Feb 1998</term><listitem><para>Fixed a small problem
with <sgmltag>RevHistory</sgmltag> in <sgmltag>BookBiblio</sgmltag>; the construction
rule in <filename>dbinfo.dsl</filename> was more specific than the rule in <filename>
dbbibl.dsl</filename>, so the wrong rule was firing. Fixed by making the construction
rule in <filename>dbinfo.dsl</filename> call a function defined in <filename>
dbbibl.dsl</filename>.</para>
</listitem></varlistentry>
<varlistentry>
<term>Version 1.02, 03 Feb 1998</term><listitem>
<itemizedlist>
<listitem><para>Added support for sending HTML output to a single file instead
of making chunks. To use this feature, set <literal>nochunks</literal> to <literal>
#t</literal> in your stylesheet or pass Jade the option <literal>-V nochunks
</literal> when you format the document. You must use I/O redirection to capture
the HTML output if you suppress chunking.</para>
</listitem>
<listitem><para>Added support for separators between chunks. These are empty
by default if chunking is enabled, and a single <literal>&lt;HR></literal>
if chunking is suppressed.</para>
</listitem>
<listitem><para><sgmltag>Chapter</sgmltag> and <sgmltag>Part</sgmltag> TOCs
are suppressed by default if chunking is suppressed.</para>
</listitem>
<listitem><para>Added an <literal>&lt;A NAME="..."></literal> wrapper to component
and division titles.</para>
</listitem>
<listitem><para>Fixed a bug in the support for graphics if <literal>fileref
</literal> is unspecified.</para>
</listitem>
<listitem><para>Changed default section level for <sgmltag>SimpleSect</sgmltag>s
to 1.</para>
</listitem>
<listitem><para>Fixed bug that prevented processing instructions from being
allowed between table rows and entries. </para>
</listitem>
<listitem><para>Changed default formatting of <sgmltag>Emphasis</sgmltag>
and <sgmltag>FirstTerm</sgmltag> to italic rather than bold. Changed the default
formatting of <sgmltag>Filename</sgmltag> to a mono-spaced font.</para>
</listitem>
<listitem><para>Added <literal>%chapter-autolabel%</literal> to control enumeration
of <sgmltag>Chapter</sgmltag>s.</para>
</listitem>
<listitem><para>Fixed a small problem in the formatting of <sgmltag>RefEntry
</sgmltag>s.</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>1.01, 07 Jan 1998</term><listitem>
<itemizedlist>
<listitem><para>Made <sgmltag>SideBar</sgmltag> and <sgmltag>LegalNotice</sgmltag> <literal>
$semiformal-object$</literal>s</para>
</listitem>
<listitem><para>Fixed formatting of section <sgmltag>SubTitle</sgmltag>s.
(The were coming out <emphasis>bigger</emphasis> rather than smaller than
the section <sgmltag>Title</sgmltag>s.)</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>1.0, 06 Jan 1998</term><listitem><para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Happy New Year!</para>
</listitem>
<listitem><para>Moved table footnote code to <filename>dbfootn.dsl</filename>;
moved <sgmltag>TABLE</sgmltag> and <sgmltag>INFORMALTABLE</sgmltag> element
rules to <filename>dbblock.dsl</filename>. Like the changes to <filename>
dbcommon.dsl</filename>, these changes make it easier to reuse the CALS table
handling code in <filename>dbtable.dsl</filename> with other DTDs.</para>
</listitem>
<listitem><para>Made substantial changes to <literal>next-major-component-chunk-element
</literal> and <literal>prev-major-component-chunk-element</literal>. These
are supposed to be &ldquo;next sibling&rdquo; and &ldquo;previous sibling&rdquo;
functions. I <emphasis>think</emphasis> these versions work.</para>
</listitem>
<listitem><para>Added <filename>common/dbtable.dsl</filename> to the DocBook
stylesheet.</para>
</listitem>
</itemizedlist></para>
</listitem></varlistentry>
<varlistentry>
<term>0.10, 29 Dec 1997</term><listitem><para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Fixed small formatting bug in Bibliographies, where a comma
(<literal>%biblsep%</literal>) was output after the <literal>[abbrev]</literal>.
</para>
</listitem>
<listitem><para>Added <literal>%graphic-default-extension%</literal> to allow
stylesheets to select the appropriate format of graphics in print vs. HTML
stylesheets.</para>
</listitem>
<listitem><para>Modified <literal>$html-header-meta$</literal> so that a <literal>
CREATOR</literal> <sgmltag>Meta</sgmltag> tag is always output with the <literal>
%stylesheet-version%</literal>.</para>
</listitem>
<listitem><para>Handle <literal>IDREFS</literal> on <sgmltag>Callout</sgmltag>s.
</para>
</listitem>
<listitem><para>Added <literal>%simplelist-column-width%</literal> to set
width of columns in <sgmltag>SimpleList</sgmltag>s.</para>
</listitem>
<listitem><para>Added <filename>version.dsl</filename> to contain the change
log and the version.</para>
</listitem>
</itemizedlist></para>
</listitem></varlistentry>
<varlistentry>
<term>0.9, 04 Dec 1997</term><listitem><para>This release contains support
for callouts, a few other enhancements, a number of bug fixes, and a set of
test documents.</para>
<para>Changes to <filename>dblib.dsl</filename>; the general function library:<itemizedlist>
<listitem><para>Fixed bug in <literal>has-ancestor-member?</literal>; it returned
precisely the opposite condition.</para>
</listitem>
<listitem><para>Added <literal>string->list</literal>, <literal>list->string
</literal>, and <literal>split</literal>.</para>
</listitem>
</itemizedlist></para>
<para>Changes to <filename>dbcommon.dsl</filename>; the common library:<itemizedlist>
<listitem><para>Added <literal>REFENTRY</literal> to <literal>major-component-element-list
</literal> to fix HTML navigation problems.</para>
</listitem>
<listitem><para>Added <literal>EQUATION</literal> to <literal>block-element-list
</literal> so that <literal>XREF</literal>s are possible.</para>
</listitem>
<listitem><para>Removed extraneous space in <literal>author-list-string</literal>.
</para>
</listitem>
<listitem><para>Added <literal>bibliodiv-autolabel</literal>, <literal>glossdiv-autolabel
</literal>, <literal>dedication-title-sosofo</literal>, and <literal>dedication-title
</literal>.</para>
</listitem>
</itemizedlist></para>
<para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Added more support for <literal>CALLOUT</literal>s. The support
is based on an old posting to the <ulink url="http://www.mulberrytech.com/">
dssslist</ulink> and is fairly fragile. See <filename>dbcallou.dsl</filename>.
</para>
</listitem>
<listitem><para>Added support for line numbers in linespecific displays. Like
the support for <literal>CALLOUT</literal>s, it's a bit fragile.</para>
</listitem>
<listitem><para>Using the same approach, <literal>LITERALLAYOUT</literal>
and <literal>ADDRESS</literal> elements are no longer set as <literal>&lt;PRE>
</literal>s. Instead, line breaks and spaces are handled by conversion to <literal>
&lt;BR></literal> and <literal>&amp;nbsp;</literal> in a normal <literal>
&lt;P></literal>.</para>
</listitem>
<listitem><para>Added support for bibliography entries. The result probably
doesn't follow any particular, published bibliographic style, and may not
suit the needs of anyone, but at least the stylesheet <emphasis>tries</emphasis>
now. ;-)</para>
</listitem>
<listitem><para>Fixed table bug. Overhanging rows were not always accounted
for when skipping to a new entry.</para>
</listitem>
<listitem><para>Support for <literal>CALLOUT</literal>s to multiple <literal>
AREA</literal>s is broken. The stylesheet now outputs &ldquo;??&rdquo; to
indicate this.</para>
</listitem>
<listitem><para>Suppress <literal>ACRONYM</literal> and <literal>ABBREV</literal>
in the <emphasis>direct</emphasis> content model of <literal>GLOSSENTRY</literal>.
</para>
</listitem>
<listitem><para>Fixed <literal>KEYCOMBO</literal> so that a &ldquo;+&rdquo;
is printed between its children.</para>
</listitem>
<listitem><para>Improved <filename>dbl1ru.dsl</filename>.</para>
</listitem>
<listitem><para>Added <literal>DEDICATION</literal> and &ldquo;Pgs.&rdquo;
to <filename>dbl1usen.dsl</filename>.</para>
</listitem>
<listitem><para>Improved support for <literal>INFORMALEQUATION</literal> and <literal>
INLINEEQUATION</literal>.</para>
</listitem>
<listitem><para>Suppress <literal>MSGREL</literal>.</para>
</listitem>
</itemizedlist></para>
</listitem></varlistentry>
<varlistentry>
<term>0.8, 24 Nov 1997</term><listitem><para>Minor changes.</para>
</listitem></varlistentry>
<varlistentry>
<term>0.7, never released</term><listitem><para>The changes between 0.6 and
0.7 are quite extensive. Most dramatically, support for tables has been rewritten
from scratch; see <filename>dbtable.dsl</filename> for more info.</para>
<para>Changes to <filename>dblib.dsl</filename>; the general function library:<itemizedlist>
<listitem><para>Added <literal>expand-children</literal> to replace elements
of a node list with the children of those elements. This is used, for example,
to make sure that a list of all the chapters of a book can be constructed
by expanding the <literal>PART</literal> elements in the node list returned
by <literal>(children book)</literal> with their children.</para>
</listitem>
<listitem><para>Moved <literal>book-start?</literal> to <filename>dbcommon.dsl
</filename>. It's specific to a particular class of DTDs (those with <literal>
BOOK</literal>s ;-).</para>
</listitem>
<listitem><para>Fixed a serious bug in case conversion; the letter &ldquo;A&rdquo;
couldn't be shifted to lower case.</para>
</listitem>
<listitem><para>Added <literal>constant-list</literal>, returns a list of
&ldquo;n&rdquo; copies of a specified value.</para>
</listitem>
<listitem><para>Added <literal>list-head</literal>, returns the first &ldquo;n&rdquo;
items from a list.</para>
</listitem>
<listitem><para>Added <literal>list-put</literal>, replaces a single value
in a list.</para>
</listitem>
<listitem><para>Added <literal>decrement-list-members</literal>. Maybe this
isn't so useful in general, but it decrements all the members of a list of
numbers by a specified value.</para>
</listitem>
<listitem><para>Added <literal>sgml-root-element</literal>. Returns the root
of the document. There's a better way to do this, right?</para>
</listitem>
<listitem><para>Added <literal>length-string-number-part</literal>. Given
a string of the form &ldquo;25pt&rdquo;, this function returns the &ldquo;25&rdquo;.
</para>
</listitem>
<listitem><para>Added <literal>length-string-unit-part</literal>. Given a
string of the form &ldquo;25pt&rdquo;, this function returns the &ldquo;pt&rdquo;.
</para>
</listitem>
</itemizedlist></para>
<para>Changes to <filename>dbcommon.dsl</filename>; the common library:<itemizedlist>
<listitem><para>Moved <literal>book-start?</literal> from <filename>dblib.dsl
</filename>.</para>
</listitem>
<listitem><para>Added <literal>first-chapter?</literal>. Returns true if the
node specified is the first <literal>CHAPTER</literal> of a <literal>BOOK
</literal>. (This includes the first chapter inside a <literal>PART</literal>.)
</para>
</listitem>
<listitem><para>Added <literal>major-component-element-list</literal> for
the revised &ldquo;fast forward&rdquo; code. See <literal>dbnavig.dsl</literal>.
</para>
</listitem>
<listitem><para>Added a whole bunch of functions for supporting CALS tables
that are shared between the HTML and print versions of the stylesheet.</para>
</listitem>
</itemizedlist></para>
<para>Changes to the HTML stylesheet:<itemizedlist>
<listitem><para>Completely rewrote table processing code.</para>
</listitem>
<listitem><para>Replaced <literal>admon-title-mode</literal> with <literal>
title-mode</literal> in <filename>dbtitle.dsl</filename>.</para>
</listitem>
<listitem><para>Moved support for linked-to <literal>LEGALNOTICE</literal>s
into the mode used for book title pages. This means <literal>LEGALNOTICE</literal>s
and <literal>COPYRIGHT</literal>s elsewhere don't get special treatment.</para>
</listitem>
<listitem><para>Added <literal>$inline-object$</literal>, <literal>$formal-object$
</literal>, and <literal>$semiformal-object$</literal>. Reorganized code for
informal and formal block obects to use these new functions. These functions
explicitly handle titles instead of relying on element construction rules
for the titles.</para>
</listitem>
<listitem><para>Added alt-text as a parameter to the code that supports images.
This allows the contents of the <literal>ALT</literal> tag on, for example, <literal>
EQUATION</literal>s to be passed through.</para>
</listitem>
<listitem><para>Added support for <literal>SUBTITLE</literal>s in most places.
</para>
</listitem>
<listitem><para>Added support for titled <literal>EQUATION</literal>s.</para>
</listitem>
<listitem><para>Localized literal text in support for table footnotes.</para>
</listitem>
<listitem><para>Changed meaning of fast forward and fast backward. These functions
now <emphasis>always</emphasis> go to the next or previous chapter-level element.
</para>
</listitem>
<listitem><para>Navigation banner and title banner now sport the book title
by default. Up is only present if the parent is not the root of the document.
</para>
</listitem>
<listitem><para>Added support for callouts that use <literal>CO</literal>.
</para>
</listitem>
<listitem><para>Fixed table/figure enumeration bugs.</para>
</listitem>
<listitem><para>Improved support for <literal>CMDSYNOPSIS</literal></para>
</listitem>
<listitem><para>Improved support for <literal>FUNCSYNOPSIS</literal></para>
</listitem>
<listitem><para>Added support for <literal>CLASS</literal> on <literal>SGMLTAG
</literal>.</para>
</listitem>
</itemizedlist></para>
</listitem></varlistentry>
<varlistentry>
<term>0.6, 12 Nov 1997</term><listitem><para>The changes between 0.5 and 0.6
are so extensive that it would be difficult to document them in detail. All
of the files in this distribution have been updated to have a version number
of 0.6.</para>
<para>My primary goal in making these changes was to build a common library
of code for both the print and HTML stylesheets. To achieve this goal, a great
deal of code was moved around and reorganized.</para>
<para>What follows is a short list of the more dramatic changes:</para>
<itemizedlist>
<listitem><para>This style sheet now relies on the common <filename>dblib.dsl
</filename> and <filename>dbcommon.dsl</filename> libraries.</para>
</listitem>
<listitem><para>Changed formatting of division, component, and section titles
from &ldquo;passive&rdquo; to &ldquo;active&rdquo;. Rather than relying on
a rule for <literal>(<replaceable>element</replaceable> TITLE)</literal> to
process the titles, the rules that process the actually element wrappers now
process the titles. This allows optional titles to be formatted correctly.
</para>
</listitem>
<listitem><para>Added support for <literal>Subtitle</literal>s in many places.
</para>
</listitem>
<listitem><para>Added support for <literal>SimpleList</literal>s</para>
</listitem>
<listitem><para>Added support for <literal>GlossSee</literal> and <literal>
GlossSeeAlso</literal>.</para>
</listitem>
<listitem><para>Added <literal>%spacing-paras%</literal> to control whether
or not empty &lt;p> tags are inserted before some block-level elements to
get the &ldquo;right&rdquo; vertical spacing in the browser.  Can you say
hack?</para>
</listitem>
<listitem><para>Lots of other little bug fixes.</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>Version 0.5, 27 Oct 1997</term><listitem>
<itemizedlist>
<listitem><para>Fixed bugs associated with automatically generated TOCs that
contain only one element (when <literal>%force-chapter-toc%</literal> is true).
</para>
</listitem>
<listitem><para>Added <literal>%generate-legalnotice-link%</literal> and the
ability to place <literal>LegalNotice</literal>s in an external file, linked
to from the <literal>Copyright</literal> notice.</para>
</listitem>
<listitem><para>Generate HTML anchors on Figures.</para>
</listitem>
<listitem><para>Fixed a bug in Table and Figure enumeration.</para>
</listitem>
<listitem><para>Replaced <literal>(process-children-trim)</literal> with <literal>
(process-children)</literal> in many places. (Should be done in all?)</para>
</listitem>
<listitem><para>Added support for ENTITYREF on <literal>Graphic</literal>
and <literal>InlineGraphic</literal></para>
</listitem>
<listitem><para>Changed <literal>DocInfo</literal>, <literal>Sect1Info</literal>,
etc. to process children. This will cause backward compatability problems
for users that have *Info elements but don't want that content displayed.
A future version will fix this problem by making all of the internal containers <literal>
(empty-sosofo)</literal>s.</para>
<para>Added wrappers for handling <literal>Abstract</literal>s in <literal>
DocInfo</literal>.</para>
</listitem>
<listitem><para>Added <literal>%gentext-nav-use-ff%</literal> to toggle use
of &ldquo;fast forwarding&rdquo; in navigation. Fast forwarding adds navigation
elements to skip forward to the next sibling element (i.e. the next chapter)
instead of the next sequential element (i.e. the first sect1).</para>
<para>Added support for fast forward navigation.</para>
</listitem>
<listitem><para>Changed the functions that insert navigational elements to
make insert of graphics easier.</para>
</listitem>
<listitem><para>Added more hooks in <literal>dblink.dsl</literal> to make
customizing titles easier.</para>
</listitem>
<listitem><para>First cut at support for horizontal and vertical spanning
and alignment in tables.</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>Version 0.4, 18 Sep 1997</term><listitem>
<itemizedlist>
<listitem><para>Suppress chapter TOC if there's only one element in the TOC.
 Added <literal>%force-chapter-toc%</literal> to force one.</para>
</listitem>
<listitem><para>Changed formatting of <literal>REVHISTORY</literal>.</para>
</listitem>
<listitem><para>Made <literal>$chapter-toc$</literal> always find the appropriate
ancestral component in case it's called from a descendant (such as <literal>
TITLE</literal>).</para>
</listitem>
<listitem><para>Output <literal>NAME</literal> on an anchor for <literal>
VARLISTENTRY</literal>s that have <literal>ID</literal>s.</para>
</listitem>
<listitem><para><emphasis>Big</emphasis> changes to <filename>dbnavig.dsl
</filename> to fix a bug where linking was incorrect when <literal>chunk-skip-first-element-list
</literal> was used.  I think it works now.  See comments in file.</para>
</listitem>
<listitem><para>Added <literal>style-specification</literal> and <literal>
style-specification-body</literal> tags to <filename>docbook.dsl</filename>
and <filename>dbl1*.dsl</filename> so that <literal>OMITTAG YES</literal>
is no longer required in the SGML declaration used by Jade.</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>Version 0.3, 18 Aug 1997</term><listitem>
<itemizedlist>
<listitem><para>Added <literal>%gentext-and%</literal> to customization layers.
Replaces literal &ldquo;and&rdquo; in <filename>dbbibl.dsl</filename>.</para>
</listitem>
<listitem><para>The chunking level is now very general. In the distributed
style sheet, any element at the division, component, or block level can be
a chunk. If the function <literal>(chunk? nd)</literal> returns true, the
chunk <literal>nd</literal> will be in a seperate file. (Supporting arbitrary
chunking would require some additional coding in the style sheet.)</para>
</listitem>
<listitem><para>Added support for the <literal>align</literal> attribute on <sgmltag>
GRAPHIC</sgmltag> and <sgmltag>INLINEGRAPHIC</sgmltag>.</para>
</listitem>
<listitem><para>Added support for <sgmltag>ARTICLE</sgmltag>s</para>
</listitem>
<listitem><para>Element titles can be retrieved with <literal>(element-title
nd)</literal>. For xref purposes, these titles will be italic.</para>
</listitem>
<listitem><para>Changed calculation for filenames. The new names are perhaps
not as nice, but they have the necessary generality to support the more arbitrary
chunking.</para>
</listitem>
<listitem><para>Completely reworked the code that calculates previous and
next nodes.</para>
</listitem>
<listitem><para>Added hooks for tailoring the navigation links at the head
and foot of each page.</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
<varlistentry>
<term>Version 0.2, 08 Aug 1997</term><listitem><para> <itemizedlist>
<listitem><para>Version 0.2 never publicly released.</para>
</listitem>
<listitem><para> Completely rewrote automatic TOC code. Automatic TOCs are
now built by traversing elements explicitly. Added ability to set depth of
TOC, see <literal>(toc-depth)</literal>.</para>
</listitem>
<listitem><para>Changed format of SIDEBAR. Now a table.</para>
</listitem>
<listitem><para>Added support for META in HEAD.</para>
</listitem>
<listitem><para>Changed <literal>($chapter-toc$)</literal> to use new TOC
code.</para>
</listitem>
<listitem><para>Added navigation to BOOK page, BOOK entity filename is no
longer a constant.</para>
</listitem>
<listitem><para>Added support for PARTs.</para>
</listitem>
<listitem><para>GLOSSARY is now a DL, not a collection of H3's and BLOCKQUOTEs.
</para>
</listitem>
<listitem><para>Rewrote header and footer navigation. Now works correctly
 for a much wider range of component level elements.</para>
</listitem>
<listitem><para>Added support for <literal>&lt;?html-filename></literal>, <literal>
&lt;?html-dir></literal> and <literal>&lt;?html-basename></literal>.</para>
<para> <literal>&lt;?html-filename path/name.ext></literal> sets the name
of the HTML file for the component in which it occurs (note: if the component
contains chunk-level subcomponents without their own <literal>&lt;?html-filename>
</literal>'s, all of them will get the same filename, wreaking havoc). <literal>
&lt;?html-basename base></literal> sets the base name (upon which sub-component
numbers will be appended) for a component. <literal>&lt;?html-dir dir></literal>
sets the directory in which generated HTML files should be placed. Must be
relative, and below, the starting directory.</para>
</listitem>
<listitem><para>Made <sgmltag>CITETITLE</sgmltag> italic.</para>
</listitem>
<listitem><para>Changed to the new method for generating <sgmltag>XREF</sgmltag>
text. See the top of <filename>dblink.dsl</filename>.</para>
</listitem>
<listitem><para>Added <literal>(dirctory-depth)</literal>, <literal>(copy-string)
</literal>, and <literal>(node-list-filter-by-gi)</literal> to library.</para>
</listitem>
<listitem><para>Added new config parameters: <literal>%generate-part-toc%
</literal>, <literal>%html-ext%</literal>, <literal>%use-id-as-filename%</literal>,
and <literal>%html-meta-tags%</literal>.</para>
</listitem>
<listitem><para>Made REFMETA <literal>(empty-sosofo)</literal>. Need to grab
 this info elsewhere to get reasonable HTML formatting, IMHO.</para>
</listitem>
<listitem><para>Changed default TITLE to be a bold string, not an H2.</para>
</listitem>
<listitem><para>Rearranged code in <filename>dblib.dsl</filename>, <filename>
dbhtml.dsl</filename>, and <filename>dbnavig.dsl</filename> (new file). </para>
</listitem>
</itemizedlist></para>
</listitem></varlistentry>
<varlistentry>
<term>In 0.1</term><listitem>
<itemizedlist>
<listitem><para> A transmogrification of the print style sheet, so most  elements
are supported</para>
</listitem>
<listitem><para> Support for FOOTNOTE and FOOTNOTEREF, even in tables </para>
</listitem>
<listitem><para> Automatic chunking at the component and SECT1 level </para>
</listitem>
<listitem><para> A navigation system that I'm fond of, but lacking any  real
hooks for customization</para>
</listitem>
<listitem><para> Uses DIV to mark elements so that a browser style sheet could
do even more style stuff</para>
</listitem>
<listitem><para> Optional screened verbatim displays (an idea from Richard
Burton's style sheet).</para>
</listitem>
</itemizedlist>
</listitem></varlistentry>
</variablelist>
<para>This summary is fairly terse. If you have more detailed questions, ask
the maintainer ;-). I've gone to considerable lengths to generalize the features
of this stylesheet and provide hooks for customization. If you have a need
that doesn't seem to have been addressed, feel free to ask me about it.</para>
</article>]]>
<?Pub *0000027362>
