;; $Id: dbmath.dsl,v 1.1.1.5 1999/01/28 15:22:50 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(define %equation-autolabel% #f)

(element equation ($semiformal-object$))

(element (equation title) (empty-sosofo))
(element (equation alt) (empty-sosofo))
(element (equation graphic)
  (let ((alttag (select-elements (children (parent)) (normalize "alt"))))
    (if alttag
	($img$ (current-node) (data alttag))
	($img$))))

(element informalequation
  ;; Derived from informal-object
  (if %equation-autolabel%
      (let ((label  (element-label (current-node))))
	(make element gi: "TABLE"
	      attributes: '(("CLASS" "INFORMALEQUATION")
			    ("WIDTH" "100%")
			    ("BORDER" "0"))
	    (make element gi: "TR"
	      (make element gi: "TD"
		    attributes: '(("VALIGN" "MIDDLE"))
		    (process-children))
	      (make element gi: "TD"
		    attributes: '(("VALIGN" "MIDDLE")
				  ("WIDTH" "100"))
		    (literal "(" label ")")))))
      ($informal-object$)))

(element (informalequation alt) (empty-sosofo))
(element (informalequation graphic) 
  (let ((alttag (select-elements (children (parent)) (normalize "alt"))))
    (if alttag
	($img$ (current-node) (data alttag))
	($img$))))

(element inlineequation ($inline-object$))
(element (inlineequation alt) (empty-sosofo))
(element (inlineequation graphic) 
  (let ((alttag (select-elements (children (parent)) (normalize "alt"))))
    (if alttag
	($img$ (current-node) (data alttag))
	($img$))))
