/*
	hal_clock.c

pjo, 5 oct 1999
*/


#	include "cyg/hal/hal_intr.h"


void pc_outb(int port, int value) ;
int pc_inb(int port) ;

void hal_clock_initialize(cyg_uint32 period)
{
/* Select mode 3: square wave.  Then we'll load LSB, and finally MSB. */
	pc_outb(PC_PIT_CONTROL, 0x36) ;
	pc_outb(PC_PIT_CLOCK_0, period);			/* Only the LSB makes it to the bus. */
	pc_outb(PC_PIT_CLOCK_0, period >> 8);		/* Now the second 8 bits. */
}


void hal_clock_read(cyg_uint32 * count)
{
/* Latch counter 0. */
	pc_outb(PC_PIT_CONTROL, 0x00);

/* Now get the value. */
	count[0] = pc_inb(PC_PIT_CLOCK_0) & 0xFF ;
	count[0] |= ((pc_inb(PC_PIT_CLOCK_0) & 0xFF) << 8);
}


