import junit.framework.TestSuite;
import junit.framework.TestResult;
import junit.framework.AssertionFailedError;
import junit.textui.ResultPrinter;
import junit.framework.Test;
import java.io.PrintStream;

public class TestRunner
    extends junit.textui.TestRunner
{
    TestRunner (ResultPrinter resultPrinter)
    {
	super (resultPrinter);
    }

    public static class Results
	extends ResultPrinter
    {
	// Does this have a race condition?
	boolean pass = false;
	public void startTest (Test test)
	{
	    System.out.print ("Running ");
	    System.out.print (test);
	    System.out.print (" ...");
	    System.out.flush ();
	    pass = true;
	}
	public void endTest (Test test)
	{
	    if (pass)
		System.out.println ("PASS");
	    else
		System.out.println ();
	}
	private void printProblem (String what, Throwable t)
        {
	    System.out.println (what);
	    System.out.print ("  ");
	    System.out.print (t);
        }

	public void addError (Test test, java.lang.Throwable t)
	{
	    printProblem ("ERROR", t);
	    pass = false;
	}
	public void addFailure (Test test, AssertionFailedError t)
	{
	    printProblem ("FAIL", t);
	    pass = false;
	}
	// Constructor.
	Results (PrintStream stream)
	{
	    super (stream);
	}
    }

    static Class[] testClasses = new Class[] {
            frysk.event.TestEventLoop.class,
            frysk.proc.TestExec.class,
            frysk.proc.TestGoAndGo.class,
            frysk.proc.TestHostGet.class,
            frysk.proc.TestI386Modify.class,
            frysk.proc.TestI386Regs.class,
            frysk.proc.TestModify.class,
            frysk.proc.TestPaused.class,
            frysk.proc.TestProcGet.class,
            frysk.proc.TestProcStates.class,
            frysk.proc.TestRefresh.class,
            frysk.proc.TestRun.class,
            frysk.proc.TestStep.class,
            frysk.proc.TestStopAndGo.class,
            frysk.proc.TestStopAndStop.class,
            frysk.proc.TestStop.class,
            frysk.proc.TestSyscall2.class,
            frysk.proc.TestSyscallInterrupt.class,
            frysk.proc.TestSyscall.class,
            frysk.proc.TestSyscallOpen.class,
            frysk.proc.TestTaskClonedObserver.class,
            frysk.proc.TestTaskForkedObserver.class,
            frysk.proc.TestTaskObserverBlocked.class,
            frysk.proc.TestTaskObserverDetach.class,
            frysk.proc.TestTaskObserver.class,
            frysk.proc.TestTaskTerminateObserver.class,
            frysk.proc.TestUnpaused.class,
	};
    public static void main (String[] args)
    {
	TestRunner runner = new TestRunner (new Results (System.out));
        TestSuite testSuite = new TestSuite ();
        int repeats = 1;
        if (args.length > 0) {
	    // Construct the testsuite from the list of names.
            for (int i = 0; i < args.length; i++) {
                if (args[i].charAt (0) == '-')
		    repeats = -Integer.parseInt (args[i]);
                else
                    testSuite.addTest (runner.getTest (args[i]));
            }
        }
        else {
	    for (int i = 0; i < testClasses.length; i++) {
                testSuite.addTest (new TestSuite (testClasses[i]));
            }
        }
        try {
	    for (int i = 0; i < repeats; i++) {
	        TestResult testResult = runner.doRun (testSuite);
	        if (!testResult.wasSuccessful()) 
		    System.exit (FAILURE_EXIT);
            }
	    System.exit(SUCCESS_EXIT);
	} catch(Exception e) {
	    System.err.println(e.getMessage());
	    System.exit (EXCEPTION_EXIT);
	}
    }
}
