// This file is part of the program FRYSK.
//
// Copyright 2005, Red Hat Inc.
//
// FRYSK is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// FRYSK is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with FRYSK; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
// 
// In addition, as a special exception, Red Hat, Inc. gives You the
// additional right to link the code of FRYSK with code not covered
// under the GNU General Public License ("Non-GPL Code") and to
// distribute linked combinations including the two, subject to the
// limitations in this paragraph. Non-GPL Code permitted under this
// exception must only link to the code of FRYSK through those well
// defined interfaces identified in the file named EXCEPTION found in
// the source code files (the "Approved Interfaces"). The files of
// Non-GPL Code may instantiate templates or use macros or inline
// functions from the Approved Interfaces without causing the
// resulting work to be covered by the GNU General Public
// License. Only Red Hat, Inc. may make changes or additions to the
// list of Approved Interfaces. You must obey the GNU General Public
// License in all respects for all of the FRYSK code and other code
// used in conjunction with FRYSK except the Non-GPL Code covered by
// this exception. If you modify this file, you may extend this
// exception to your version of the file, but you are not obligated to
// do so. If you do not wish to provide this exception without
// modification, you must delete this exception statement from your
// version and license this file solely under the GPL without
// exception.
/*
 * Created on 5-Jul-05
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package frysk.gui.monitor;

import java.util.logging.Level;
import java.util.prefs.Preferences;

import org.gnu.glade.LibGlade;
import org.gnu.gtk.TextBuffer;
import org.gnu.gtk.TextMark;
import org.gnu.gtk.TextView;
import org.gnu.gtk.Widget;

/**
 * 
 * Generic log window, just prints out events it receives.
 * */
public class SummaryWidget extends Widget implements Saveable {

	public TextView logTextView;
    private TextBuffer tb;
    private TextMark tm;
    private GuiObject currentObject;
    
	public SummaryWidget(LibGlade glade){
		super(glade.getWidget("logWidget").getHandle());
		this.logTextView = (TextView) glade.getWidget("logTextView");
		WindowManager.logger.log(Level.FINE, "{0} LogWidget\n", this);
		tb = logTextView.getBuffer();
		tm = tb.createMark("endMark", tb.getEndIter(), false);
	}

	public void setCurrentObject(GuiObject object){
      this.currentObject = object;
      tb.deleteText(tb.getStartIter(), tb.getEndIter());
      print(currentObject.getSummary());
    }
    
    /**
     * Print the given string to the log window.
     * 
     * @param string - string to print.
     */
    private void print(String string){
        tb.insertText(string);
        tb.moveMark(tm, tb.getEndIter());
       // logTextView.scrollToMark(tm,0.0);
    }
    
	/* (non-Javadoc)
	 * @see frysk.gui.monitor.Saveable#save(java.util.prefs.Preferences)
	 */
	public void save(Preferences prefs) {
		
	}
	
	/* (non-Javadoc)
	 * @see frysk.gui.monitor.Saveable#load(java.util.prefs.Preferences)
	 */
	public void load(Preferences prefs) {
		
	}
}
