// Iostreams base classes -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

#ifndef _CPP_BITS_IOSBASE_H
#define _CPP_BITS_IOSBASE_H 1

#undef _G_HAVE_PRINTF_FP
#undef _IO_USE_DTOA

namespace std {

  // nonmember streamoff, streamsize and fpos<> definitions
  // have been moved to char_traits.h.

  // The following definitions of bitmask types are enums, not ints,
  // as permitted (but not required) in the standard, in order to provide
  // better type safety in iostream calls.  A side effect is that
  // expressions involving them are no longer compile-time constants.

  enum _Ios_Fmtflags { _S_ios_fmtflags_end = INT_MAX };
  inline _Ios_Fmtflags operator& (_Ios_Fmtflags __a, _Ios_Fmtflags __b)
    { return _Ios_Fmtflags(int (__a) & int (__b)); }
  inline _Ios_Fmtflags operator| (_Ios_Fmtflags __a, _Ios_Fmtflags __b)
    { return _Ios_Fmtflags(int (__a) | int (__b)); }
  inline _Ios_Fmtflags operator^ (_Ios_Fmtflags __a, _Ios_Fmtflags __b)
    { return _Ios_Fmtflags(int (__a) ^ int (__b)); }
  inline _Ios_Fmtflags operator|= (_Ios_Fmtflags& __a, _Ios_Fmtflags __b)
    { return __a = __a | __b; }
  inline _Ios_Fmtflags operator&= (_Ios_Fmtflags& __a, _Ios_Fmtflags __b)
    { return __a = __a & __b; }
  inline _Ios_Fmtflags operator^= (_Ios_Fmtflags& __a, _Ios_Fmtflags __b)
    { return __a = __a ^ __b; }
  inline _Ios_Fmtflags operator~ (_Ios_Fmtflags __a)
    { return _Ios_Fmtflags (~int (__a)); }


  enum _Ios_Openmode { _S_ios_openmode_end = INT_MAX };
  inline _Ios_Openmode operator& (_Ios_Openmode __a, _Ios_Openmode __b)
    { return _Ios_Openmode(int (__a) & int (__b)); }
  inline _Ios_Openmode operator| (_Ios_Openmode __a, _Ios_Openmode __b)
    { return _Ios_Openmode(int (__a) | int (__b)); }
  inline _Ios_Openmode operator^ (_Ios_Openmode __a, _Ios_Openmode __b)
    { return _Ios_Openmode(int (__a) ^ int (__b)); }
  inline _Ios_Openmode operator|= (_Ios_Openmode& __a, _Ios_Openmode __b)
    { return __a = __a | __b; }
  inline _Ios_Openmode operator&= (_Ios_Openmode& __a, _Ios_Openmode __b)
    { return __a = __a & __b; }
  inline _Ios_Openmode operator^= (_Ios_Openmode& __a, _Ios_Openmode __b)
    { return __a = __a ^ __b; }
  inline _Ios_Openmode operator~ (_Ios_Openmode __a)
    { return _Ios_Openmode (~int (__a)); }

  enum _Ios_Seekdir { _S_ios_Seekdir_end = INT_MAX };

  // _Ios_Iostate (used to define ios_base::iostate is defined
  // in bits/std_iosfwd.h.

  // 27.4.2  Class ios_base
  class ios_base
  {
  public:
    // 27.4.2.1.1  Class ios_base::failure
    class failure : public exception
    {
      const string _M_what;
    public:
      explicit failure (const string& __msg) : _M_what (__msg) { }
      virtual const char* what () const { return _M_what.c_str (); }
    };

    // 27.4.2.1.2  Type ios_base::fmtflags
    typedef _Ios_Fmtflags fmtflags;
    // 27.4.2.1.2  Type fmtflags
    // We use the bit values from libio if possible
    static const fmtflags boolalpha =   fmtflags(_IO_BOOLALPHA);
    static const fmtflags dec =         fmtflags(_IO_DEC);
    static const fmtflags fixed =       fmtflags(_IO_FIXED);
    static const fmtflags hex =         fmtflags(_IO_HEX);
    static const fmtflags internal =    fmtflags(_IO_INTERNAL);
    static const fmtflags left =        fmtflags(_IO_LEFT);
    static const fmtflags oct =         fmtflags(_IO_OCT);
    static const fmtflags right =       fmtflags(_IO_RIGHT);
    static const fmtflags scientific =  fmtflags(_IO_SCIENTIFIC);
    static const fmtflags showbase =    fmtflags(_IO_SHOWBASE);
    static const fmtflags showpoint =   fmtflags(_IO_SHOWPOINT);
    static const fmtflags showpos =     fmtflags(_IO_SHOWPOS);
    static const fmtflags skipws =      fmtflags(_IO_SKIPWS);
    static const fmtflags unitbuf =     fmtflags(_IO_UNITBUF);
    static const fmtflags uppercase =   fmtflags(_IO_UPPERCASE);
    static const fmtflags adjustfield = fmtflags(_IO_LEFT | _IO_RIGHT |
                                                 _IO_INTERNAL);
    static const fmtflags basefield =   fmtflags(_IO_DEC | _IO_OCT | _IO_HEX);
    static const fmtflags floatfield =  fmtflags(_IO_SCIENTIFIC | _IO_FIXED);

    // 27.4.2.1.3  Type ios_base::iostate
    typedef _Ios_Iostate iostate;
    static const iostate badbit =  iostate(_IO_BAD_SEEN);
    static const iostate eofbit =  iostate(_IO_EOF_SEEN);
    static const iostate failbit = iostate(_IO_ERR_SEEN);
    static const iostate goodbit = iostate(0);

    // XXX deprecated
    typedef int io_state;


    // 27.4.2.1.4  Type openmode
    typedef _Ios_Openmode openmode;
    static const openmode app =    openmode(_IOS_APPEND);
    static const openmode ate =    openmode(_IOS_ATEND);
    static const openmode binary = openmode(_IOS_BIN);
    static const openmode in =     openmode(_IOS_INPUT);
    static const openmode out =    openmode(_IOS_OUTPUT);
    static const openmode trunc =  openmode(_IOS_TRUNC);

    // XXX deprecated
    typedef int open_mode;


    // 27.4.2.1.5  Type seekdir
    typedef _Ios_Seekdir seekdir;
#if 1 /* XXX */
    static const seekdir beg = seekdir(0);
    static const seekdir cur = seekdir(1);
    static const seekdir end = seekdir(2);
#else
    static const seekdir beg = seekdir(SEEK_SET);
    static const seekdir cur = seekdir(SEEK_CUR);
    static const seekdir end = seekdir(SEEK_END);
#endif
    // XXX deprecated
    typedef int seek_dir;

    // implementation extensions.

    enum _Fd_selector { _S_fd_in, _S_fd_out };

  private:
    iostate _M_state;
    iostate _M_exceptions;

    // Data members.
    fmtflags _M_flags;
    streamsize _M_precision;
    streamsize _M_width;

    locale _M_locale;

    // 27.4.2.5  Members for iword/pword storage
    struct _Words { void* _M_pword; long _M_iword; };
    static const int _S_local_words = 8;
    _Words  _M_word_array[_S_local_words];  // guaranteed storage
    _Words  _M_dummy;    // used only for failed iword/pword calls.
    _Words* _M_words;
    int     _M_word_limit;
    _Words& _M_grow_words(int __index);

    // 27.4.2.6  callbacks
    struct _Callback_list;
    _Callback_list*  _M_callbacks;

  protected:
    void _M_dispose_callbacks();
    void _M_init();
    void _M_copy_base(ios_base& __rhs);

  public:
    iostate rdstate () const { return _M_state; }
    void clear (iostate __state = goodbit);
    iostate exceptions () const { return _M_exceptions; }
    void exceptions (iostate __except)
       { _M_exceptions = __except; this->clear (rdstate ()); }


    // 27.4.2.1.6  Class ios_base::Init
    // Used to initialize standard streams. Not needed in this implementation.
    struct Init { Init () { } };

    // Fmtflags state:
    inline fmtflags flags () const { return _M_flags; }
    inline fmtflags flags (fmtflags __fmtfl);
    inline fmtflags setf (fmtflags __fmtfl);
    inline fmtflags setf (fmtflags __fmtfl, fmtflags __mask);
    inline void unsetf (fmtflags __mask) { _M_flags &= ~__mask; }

    inline streamsize precision () const { return _M_precision; }
    inline streamsize precision (streamsize __prec);
    inline streamsize width () const { return _M_width; }
    inline streamsize width (streamsize __wide);

    // Locales:
    locale imbue (const locale& __loc);
    inline locale getloc () const { return _M_getloc (); }
    inline const locale& _M_getloc () const { return _M_locale; }

    // Storage:
    static int xalloc () throw();
    inline long& iword (int __index);
    inline void*& pword (int __index);

    // Destructor
    ~ios_base ();

    // Callbacks;
    enum event
    {
      erase_event,
      imbue_event,
      copyfmt_event
    };
    typedef void (*event_callback) (event, ios_base&, int __index);
    void register_callback (event_callback __fn, int __index);

    static bool sync_with_stdio (bool __sync = true);	// ### TODO

  protected:
    void _M_call_callbacks (event __ev) throw();

    ios_base ();
  };

  // ios_base inlines:

  inline ios_base::fmtflags
  ios_base::flags (fmtflags __fmtfl)
    { fmtflags __old = _M_flags; _M_flags = __fmtfl; return __old; }

  inline ios_base::fmtflags
  ios_base::setf (fmtflags __fmtfl)
    { fmtflags __old = _M_flags; _M_flags |= __fmtfl; return __old; }

  inline ios_base::fmtflags
  ios_base::setf (fmtflags __fmtfl, fmtflags __mask)
    {
      fmtflags __old = _M_flags;
      _M_flags = (_M_flags & ~__mask) | (__fmtfl & __mask);
      return __old;
    }

  inline streamsize
  ios_base::precision (streamsize __prec)
    { streamsize __old = _M_precision; _M_precision = __prec; return __old; }

  inline streamsize
  ios_base::width (streamsize __wide)
    { streamsize __old = _M_width; _M_width = __wide; return __old; }


  // 27.4.2.5  Members for iword/pword storage

  inline void*&
  ios_base::pword (int __ix)
  {
    _Words& __word = (__ix < _M_word_limit) ?
      _M_words[__ix] : _M_grow_words (__ix);
    return __word._M_pword;
  }

  inline long&
  ios_base::iword (int __ix)
  {
    _Words& __word = (__ix < _M_word_limit) ?
       _M_words[__ix] : _M_grow_words (__ix);
    return __word._M_iword;
  }

  // Manipulators:
  ios_base& boolalpha (ios_base& __str);
  ios_base& noboolalpha (ios_base& __str);
  ios_base& showbase (ios_base& __str);
  ios_base& noshowbase (ios_base& __str);
  ios_base& showpoint (ios_base& __str);
  ios_base& noshowpoint (ios_base& __str);
  ios_base& showpos (ios_base& __str);
  ios_base& noshowpos (ios_base& __str);
  ios_base& skipws (ios_base& __str);
  ios_base& noskipws (ios_base& __str);
  ios_base& uppercase (ios_base& __str);
  ios_base& nouppercase (ios_base& __str);
  ios_base& unitbuf (ios_base& __str);
  ios_base& nounitbuf (ios_base& __str);

  // Adjustfield:
  ios_base& internal (ios_base& __str);
  ios_base& left (ios_base& __str);
  ios_base& right (ios_base& __str);

  // Basefield:
  ios_base& dec (ios_base& __str);
  ios_base& hex (ios_base& __str);
  ios_base& oct (ios_base& __str);

  // Floatfield:
  ios_base& fixed (ios_base& __str);
  ios_base& scientific (ios_base& __str);

} // namespace std

#endif /* _CPP_BITS_IOSBASE_H */
