// The template and inlines for the -*- C++ -*- internal _Array helper class.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_BITS_ARRAY_H
#define _CPP_BITS_ARRAY_H

#include <bits/c++config.h>
#include <bits/std_cstdlib.h>
#include <bits/std_algorithm.h>

namespace std {

template<typename _Tp> struct _Array {

    explicit _Array (size_t);
    explicit _Array (_Tp* const);
    explicit _Array (const valarray<_Tp>&);
    _Array (const _Tp*, size_t);

    void free_data() const;
    _Tp* begin () const;
    
    _Tp* const _M_data;
};

template<typename _Tp>
inline _Array<_Tp>::_Array (size_t __n) : _M_data (new _Tp[__n]) {}

template<typename _Tp>
inline _Array<_Tp>::_Array (_Tp* const __p) : _M_data (__p) {}

template<typename _Tp>
inline _Array<_Tp>::_Array (const valarray<_Tp>& __v) 
  : _M_data (__v._M_data) {}

template<typename _Tp>
inline _Array<_Tp>::_Array (const _Tp* __b, size_t __s) 
  : _M_data (new _Tp[__s]) { copy (__b, __b+__s, _M_data); }

template<typename _Tp>
inline void
_Array<_Tp>::free_data() const { delete[] _M_data; }

template<typename _Tp>
inline _Tp*
_Array<_Tp>::begin () const
  { return _M_data; }

template<typename _Tp>
inline void
__valarray_fill (_Array<_Tp> __a, size_t __n, const _Tp& __t)
  { fill (__a._M_data, __a._M_data + __n, __t); }

template<typename _Tp>
inline void
__valarray_fill (_Array<_Tp> __a, size_t __n, size_t __s, const _Tp& __t)
{
    for (_Tp* __p=__a._M_data; __p<__a._M_data+__s*__n; __p+=__s) *__p = __t;
}

template<typename _Tp>
inline void
__valarray_fill (_Array<_Tp> __a, _Array<size_t> __i, 
		 size_t __n, const _Tp& __t)
{
    for (size_t* __j=__i._M_data; __j<__i._M_data+__n; ++__j) 
      __a._M_data[*__j] = __t;
}

// Typical use: copy a plain _Array<_Tp> in a plain _Array<_Tp> 
// size(_a) == __n 
template<typename _Tp>
inline void
__valarray_copy (_Array<_Tp> __a, size_t __n, _Array<_Tp> __b)
  { copy (__a._M_data, __a._M_data+__n, __b._M_data); }

// Typical use: copy a strided _Array<_Tp> in a plain _Array<T>
// size(__a) == __n && stride(__a) == __s
template<typename _Tp>
inline void
__valarray_copy (_Array<_Tp> __a, size_t __n, size_t __s, _Array<_Tp> __b)
{
    _Tp* __q (__b._M_data);
    for (_Tp* __p=__a._M_data; __p<__a._M_data+__s*__n; __p+=__s, ++__q) 
      *__q = *__p;
}

// Typical use: copy a plain _Array<T> in a strided _Array<T>
// size(__b) == __n && stride(__b) == __s
template<typename _Tp>
inline void
__valarray_copy (_Array<_Tp> __a, _Array<_Tp> __b, size_t __n, size_t __s)
{
    _Tp* __q (__b._M_data);
    for (_Tp* __p=__a._M_data; __p<__a._M_data+__n; ++__p, __q+=__s)
      *__q = *__p;
}

// Typical use: copy an indexed _Array<T> in a plain _Array<T>
template<typename _Tp>
inline void
__valarray_copy (_Array<_Tp> __a, _Array<size_t> __i, 
		 _Array<_Tp> __b, size_t __n)
{
    _Tp* __q (__b._M_data);
    for (size_t* __j=__i._M_data; __j<__i._M_data+__n; ++__j, ++__q)
      *__q = __a._M_data[*__j];
}

// Typical use: copy a plain _Array<T> in an indexed _Array<T>
template<typename _Tp>
inline void
__valarray_copy (_Array<_Tp> __a, size_t __n, _Array<_Tp> __b, 
		 _Array<size_t> __i)
{
    _Tp* __p (__a._M_data);
    for (size_t* __j=__i._M_data; __j<__i._M_data+__n; ++__j, ++__p)
      __b._M_data[*__j] = *__p;
}

#undef _DEFINE_VALARRAY_FUNCTION
#define _DEFINE_VALARRAY_FUNCTION(op, name)				\
template<typename _Tp>							\
inline void								\
_Array_augmented_##name (_Array<_Tp> __a, size_t __n, const _Tp& __t)	\
{									\
    for (_Tp* __p=__a._M_data; __p<__a._M_data+__n; ++__p) 		\
      *__p op##= __t;							\
}									\
									\
template<typename _Tp>							\
inline void								\
_Array_augmented_##name (_Array<_Tp> __a, size_t __n, _Array<_Tp> __b)	\
{									\
    _Tp* __p (__a._M_data);						\
    for (_Tp* __q=__b._M_data; __q<__b._M_data+__n; ++__p, ++__q) 	\
      *__p op##= *__q;							\
}									\
									\
template<typename _Tp, class _Expr>					\
void									\
_Array_augmented_##name (_Array<_Tp> __a, 				\
                         const _Meta<_Expr,_Tp>& __e, size_t __n)	\
{									\
    _Tp* __p (__a._M_data);						\
    for (size_t __i=0; __i<__n; ++__i, ++__p) *__p op##= __e[__i];	\
}									\
									\
template<typename _Tp>							\
inline void								\
_Array_augmented_##name (_Array<_Tp> __a, size_t __n, size_t __s, 	\
			 _Array<_Tp> __b)				\
{					       				\
    _Tp* __q (__b._M_data);						\
    for (_Tp* __p=__a._M_data; __p<__a._M_data+__s*__n; __p+=__s, ++__q) \
      *__p op##= *__q;							\
}									\
									\
template<typename _Tp>							\
inline void								\
_Array_augmented_##name (_Array<_Tp> __a, _Array<_Tp> __b, 		\
			 size_t __n, size_t __s)			\
{									\
    _Tp* __q (__b._M_data);						\
    for (_Tp* __p=__a._M_data; __p<__a._M_data+__n; ++__p, __q+=__s)	\
      *__p op##= *__q;							\
}									\
									\
template<typename _Tp, class _Expr>					\
void									\
_Array_augmented_##name (_Array<_Tp> __a, size_t __s,			\
                          const _Meta<_Expr,_Tp>& __e, size_t __n)	\
{									\
    _Tp* __p (__a._M_data);						\
    for (size_t __i=0; __i<__n; ++__i, __p+=__s) *__p op##= __e[__i];	\
}									\
									\
template<typename _Tp>							\
inline void								\
_Array_augmented_##name (_Array<_Tp> __a, _Array<size_t> __i,		\
                          _Array<_Tp> __b, size_t __n)			\
{									\
    _Tp* __q (__b._M_data);						\
    for (size_t* __j=__i._M_data; __j<__i._M_data+__n; ++__j, ++__q)	\
        __a._M_data[*__j] op##= *__q;					\
}									\
									\
template<typename _Tp>							\
inline void								\
_Array_augmented_##name (_Array<_Tp> __a, size_t __n,			\
                          _Array<_Tp> __b, _Array<size_t> __i)		\
{									\
    _Tp* __p (__a._M_data);						\
    for (size_t* __j=__i._M_data; __j<__i._M_data+__n; ++__j, ++__p)	\
        *__p op##= __b._M_data[*__j];					\
}									\
									\
template<typename _Tp, class _Expr>					\
void									\
_Array_augmented_##name (_Array<_Tp> __a, _Array<size_t> __i,		\
                          const _Meta<_Expr, _Tp>& __e, size_t __n)	\
{									\
    size_t* __j (__i._M_data);						\
    for (size_t __k=0; __k<__n; ++__k, ++__j) 				\
      __a._M_data[*__j] op##= __e[__k];					\
}									\
									\
template<typename _Tp>							\
void									\
_Array_augmented_##name (_Array<_Tp> __a, _Array<bool> __m,		\
                          _Array<_Tp> __b, size_t __n)			\
{									\
    bool* ok (__m._M_data);						\
    _Tp* __p (__a._M_data);						\
    for (_Tp* __q=__b._M_data; __q<__b._M_data+__n; ++__q, ++ok, ++__p) { \
        while (! *ok) {							\
            ++ok;							\
            ++__p;							\
        }								\
        *__p op##= *__q;						\
    }									\
}									\
									\
template<typename _Tp>							\
void									\
_Array_augmented_##name (_Array<_Tp> __a, size_t __n,			\
                         _Array<_Tp> __b, _Array<bool> __m)		\
{									\
    bool* ok (__m._M_data);						\
    _Tp* __q (__b._M_data);						\
    for (_Tp* __p=__a._M_data; __p<__a._M_data+__n; ++__p, ++ok, ++__q) { \
        while (! *ok) {							\
            ++ok;							\
            ++__q;							\
        }								\
        *__p op##= *__q;						\
    }									\
}									\
									\
template<typename _Tp, class _Expr>					\
void									\
_Array_augmented_##name (_Array<_Tp> __a, _Array<bool> __m,		\
                          const _Meta<_Expr, _Tp>& __e, size_t __n)	\
{									\
    bool* ok(__m._M_data);						\
    _Tp* __p (__a._M_data);						\
    for (size_t __i=0; __i<__n; ++__i, ++ok, ++__p) {			\
        while (! *ok) {							\
            ++ok;							\
            ++__p;							\
        }								\
        *__p op##= __e[__i];						\
    }									\
}

_DEFINE_VALARRAY_FUNCTION(+, plus)
_DEFINE_VALARRAY_FUNCTION(-, minus)
_DEFINE_VALARRAY_FUNCTION(*, multiplies)
_DEFINE_VALARRAY_FUNCTION(/, divides)
_DEFINE_VALARRAY_FUNCTION(%, modulus)
_DEFINE_VALARRAY_FUNCTION(^, xor)
_DEFINE_VALARRAY_FUNCTION(|, or)
_DEFINE_VALARRAY_FUNCTION(&, and)    
_DEFINE_VALARRAY_FUNCTION(<<, shift_left)
_DEFINE_VALARRAY_FUNCTION(>>, shift_right)

#undef _DEFINE_VALARRAY_FUNCTION    

} // std::

#ifdef _G_NO_TEMPLATE_EXPORT
# define export 
# include <bits/valarray_array.tcc>    
#endif
           
#endif /* _CPP_BITS_ARRAY_H */

// Local Variables:
// mode:c++
// End:
