/* Low-level implementation of bitset template class from ISO C++.  */

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

#include <bits/std_bitset.h>
#include <bits/std_climits.h>


static const size_t word_bits = sizeof (__bitset_word) * CHAR_BIT;


void
__bitset_base_lshift (__bitset_word *arr, size_t n, size_t nlast,
		      size_t offset, size_t nbits)
{
  arr[n - 1] = arr[n - 1 - offset] << nbits;

  for (size_t cnt = n - 1; cnt > offset; --cnt)
    {
      arr[cnt] |= arr[cnt - 1 - offset] >> (word_bits - nbits);
      arr[cnt - 1] = arr[cnt - 1 - offset] << nbits;
    }

  memset (arr, '\0', offset * sizeof (__bitset_word));
}


void
__bitset_base_rshift (__bitset_word *arr, size_t n, size_t nlast,
		      size_t offset, size_t nbits)
{
  arr[0] = arr[offset] >> nbits;

  for (size_t cnt = offset + 1; cnt < n; ++cnt)
    {
      arr[cnt - 1 - offset] |= arr[cnt] << (word_bits - nbits);
      arr[cnt - offset] = arr[cnt] >> nbits;
    }

  memset (&arr[n - offset], '\0', offset * sizeof (__bitset_word));
}


size_t
__bitset_base_count (__bitset_word *arr, size_t n)
{
  size_t result = 0;

  while (n > 0)
    {
      __bitset_word word = arr[n];

      if (sizeof (__bitset_word) == 4)
	{
	  word = (word & 0x55555555) + ((word >> 1) & 0x55555555);
	  word = (word & 0x33333333) + ((word >> 2) & 0x33333333);
	  word = (word + (word >> 4)) & 0x0f0f0f0f;
	  word = word + (word >> 8);
	  word = (word + (word >> 16)) & 0xff;
	}
      else
	{
	  // The only other possibility is a 64 bit word.
	  word = ((word & ((0x55555555UL << 16) << 16 | 0x55555555UL))
		  + ((word >> 1)
		     & ((0x55555555UL << 16) << 16 | 0x55555555UL)));
	  word = ((word & ((0x33333333UL << 16) << 16 | 0x33333333UL))
		  + ((word >> 1)
		     & ((0x33333333UL << 16) << 16 | 0x33333333UL)));
	  word = ((word + (word >> 4))
		  & ((0x0f0f0f0fUL << 16) << 16 | 0x0f0f0f0fUL));
	  word = (word + (word >> 8));
	  word = (word + (word >> 16));
	  word = (word + ((word >> 16) >> 16)) & 0xff;
	}

      result += word;
    }

  return result;
}
